/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.document.model.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.backend.document.model.spi.AbstractIndexField;
import org.hibernate.search.engine.backend.document.model.spi.IndexCompositeNode;
import org.hibernate.search.engine.backend.document.model.spi.IndexField;
import org.hibernate.search.engine.backend.document.model.spi.IndexObjectField;
import org.hibernate.search.engine.backend.document.model.spi.IndexValueField;
import org.hibernate.search.engine.backend.types.spi.AbstractIndexCompositeNodeType;
import org.hibernate.search.engine.common.tree.spi.TreeNodeInclusion;
import org.hibernate.search.engine.search.common.spi.SearchIndexSchemaElementContextHelper;
import org.hibernate.search.engine.search.common.spi.SearchIndexScope;

public abstract class AbstractIndexObjectField<S extends AbstractIndexObjectField<S, SC, NT, C, F>, SC extends SearchIndexScope<?>, NT extends AbstractIndexCompositeNodeType<SC, ? super S>, C extends IndexCompositeNode<SC, NT, F>, F extends IndexField<SC, ?>>
extends AbstractIndexField<S, SC, NT, C>
implements IndexObjectField<SC, NT, C, F> {
    private final List<String> nestedPathHierarchy;
    private final Map<String, F> staticChildrenByName;

    public AbstractIndexObjectField(C parent, String relativeFieldName, NT type, TreeNodeInclusion inclusion, boolean multiValued, Map<String, F> notYetInitializedStaticChildren) {
        super(parent, relativeFieldName, type, inclusion, multiValued);
        List<String> theNestedPathHierarchy = parent.nestedPathHierarchy();
        if (((AbstractIndexCompositeNodeType)type).nested()) {
            theNestedPathHierarchy = new ArrayList<String>(theNestedPathHierarchy);
            theNestedPathHierarchy.add(this.absolutePath);
        }
        this.nestedPathHierarchy = Collections.unmodifiableList(theNestedPathHierarchy);
        this.staticChildrenByName = Collections.unmodifiableMap(notYetInitializedStaticChildren);
    }

    @Override
    public final boolean isRoot() {
        return false;
    }

    @Override
    public final boolean isComposite() {
        return true;
    }

    @Override
    public final boolean isObjectField() {
        return true;
    }

    @Override
    public final boolean isValueField() {
        return false;
    }

    public final S toObjectField() {
        return (S)((AbstractIndexObjectField)this.self());
    }

    @Override
    public IndexValueField<SC, ?, C> toValueField() {
        return (IndexValueField)SearchIndexSchemaElementContextHelper.throwingToValueField(this);
    }

    @Override
    public final String absolutePath(String relativeFieldName) {
        return FieldPaths.compose(this.absolutePath(), relativeFieldName);
    }

    @Override
    final SearchIndexSchemaElementContextHelper helper() {
        return SearchIndexSchemaElementContextHelper.COMPOSITE;
    }

    @Override
    public final List<String> nestedPathHierarchy() {
        return this.nestedPathHierarchy;
    }

    @Override
    public final Map<String, F> staticChildrenByName() {
        return this.staticChildrenByName;
    }
}

