/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.classpath.spi;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.common.impl.Throwables;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ClassLoaderHelper {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private ClassLoaderHelper() {
    }

    public static <T> T instanceFromName(Class<T> targetSuperType, String classNameToLoad, ClassResolver classResolver) {
        Object instance;
        Class<?> classToLoad;
        try {
            classToLoad = classResolver.classForName(classNameToLoad);
            instance = ClassLoaderHelper.callNoArgConstructor(classToLoad);
        }
        catch (IllegalAccessException | InstantiationException | RuntimeException | InvocationTargetException e) {
            throw log.unableToInstantiateClass(classNameToLoad, Throwables.getFirstNonNullMessage((Throwable)e), e);
        }
        return ClassLoaderHelper.verifySuperTypeCompatibility(targetSuperType, instance, classToLoad);
    }

    public static <T> T instanceFromClass(Class<T> targetSuperType, Class<?> classToLoad) {
        Object instance;
        try {
            instance = ClassLoaderHelper.callNoArgConstructor(classToLoad);
        }
        catch (IllegalAccessException | InstantiationException | RuntimeException | InvocationTargetException e) {
            throw log.unableToInstantiateClass(classToLoad.getName(), Throwables.getFirstNonNullMessage((Throwable)e), e);
        }
        return ClassLoaderHelper.verifySuperTypeCompatibility(targetSuperType, instance, classToLoad);
    }

    public static <T> T untypedInstanceFromClass(Class<T> classToLoad) {
        try {
            return ClassLoaderHelper.callNoArgConstructor(classToLoad);
        }
        catch (IllegalAccessException | InstantiationException | RuntimeException | InvocationTargetException e) {
            throw log.unableToInstantiateClass(classToLoad.getName(), Throwables.getFirstNonNullMessage((Throwable)e), e);
        }
    }

    private static <T> T verifySuperTypeCompatibility(Class<T> targetSuperType, Object instance, Class<?> classToLoad) {
        if (!targetSuperType.isInstance(instance)) {
            throw log.subtypeExpected(classToLoad, targetSuperType);
        }
        return (T)instance;
    }

    public static <T> T instanceFromClass(Class<T> targetSuperType, Class<?> classToLoad, Map<String, String> constructorParameter) {
        Object instance;
        try {
            instance = ClassLoaderHelper.callMapArgConstructor(classToLoad, constructorParameter);
        }
        catch (Exception e) {
            throw log.unableToInstantiateClass(classToLoad.getName(), Throwables.getFirstNonNullMessage((Throwable)e), e);
        }
        return ClassLoaderHelper.verifySuperTypeCompatibility(targetSuperType, instance, classToLoad);
    }

    private static void checkInstantiable(Class<?> classToLoad) {
        if (classToLoad.isInterface()) {
            throw log.implementationRequired(classToLoad);
        }
    }

    private static <T> T callNoArgConstructor(Class<T> classToLoad) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        ClassLoaderHelper.checkInstantiable(classToLoad);
        try {
            Constructor<T> constructor = classToLoad.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (SecurityException e) {
            throw log.securityManagerLoadingError(classToLoad, e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw log.noPublicNoArgConstructor(classToLoad);
        }
    }

    private static <T> T callMapArgConstructor(Class<T> classToLoad, Map<String, String> constructorParameter) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        if (constructorParameter == null) {
            constructorParameter = new HashMap<String, String>(0);
        }
        ClassLoaderHelper.checkInstantiable(classToLoad);
        try {
            Constructor<T> singleMapConstructor = classToLoad.getConstructor(Map.class);
            return singleMapConstructor.newInstance(constructorParameter);
        }
        catch (SecurityException e) {
            throw log.securityManagerLoadingError(classToLoad, e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw log.noPublicMapArgConstructor(classToLoad);
        }
    }

    public static <T> Class<? extends T> classForName(Class<T> targetSuperType, String classNameToLoad, ClassResolver classResolver) {
        Class<?> clazzDef = classResolver.classForName(classNameToLoad);
        try {
            return clazzDef.asSubclass(targetSuperType);
        }
        catch (ClassCastException cce) {
            throw log.subtypeExpected(clazzDef, targetSuperType);
        }
    }
}

