/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.spi.ConfigurationState;
import org.hibernate.validator.HibernateValidatorContext;
import org.hibernate.validator.HibernateValidatorFactory;
import org.hibernate.validator.internal.cfg.DefaultConstraintMapping;
import org.hibernate.validator.internal.engine.ConfigurationImpl;
import org.hibernate.validator.internal.engine.ValidatorContextImpl;
import org.hibernate.validator.internal.engine.ValidatorImpl;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorManager;
import org.hibernate.validator.internal.metadata.BeanMetaDataManager;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.provider.MetaDataProvider;
import org.hibernate.validator.internal.metadata.provider.ProgrammaticMetaDataProvider;
import org.hibernate.validator.internal.metadata.provider.XmlMetaDataProvider;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ValidatorFactoryImpl
implements HibernateValidatorFactory {
    private static final Log log = LoggerFactory.make();
    private final MessageInterpolator messageInterpolator;
    private final TraversableResolver traversableResolver;
    private final ParameterNameProvider parameterNameProvider;
    private final ConstraintValidatorManager constraintValidatorManager;
    private final Set<DefaultConstraintMapping> constraintMappings;
    private final ConstraintHelper constraintHelper;
    private final boolean failFast;
    private final XmlMetaDataProvider xmlMetaDataProvider;
    private final Map<ParameterNameProvider, BeanMetaDataManager> beanMetaDataManagerMap;

    public ValidatorFactoryImpl(ConfigurationState configurationState) {
        this.messageInterpolator = configurationState.getMessageInterpolator();
        this.traversableResolver = configurationState.getTraversableResolver();
        this.parameterNameProvider = configurationState.getParameterNameProvider();
        this.beanMetaDataManagerMap = Collections.synchronizedMap(new IdentityHashMap());
        this.constraintHelper = new ConstraintHelper();
        this.constraintMappings = CollectionHelper.newHashSet();
        this.xmlMetaDataProvider = configurationState.getMappingStreams().isEmpty() ? null : new XmlMetaDataProvider(this.constraintHelper, this.parameterNameProvider, configurationState.getMappingStreams());
        Map properties = configurationState.getProperties();
        boolean tmpFailFast = false;
        if (configurationState instanceof ConfigurationImpl) {
            ConfigurationImpl hibernateSpecificConfig = (ConfigurationImpl)configurationState;
            if (hibernateSpecificConfig.getProgrammaticMappings().size() > 0) {
                this.constraintMappings.addAll(hibernateSpecificConfig.getProgrammaticMappings());
            }
            tmpFailFast = hibernateSpecificConfig.getFailFast();
        }
        this.failFast = tmpFailFast = this.checkPropertiesForFailFast(properties, tmpFailFast);
        this.constraintValidatorManager = new ConstraintValidatorManager(configurationState.getConstraintValidatorFactory());
    }

    public Validator getValidator() {
        return this.createValidator(this.constraintValidatorManager.getDefaultConstraintValidatorFactory(), this.messageInterpolator, this.traversableResolver, this.parameterNameProvider, this.failFast);
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorManager.getDefaultConstraintValidatorFactory();
    }

    public ParameterNameProvider getParameterNameProvider() {
        return this.parameterNameProvider;
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(HibernateValidatorFactory.class)) {
            return type.cast(this);
        }
        throw log.getTypeNotSupportedForUnwrappingException(type);
    }

    @Override
    public HibernateValidatorContext usingContext() {
        return new ValidatorContextImpl(this);
    }

    public void close() {
        this.constraintValidatorManager.clear();
        for (BeanMetaDataManager beanMetaDataManager : this.beanMetaDataManagerMap.values()) {
            beanMetaDataManager.clear();
        }
    }

    Validator createValidator(ConstraintValidatorFactory constraintValidatorFactory, MessageInterpolator messageInterpolator, TraversableResolver traversableResolver, ParameterNameProvider parameterNameProvider, boolean failFast) {
        BeanMetaDataManager beanMetaDataManager;
        if (!this.beanMetaDataManagerMap.containsKey(parameterNameProvider)) {
            beanMetaDataManager = new BeanMetaDataManager(this.constraintHelper, parameterNameProvider, this.buildDataProviders(parameterNameProvider));
            this.beanMetaDataManagerMap.put(parameterNameProvider, beanMetaDataManager);
        } else {
            beanMetaDataManager = this.beanMetaDataManagerMap.get(parameterNameProvider);
        }
        return new ValidatorImpl(constraintValidatorFactory, messageInterpolator, traversableResolver, beanMetaDataManager, parameterNameProvider, this.constraintValidatorManager, failFast);
    }

    private List<MetaDataProvider> buildDataProviders(ParameterNameProvider parameterNameProvider) {
        ArrayList<MetaDataProvider> metaDataProviders = CollectionHelper.newArrayList();
        if (this.xmlMetaDataProvider != null) {
            metaDataProviders.add(this.xmlMetaDataProvider);
        }
        if (!this.constraintMappings.isEmpty()) {
            metaDataProviders.add(new ProgrammaticMetaDataProvider(this.constraintHelper, parameterNameProvider, this.constraintMappings));
        }
        return metaDataProviders;
    }

    private boolean checkPropertiesForFailFast(Map<String, String> properties, boolean programmaticConfiguredFailFast) {
        boolean failFast = programmaticConfiguredFailFast;
        String failFastPropValue = properties.get("hibernate.validator.fail_fast");
        if (failFastPropValue != null) {
            boolean tmpFailFast = Boolean.valueOf(failFastPropValue);
            if (programmaticConfiguredFailFast && !tmpFailFast) {
                throw log.getInconsistentFailFastConfigurationException();
            }
            failFast = tmpFailFast;
        }
        return failFast;
    }
}

