/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.postgis;

import java.io.Serializable;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.spatial.GeolatteGeometryJavaTypeDescriptor;
import org.hibernate.spatial.GeolatteGeometryType;
import org.hibernate.spatial.JTSGeometryJavaTypeDescriptor;
import org.hibernate.spatial.JTSGeometryType;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.SpatialFunctionsRegistry;
import org.hibernate.spatial.dialect.postgis.PGGeometryTypeDescriptor;
import org.hibernate.spatial.dialect.postgis.PostgisFunctions;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class PostgisSupport
implements SpatialDialect,
Serializable {
    private final SpatialFunctionsRegistry postgisFunctions;

    public PostgisSupport(SpatialFunctionsRegistry functions) {
        this.postgisFunctions = functions;
    }

    public PostgisSupport() {
        this.postgisFunctions = new PostgisFunctions();
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry, SqlTypeDescriptor wkbType) {
        typeContributions.contributeType((BasicType)new GeolatteGeometryType(wkbType));
        typeContributions.contributeType((BasicType)new JTSGeometryType(wkbType));
        typeContributions.contributeJavaTypeDescriptor((JavaTypeDescriptor)GeolatteGeometryJavaTypeDescriptor.INSTANCE);
        typeContributions.contributeJavaTypeDescriptor(JTSGeometryJavaTypeDescriptor.INSTANCE);
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        this.contributeTypes(typeContributions, serviceRegistry, PGGeometryTypeDescriptor.INSTANCE_WKB_2);
    }

    public SpatialFunctionsRegistry functionsToRegister() {
        return this.postgisFunctions;
    }

    public boolean isSpatial(int typeCode) {
        return typeCode == 1111 || typeCode == PGGeometryTypeDescriptor.INSTANCE_WKB_2.getSqlType();
    }

    @Override
    public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        switch (spatialRelation) {
            case 4: {
                return " ST_within(" + columnName + ",?)";
            }
            case 6: {
                return " ST_contains(" + columnName + ", ?)";
            }
            case 3: {
                return " ST_crosses(" + columnName + ", ?)";
            }
            case 5: {
                return " ST_overlaps(" + columnName + ", ?)";
            }
            case 1: {
                return " ST_disjoint(" + columnName + ", ?)";
            }
            case 7: {
                return " ST_intersects(" + columnName + ", ?)";
            }
            case 2: {
                return " ST_touches(" + columnName + ", ?)";
            }
            case 0: {
                return " ST_equals(" + columnName + ", ?)";
            }
        }
        throw new IllegalArgumentException("Spatial relation is not known by this dialect");
    }

    @Override
    public String getSpatialFilterExpression(String columnName) {
        return "(" + columnName + " && ? ) ";
    }

    @Override
    public String getSpatialAggregateSQL(String columnName, int aggregation) {
        if (aggregation == 1) {
            return "st_extent(" + columnName + ")::geometry";
        }
        throw new IllegalArgumentException("Aggregation of type " + aggregation + " are not supported by this dialect");
    }

    @Override
    public String getDWithinSQL(String columnName) {
        return "ST_DWithin(" + columnName + ",?,?)";
    }

    @Override
    public String getHavingSridSQL(String columnName) {
        return "( ST_srid(" + columnName + ") = ?)";
    }

    @Override
    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        String emptyExpr = " ST_IsEmpty(" + columnName + ") ";
        return isEmpty ? emptyExpr : "( NOT " + emptyExpr + ")";
    }

    @Override
    public boolean supportsFiltering() {
        return true;
    }

    @Override
    public boolean supports(SpatialFunction function) {
        return this.postgisFunctions.get(function.toString()) != null;
    }
}

