/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.builtin.time.impl;

import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.spi.IgnoreAnalyzerBridge;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public abstract class TemporalAccessorStringBridge<T extends TemporalAccessor>
implements TwoWayStringBridge,
IgnoreAnalyzerBridge {
    private static final Log log = LoggerFactory.make();
    private final DateTimeFormatter formatter;
    private final Class<T> type;

    public TemporalAccessorStringBridge(DateTimeFormatter formatter, Class<T> type) {
        this.formatter = formatter;
        this.type = type;
    }

    @Override
    public String objectToString(Object object) {
        if (object == null) {
            return null;
        }
        String formatted = this.formatter.format((TemporalAccessor)object);
        return formatted;
    }

    @Override
    public Object stringToObject(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        try {
            return this.parse(stringValue);
        }
        catch (Exception e) {
            throw log.parseException(stringValue, this.type, e);
        }
    }

    abstract T parse(String var1) throws Exception;
}

