/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

final class HibernateSearchNormalizerCheckingFilter
extends TokenFilter {
    private static final Log log = LoggerFactory.make();
    private static final char TOKEN_SEPARATOR = ' ';
    private final String normalizerName;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final StringBuilder concatenatedTokenBuilder = new StringBuilder();

    protected HibernateSearchNormalizerCheckingFilter(TokenStream input, String normalizerName) {
        super(input);
        this.normalizerName = normalizerName;
    }

    public boolean incrementToken() throws IOException {
        int tokenCount = 0;
        this.concatenatedTokenBuilder.setLength(0);
        while (this.input.incrementToken()) {
            if (++tokenCount > 1) {
                this.concatenatedTokenBuilder.append(' ');
            }
            this.concatenatedTokenBuilder.append((CharSequence)this.termAtt);
        }
        if (tokenCount > 1) {
            this.termAtt.setEmpty().append(this.concatenatedTokenBuilder);
            log.normalizerProducedMultipleTokens(this.normalizerName, tokenCount);
        }
        return tokenCount > 0;
    }
}

