/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.lang.invoke.MethodHandles;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.search.backend.impl.QueueingProcessor;
import org.hibernate.search.backend.impl.WorkQueue;
import org.hibernate.search.backend.impl.WorkQueueSynchronization;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class PostTransactionWorkQueueSynchronization
implements WorkQueueSynchronization {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final QueueingProcessor queueingProcessor;
    private boolean consumed;
    private boolean prepared;
    private final ConcurrentMap<Object, WorkQueueSynchronization> queuePerTransaction;
    private final WorkQueue queue;
    private final WeakReference<Object> transactionIdentifier;

    public PostTransactionWorkQueueSynchronization(Object transactionIdentifier, QueueingProcessor queueingProcessor, ConcurrentMap<Object, WorkQueueSynchronization> queuePerTransaction, ExtendedSearchIntegrator extendedIntegrator) {
        this.transactionIdentifier = new WeakReference<Object>(transactionIdentifier);
        this.queueingProcessor = queueingProcessor;
        this.queuePerTransaction = queuePerTransaction;
        this.queue = new WorkQueue(extendedIntegrator);
    }

    @Override
    public void add(Work work) {
        this.queueingProcessor.add(work, this.queue);
    }

    @Override
    public boolean isConsumed() {
        return this.consumed;
    }

    public void beforeCompletion() {
        if (this.prepared) {
            log.tracef("Transaction's beforeCompletion() phase already been processed, ignoring: %s", this);
        } else {
            log.tracef("Processing Transaction's beforeCompletion() phase: %s", this);
            this.queueingProcessor.prepareWorks(this.queue);
            this.prepared = true;
        }
    }

    public void afterCompletion(int i) {
        try {
            if (3 == i) {
                log.tracef("Processing Transaction's afterCompletion() phase for %s. Performing work.", this);
                this.queueingProcessor.performWorks(this.queue);
            } else {
                log.tracef("Processing Transaction's afterCompletion() phase for %s. Cancelling work due to transaction status %d", this, i);
                this.queueingProcessor.cancelWorks(this.queue);
            }
        }
        finally {
            Object id;
            this.consumed = true;
            if (this.queuePerTransaction != null && (id = this.transactionIdentifier.get()) != null) {
                this.queuePerTransaction.remove(id);
            }
        }
    }

    @Override
    public void flushWorks() {
        WorkQueue subQueue = this.queue.splitQueue();
        this.queueingProcessor.prepareWorks(subQueue);
        this.queueingProcessor.performWorks(subQueue);
    }
}

