/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.schemagen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.persistence.PersistenceException;
import org.hibernate.jpa.internal.HEMLogging;
import org.hibernate.jpa.internal.schemagen.ScriptTargetOutput;
import org.hibernate.jpa.internal.schemagen.ScriptTargetOutputToWriter;
import org.jboss.logging.Logger;

public class ScriptTargetOutputToFile
extends ScriptTargetOutputToWriter
implements ScriptTargetOutput {
    private static final Logger log = HEMLogging.logger(ScriptTargetOutputToFile.class);

    public ScriptTargetOutputToFile(File file) {
        super(ScriptTargetOutputToFile.toFileWriter(file));
    }

    @Override
    public void release() {
        try {
            this.writer().close();
        }
        catch (IOException e) {
            throw new PersistenceException("Unable to close file writer : " + e.toString());
        }
    }

    static Writer toFileWriter(File file) {
        try {
            file.createNewFile();
        }
        catch (Exception e) {
            log.debug((Object)("Exception calling File#createNewFile : " + e.toString()));
        }
        try {
            return new FileWriter(file);
        }
        catch (IOException e) {
            throw new PersistenceException("Unable to open specified script target file for writing : " + file, (Throwable)e);
        }
    }
}

