/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.SynchronizationType;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.hibernate.Cache;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedQueryDefinitionBuilder;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinitionBuilder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jpa.HibernateQuery;
import org.hibernate.jpa.boot.internal.SettingsImpl;
import org.hibernate.jpa.criteria.CriteriaBuilderImpl;
import org.hibernate.jpa.graph.internal.EntityGraphImpl;
import org.hibernate.jpa.internal.EntityManagerFactoryRegistry;
import org.hibernate.jpa.internal.EntityManagerImpl;
import org.hibernate.jpa.internal.metamodel.EntityTypeImpl;
import org.hibernate.jpa.internal.metamodel.MetamodelImpl;
import org.hibernate.jpa.internal.util.PersistenceUtilHelper;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.service.ServiceRegistry;
import org.jboss.logging.Logger;

public class EntityManagerFactoryImpl
implements HibernateEntityManagerFactory {
    private static final long serialVersionUID = 5423543L;
    private static final IdentifierGenerator UUID_GENERATOR = UUIDGenerator.buildSessionFactoryUniqueIdentifierGenerator();
    private static final Logger log = Logger.getLogger(EntityManagerFactoryImpl.class);
    private final transient SessionFactoryImpl sessionFactory;
    private final transient PersistenceUnitTransactionType transactionType;
    private final transient boolean discardOnClose;
    private final transient Class sessionInterceptorClass;
    private final transient CriteriaBuilderImpl criteriaBuilder;
    private final transient MetamodelImpl metamodel;
    private final transient HibernatePersistenceUnitUtil util;
    private final transient Map<String, Object> properties;
    private final String entityManagerFactoryName;
    private final transient PersistenceUtilHelper.MetadataCache cache = new PersistenceUtilHelper.MetadataCache();
    private final transient Map<String, EntityGraphImpl> entityGraphs = new ConcurrentHashMap<String, EntityGraphImpl>();

    public EntityManagerFactoryImpl(PersistenceUnitTransactionType transactionType, boolean discardOnClose, Class sessionInterceptorClass, Configuration cfg, ServiceRegistry serviceRegistry, String persistenceUnitName) {
        this(persistenceUnitName, (SessionFactoryImplementor)cfg.buildSessionFactory(serviceRegistry), new SettingsImpl().setReleaseResourcesOnCloseEnabled(discardOnClose).setSessionInterceptorClass(sessionInterceptorClass).setTransactionType(transactionType), cfg.getProperties(), cfg);
    }

    public EntityManagerFactoryImpl(String persistenceUnitName, SessionFactoryImplementor sessionFactory, SettingsImpl settings, Map<?, ?> configurationValues, Configuration cfg) {
        this.sessionFactory = (SessionFactoryImpl)sessionFactory;
        this.transactionType = settings.getTransactionType();
        this.discardOnClose = settings.isReleaseResourcesOnCloseEnabled();
        this.sessionInterceptorClass = settings.getSessionInterceptorClass();
        Iterator classes = cfg.getClassMappings();
        JpaMetaModelPopulationSetting jpaMetaModelPopulationSetting = this.determineJpaMetaModelPopulationSetting(cfg);
        this.metamodel = JpaMetaModelPopulationSetting.DISABLED == jpaMetaModelPopulationSetting ? null : MetamodelImpl.buildMetamodel(classes, sessionFactory, JpaMetaModelPopulationSetting.IGNORE_UNSUPPORTED == jpaMetaModelPopulationSetting);
        this.criteriaBuilder = new CriteriaBuilderImpl(this);
        this.util = new HibernatePersistenceUnitUtil(this);
        HashMap<String, Object> props = new HashMap<String, Object>();
        EntityManagerFactoryImpl.addAll(props, sessionFactory.getProperties());
        EntityManagerFactoryImpl.addAll(props, cfg.getProperties());
        EntityManagerFactoryImpl.addAll(props, configurationValues);
        this.maskOutSensitiveInformation(props);
        this.properties = Collections.unmodifiableMap(props);
        String entityManagerFactoryName = (String)this.properties.get("hibernate.ejb.entitymanager_factory_name");
        if (entityManagerFactoryName == null) {
            entityManagerFactoryName = persistenceUnitName;
        }
        if (entityManagerFactoryName == null) {
            entityManagerFactoryName = (String)((Object)UUID_GENERATOR.generate(null, null));
        }
        this.entityManagerFactoryName = entityManagerFactoryName;
        EntityManagerFactoryRegistry.INSTANCE.addEntityManagerFactory(entityManagerFactoryName, this);
    }

    protected JpaMetaModelPopulationSetting determineJpaMetaModelPopulationSetting(Configuration cfg) {
        String setting = ConfigurationHelper.getString((String)"hibernate.ejb.metamodel.population", (Map)cfg.getProperties(), null);
        if (setting == null && (setting = ConfigurationHelper.getString((String)"hibernate.ejb.metamodel.generation", (Map)cfg.getProperties(), null)) != null) {
            log.infof("Encountered deprecated setting [%s], use [%s] instead", (Object)"hibernate.ejb.metamodel.generation", (Object)"hibernate.ejb.metamodel.population");
        }
        return JpaMetaModelPopulationSetting.parse(setting);
    }

    private static void addAll(HashMap<String, Object> destination, Map<?, ?> source) {
        for (Map.Entry<?, ?> entry : source.entrySet()) {
            if (!String.class.isInstance(entry.getKey())) continue;
            destination.put((String)entry.getKey(), entry.getValue());
        }
    }

    private void maskOutSensitiveInformation(HashMap<String, Object> props) {
        this.maskOutIfSet(props, "javax.persistence.jdbc.password");
        this.maskOutIfSet(props, "hibernate.connection.password");
    }

    private void maskOutIfSet(HashMap<String, Object> props, String setting) {
        if (props.containsKey(setting)) {
            props.put(setting, "****");
        }
    }

    public EntityManager createEntityManager() {
        return this.createEntityManager(Collections.EMPTY_MAP);
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType) {
        return this.createEntityManager(synchronizationType, Collections.EMPTY_MAP);
    }

    public EntityManager createEntityManager(Map map) {
        return this.createEntityManager(SynchronizationType.SYNCHRONIZED, map);
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType, Map map) {
        return new EntityManagerImpl(this, PersistenceContextType.EXTENDED, synchronizationType, this.transactionType, this.discardOnClose, this.sessionInterceptorClass, map);
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.criteriaBuilder;
    }

    public Metamodel getMetamodel() {
        return this.metamodel;
    }

    public void close() {
        this.sessionFactory.close();
        EntityManagerFactoryRegistry.INSTANCE.removeEntityManagerFactory(this.entityManagerFactoryName, this);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public javax.persistence.Cache getCache() {
        if (!this.isOpen()) {
            throw new IllegalStateException("EntityManagerFactory is closed");
        }
        return new JPACache((SessionFactoryImplementor)this.sessionFactory);
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        if (!this.isOpen()) {
            throw new IllegalStateException("EntityManagerFactory is closed");
        }
        return this.util;
    }

    public void addNamedQuery(String name, javax.persistence.Query query) {
        if (!this.isOpen()) {
            throw new IllegalStateException("EntityManagerFactory is closed");
        }
        if (!HibernateQuery.class.isInstance(query)) {
            throw new PersistenceException("Cannot use query non-Hibernate EntityManager query as basis for named query");
        }
        Query hibernateQuery = ((HibernateQuery)query).getHibernateQuery();
        if (SQLQuery.class.isInstance(hibernateQuery)) {
            NamedSQLQueryDefinition namedQueryDefinition = this.extractSqlQueryDefinition((SQLQuery)hibernateQuery, name);
            this.sessionFactory.registerNamedSQLQueryDefinition(name, namedQueryDefinition);
        } else {
            NamedQueryDefinition namedQueryDefinition = this.extractHqlQueryDefinition(hibernateQuery, name);
            this.sessionFactory.registerNamedQueryDefinition(name, namedQueryDefinition);
        }
    }

    private NamedSQLQueryDefinition extractSqlQueryDefinition(SQLQuery nativeSqlQuery, String name) {
        NamedSQLQueryDefinitionBuilder builder = new NamedSQLQueryDefinitionBuilder(name);
        this.fillInNamedQueryBuilder((NamedQueryDefinitionBuilder)builder, (Query)nativeSqlQuery);
        builder.setCallable(nativeSqlQuery.isCallable()).setQuerySpaces(nativeSqlQuery.getSynchronizedQuerySpaces()).setQueryReturns(nativeSqlQuery.getQueryReturns());
        return builder.createNamedQueryDefinition();
    }

    private NamedQueryDefinition extractHqlQueryDefinition(Query hqlQuery, String name) {
        NamedQueryDefinitionBuilder builder = new NamedQueryDefinitionBuilder(name);
        this.fillInNamedQueryBuilder(builder, hqlQuery);
        builder.setLockOptions(hqlQuery.getLockOptions().makeCopy());
        return builder.createNamedQueryDefinition();
    }

    private void fillInNamedQueryBuilder(NamedQueryDefinitionBuilder builder, Query query) {
        builder.setQuery(query.getQueryString()).setComment(query.getComment()).setCacheable(query.isCacheable()).setCacheRegion(query.getCacheRegion()).setCacheMode(query.getCacheMode()).setTimeout(query.getTimeout()).setFetchSize(query.getFetchSize()).setFirstResult(query.getFirstResult()).setMaxResults(query.getMaxResults()).setReadOnly(query.isReadOnly()).setFlushMode(query.getFlushMode());
    }

    public <T> T unwrap(Class<T> cls) {
        if (SessionFactory.class.isAssignableFrom(cls)) {
            return (T)this.sessionFactory;
        }
        if (SessionFactoryImplementor.class.isAssignableFrom(cls)) {
            return (T)this.sessionFactory;
        }
        if (EntityManager.class.isAssignableFrom(cls)) {
            return (T)this;
        }
        throw new PersistenceException("Hibernate cannot unwrap EntityManagerFactory as " + cls.getName());
    }

    public <T> void addNamedEntityGraph(String graphName, EntityGraph<T> entityGraph) {
        if (!EntityGraphImpl.class.isInstance(entityGraph)) {
            throw new IllegalArgumentException("Unknown type of EntityGraph for making named : " + entityGraph.getClass().getName());
        }
        EntityGraphImpl copy = ((EntityGraphImpl)entityGraph).makeImmutableCopy(graphName);
        EntityGraphImpl old = this.entityGraphs.put(graphName, copy);
        if (old != null) {
            log.debugf("EntityGraph being replaced on EntityManagerFactory for name %s", (Object)graphName);
        }
    }

    public EntityGraphImpl findEntityGraphByName(String name) {
        return this.entityGraphs.get(name);
    }

    public <T> List<EntityGraph<? super T>> findEntityGraphsByType(Class<T> entityClass) {
        EntityType entityType = this.getMetamodel().entity(entityClass);
        if (entityType == null) {
            throw new IllegalArgumentException("Given class is not an entity : " + entityClass.getName());
        }
        ArrayList<EntityGraph<T>> results = new ArrayList<EntityGraph<T>>();
        for (EntityGraphImpl entityGraph : this.entityGraphs.values()) {
            if (!entityGraph.appliesTo(entityType)) continue;
            results.add(entityGraph);
        }
        return results;
    }

    public boolean isOpen() {
        return !this.sessionFactory.isClosed();
    }

    public SessionFactoryImpl getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public EntityTypeImpl getEntityTypeByName(String entityName) {
        EntityTypeImpl entityType = this.metamodel.getEntityTypeByName(entityName);
        if (entityType == null) {
            throw new IllegalArgumentException("[" + entityName + "] did not refer to EntityType");
        }
        return entityType;
    }

    public String getEntityManagerFactoryName() {
        return this.entityManagerFactoryName;
    }

    private static EntityManagerFactory getNamedEntityManagerFactory(String entityManagerFactoryName) throws InvalidObjectException {
        EntityManagerFactory result = EntityManagerFactoryRegistry.INSTANCE.getNamedEntityManagerFactory(entityManagerFactoryName);
        if (result == null) {
            throw new InvalidObjectException("could not resolve entity manager factory during entity manager deserialization [name=" + entityManagerFactoryName + "]");
        }
        return result;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.entityManagerFactoryName == null) {
            throw new InvalidObjectException("could not serialize entity manager factory with null entityManagerFactoryName");
        }
        oos.defaultWriteObject();
    }

    private Object readResolve() throws InvalidObjectException {
        return EntityManagerFactoryImpl.getNamedEntityManagerFactory(this.entityManagerFactoryName);
    }

    private static class HibernatePersistenceUnitUtil
    implements PersistenceUnitUtil,
    Serializable {
        private final HibernateEntityManagerFactory emf;
        private transient PersistenceUtilHelper.MetadataCache cache;

        private HibernatePersistenceUnitUtil(EntityManagerFactoryImpl emf) {
            this.emf = emf;
            this.cache = emf.cache;
        }

        public boolean isLoaded(Object entity, String attributeName) {
            log.debug((Object)"PersistenceUnitUtil#isLoaded is not always accurate; consider using EntityManager#contains instead");
            LoadState state = PersistenceUtilHelper.isLoadedWithoutReference(entity, attributeName, this.cache);
            if (state == LoadState.LOADED) {
                return true;
            }
            if (state == LoadState.NOT_LOADED) {
                return false;
            }
            return PersistenceUtilHelper.isLoadedWithReference(entity, attributeName, this.cache) != LoadState.NOT_LOADED;
        }

        public boolean isLoaded(Object entity) {
            log.debug((Object)"PersistenceUnitUtil#isLoaded is not always accurate; consider using EntityManager#contains instead");
            return PersistenceUtilHelper.isLoaded(entity) != LoadState.NOT_LOADED;
        }

        public Object getIdentifier(Object entity) {
            Class entityClass = Hibernate.getClass((Object)entity);
            ClassMetadata classMetadata = this.emf.getSessionFactory().getClassMetadata(entityClass);
            if (classMetadata == null) {
                throw new IllegalArgumentException(entityClass + " is not an entity");
            }
            return classMetadata.getIdentifier(entity);
        }
    }

    private static class JPACache
    implements javax.persistence.Cache {
        private SessionFactoryImplementor sessionFactory;

        private JPACache(SessionFactoryImplementor sessionFactory) {
            this.sessionFactory = sessionFactory;
        }

        public boolean contains(Class entityClass, Object identifier) {
            return this.sessionFactory.getCache().containsEntity(entityClass, (Serializable)identifier);
        }

        public void evict(Class entityClass, Object identifier) {
            this.sessionFactory.getCache().evictEntity(entityClass, (Serializable)identifier);
        }

        public void evict(Class entityClass) {
            this.sessionFactory.getCache().evictEntityRegion(entityClass);
        }

        public void evictAll() {
            this.sessionFactory.getCache().evictEntityRegions();
        }

        public <T> T unwrap(Class<T> cls) {
            if (RegionFactory.class.isAssignableFrom(cls)) {
                return (T)this.sessionFactory.getSettings().getRegionFactory();
            }
            if (Cache.class.isAssignableFrom(cls)) {
                return (T)this.sessionFactory.getCache();
            }
            throw new PersistenceException("Hibernate cannot unwrap Cache as " + cls.getName());
        }
    }

    private static enum JpaMetaModelPopulationSetting {
        ENABLED,
        DISABLED,
        IGNORE_UNSUPPORTED;


        private static JpaMetaModelPopulationSetting parse(String setting) {
            if ("enabled".equalsIgnoreCase(setting)) {
                return ENABLED;
            }
            if ("disabled".equalsIgnoreCase(setting)) {
                return DISABLED;
            }
            return IGNORE_UNSUPPORTED;
        }
    }
}

