/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.criteria.compile;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.ParameterExpression;
import org.hibernate.Query;
import org.hibernate.ejb.HibernateQuery;
import org.hibernate.jpa.internal.QueryImpl;
import org.hibernate.jpa.spi.HibernateEntityManagerImplementor;

public class CriteriaQueryTypeQueryAdapter<X>
implements TypedQuery<X>,
HibernateQuery {
    private final HibernateEntityManagerImplementor entityManager;
    private final QueryImpl<X> jpaqlQuery;
    private final Map<ParameterExpression<?>, String> explicitParameterMapping;
    private final Map<String, ParameterExpression<?>> explicitParameterNameMapping;

    public CriteriaQueryTypeQueryAdapter(HibernateEntityManagerImplementor entityManager, QueryImpl<X> jpaqlQuery, Map<ParameterExpression<?>, String> explicitParameterMapping, Map<String, ParameterExpression<?>> explicitParameterNameMapping) {
        this.entityManager = entityManager;
        this.jpaqlQuery = jpaqlQuery;
        this.explicitParameterMapping = explicitParameterMapping;
        this.explicitParameterNameMapping = explicitParameterNameMapping;
    }

    @Override
    public Query getHibernateQuery() {
        return this.jpaqlQuery.getHibernateQuery();
    }

    public List<X> getResultList() {
        return this.jpaqlQuery.getResultList();
    }

    public X getSingleResult() {
        return this.jpaqlQuery.getSingleResult();
    }

    public int getMaxResults() {
        return this.jpaqlQuery.getMaxResults();
    }

    public TypedQuery<X> setMaxResults(int i) {
        this.jpaqlQuery.setMaxResults(i);
        return this;
    }

    public int getFirstResult() {
        return this.jpaqlQuery.getFirstResult();
    }

    public TypedQuery<X> setFirstResult(int i) {
        this.jpaqlQuery.setFirstResult(i);
        return this;
    }

    public Map<String, Object> getHints() {
        return this.jpaqlQuery.getHints();
    }

    public TypedQuery<X> setHint(String name, Object value) {
        this.jpaqlQuery.setHint(name, value);
        return this;
    }

    public FlushModeType getFlushMode() {
        return this.jpaqlQuery.getFlushMode();
    }

    public TypedQuery<X> setFlushMode(FlushModeType flushModeType) {
        this.jpaqlQuery.setFlushMode(flushModeType);
        return this;
    }

    public LockModeType getLockMode() {
        return this.jpaqlQuery.getLockMode();
    }

    public TypedQuery<X> setLockMode(LockModeType lockModeType) {
        this.jpaqlQuery.setLockMode(lockModeType);
        return this;
    }

    public Set getParameters() {
        this.entityManager.checkOpen(false);
        return this.explicitParameterMapping.keySet();
    }

    public boolean isBound(Parameter<?> param) {
        this.entityManager.checkOpen(false);
        return this.jpaqlQuery.isBound(param);
    }

    public <T> T getParameterValue(Parameter<T> param) {
        this.entityManager.checkOpen(false);
        return this.jpaqlQuery.getParameterValue(this.mapToNamedParameter(param));
    }

    public <T> TypedQuery<X> setParameter(Parameter<T> param, T t) {
        this.entityManager.checkOpen(false);
        this.jpaqlQuery.setParameter(this.mapToNamedParameter(param), (Object)t);
        return this;
    }

    private Parameter mapToNamedParameter(Parameter criteriaParameter) {
        return this.jpaqlQuery.getParameter(this.explicitParameterMapping.get(criteriaParameter));
    }

    public TypedQuery<X> setParameter(Parameter<Calendar> param, Calendar calendar, TemporalType temporalType) {
        this.entityManager.checkOpen(false);
        this.jpaqlQuery.setParameter(this.mapToNamedParameter(param), calendar, temporalType);
        return this;
    }

    public TypedQuery<X> setParameter(Parameter<Date> param, Date date, TemporalType temporalType) {
        this.entityManager.checkOpen(false);
        this.jpaqlQuery.setParameter(this.mapToNamedParameter(param), date, temporalType);
        return this;
    }

    public <T> T unwrap(Class<T> cls) {
        return this.jpaqlQuery.unwrap(cls);
    }

    public Object getParameterValue(String name) {
        this.entityManager.checkOpen(false);
        return this.getParameterValue(this.resolveExplicitCriteriaParameterName(name));
    }

    private Parameter resolveExplicitCriteriaParameterName(String name) {
        Parameter parameter = (Parameter)this.explicitParameterNameMapping.get(name);
        if (parameter == null) {
            throw new IllegalArgumentException("Named parameter [" + name + "] not encountered");
        }
        return parameter;
    }

    public Parameter<?> getParameter(String name) {
        this.entityManager.checkOpen(false);
        return this.mapToNamedParameter(this.resolveExplicitCriteriaParameterName(name));
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        this.entityManager.checkOpen(false);
        Parameter parameter = this.resolveExplicitCriteriaParameterName(name);
        if (type.isAssignableFrom(parameter.getParameterType())) {
            return parameter;
        }
        throw new IllegalArgumentException("Named parameter [" + name + "] type is not assignanle to request type [" + type.getName() + "]");
    }

    public TypedQuery<X> setParameter(String name, Object value) {
        this.entityManager.checkOpen(true);
        this.setParameter((Parameter<T>)this.resolveExplicitCriteriaParameterName(name, value), (T)value);
        return this;
    }

    private Parameter resolveExplicitCriteriaParameterName(String name, Object value) {
        Parameter parameter = this.resolveExplicitCriteriaParameterName(name);
        if (value != null && !parameter.getParameterType().isInstance(value)) {
            throw new IllegalArgumentException("Named parameter [" + name + "] type mismatch; expecting [" + parameter.getParameterType().getName() + "], found [" + value.getClass().getName() + "]");
        }
        return parameter;
    }

    public TypedQuery<X> setParameter(String name, Calendar calendar, TemporalType temporalType) {
        this.entityManager.checkOpen(true);
        Parameter parameter = this.resolveExplicitCriteriaParameterName(name);
        if (!Calendar.class.isAssignableFrom(parameter.getParameterType())) {
            throw new IllegalArgumentException("Named parameter [" + name + "] type mismatch; expecting [" + Calendar.class.getName() + "], found [" + parameter.getParameterType().getName() + "]");
        }
        this.setParameter((Parameter<Calendar>)parameter, calendar, temporalType);
        return this;
    }

    public TypedQuery<X> setParameter(String name, Date date, TemporalType temporalType) {
        this.entityManager.checkOpen(true);
        Parameter parameter = this.resolveExplicitCriteriaParameterName(name);
        if (!Date.class.isAssignableFrom(parameter.getParameterType())) {
            throw new IllegalArgumentException("Named parameter [" + name + "] type mismatch; expecting [" + Date.class.getName() + "], found [" + parameter.getParameterType().getName() + "]");
        }
        this.setParameter((Parameter<Date>)parameter, date, temporalType);
        return this;
    }

    public int executeUpdate() {
        throw new IllegalArgumentException("Criteria queries do not support update queries");
    }

    public TypedQuery<X> setParameter(int i, Object o) {
        throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
    }

    public TypedQuery<X> setParameter(int i, Calendar calendar, TemporalType temporalType) {
        throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
    }

    public TypedQuery<X> setParameter(int i, Date date, TemporalType temporalType) {
        throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
    }

    public Object getParameterValue(int position) {
        throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
    }

    public Parameter<?> getParameter(int position) {
        throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
    }
}

