/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache.internal.regions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.constructs.nonstop.NonStopCacheException;
import net.sf.ehcache.util.Timestamper;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.ehcache.EhCacheMessageLogger;
import org.hibernate.cache.ehcache.internal.nonstop.HibernateNonstopCacheExceptionHandler;
import org.hibernate.cache.ehcache.internal.strategy.EhcacheAccessStrategyFactory;
import org.hibernate.cache.spi.Region;
import org.jboss.logging.Logger;

public abstract class EhcacheDataRegion
implements Region {
    private static final EhCacheMessageLogger LOG = (EhCacheMessageLogger)Logger.getMessageLogger(EhCacheMessageLogger.class, (String)EhcacheDataRegion.class.getName());
    private static final String CACHE_LOCK_TIMEOUT_PROPERTY = "net.sf.ehcache.hibernate.cache_lock_timeout";
    private static final int DEFAULT_CACHE_LOCK_TIMEOUT = 60000;
    protected final Ehcache cache;
    protected final EhcacheAccessStrategyFactory accessStrategyFactory;
    private final int cacheLockTimeout;

    EhcacheDataRegion(EhcacheAccessStrategyFactory accessStrategyFactory, Ehcache cache, Properties properties) {
        this.accessStrategyFactory = accessStrategyFactory;
        this.cache = cache;
        String timeout = properties.getProperty(CACHE_LOCK_TIMEOUT_PROPERTY, Integer.toString(60000));
        this.cacheLockTimeout = Timestamper.ONE_MS * Integer.decode(timeout);
    }

    public String getName() {
        return this.cache.getName();
    }

    public void destroy() throws CacheException {
        try {
            this.cache.getCacheManager().removeCache(this.cache.getName());
        }
        catch (IllegalStateException e) {
            LOG.debug("This can happen if multiple frameworks both try to shutdown ehcache", e);
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)((Object)e));
            }
            throw new CacheException((Throwable)e);
        }
    }

    public long getSizeInMemory() {
        try {
            return this.cache.calculateInMemorySize();
        }
        catch (Throwable t) {
            if (t instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)t);
            }
            return -1L;
        }
    }

    public long getElementCountInMemory() {
        try {
            return this.cache.getMemoryStoreSize();
        }
        catch (net.sf.ehcache.CacheException ce) {
            if (ce instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)((Object)ce));
                return -1L;
            }
            throw new CacheException((Throwable)ce);
        }
    }

    public long getElementCountOnDisk() {
        try {
            return this.cache.getDiskStoreSize();
        }
        catch (net.sf.ehcache.CacheException ce) {
            if (ce instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)((Object)ce));
                return -1L;
            }
            throw new CacheException((Throwable)ce);
        }
    }

    public Map toMap() {
        try {
            HashMap result = new HashMap();
            for (Object key : this.cache.getKeys()) {
                result.put(key, this.cache.get(key).getObjectValue());
            }
            return result;
        }
        catch (Exception e) {
            if (e instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)((Object)e));
                return Collections.emptyMap();
            }
            throw new CacheException((Throwable)e);
        }
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public int getTimeout() {
        return this.cacheLockTimeout;
    }

    public Ehcache getEhcache() {
        return this.cache;
    }

    public boolean contains(Object key) {
        return this.cache.isKeyInCache(key);
    }
}

