/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.service.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.hibernate.event.service.internal.EventListenerRegistryImpl;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventActionWithParameter;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistrationException;
import org.hibernate.event.service.spi.JpaBootstrapSensitive;
import org.hibernate.event.spi.EventType;
import org.hibernate.jpa.event.spi.CallbackRegistryConsumer;

class EventListenerGroupImpl<T>
implements EventListenerGroup<T> {
    private EventType<T> eventType;
    private final EventListenerRegistryImpl listenerRegistry;
    private final Set<DuplicationStrategy> duplicationStrategies = new LinkedHashSet<DuplicationStrategy>();
    private T[] listeners = null;
    private List<T> listenersAsList;

    public EventListenerGroupImpl(EventType<T> eventType, EventListenerRegistryImpl listenerRegistry) {
        this.eventType = eventType;
        this.listenerRegistry = listenerRegistry;
        this.duplicationStrategies.add(new DuplicationStrategy(){

            @Override
            public boolean areMatch(Object listener, Object original) {
                return listener.getClass().equals(original.getClass());
            }

            @Override
            public DuplicationStrategy.Action getAction() {
                return DuplicationStrategy.Action.ERROR;
            }
        });
    }

    @Override
    public EventType<T> getEventType() {
        return this.eventType;
    }

    @Override
    public boolean isEmpty() {
        return this.count() <= 0;
    }

    @Override
    public int count() {
        T[] ls = this.listeners;
        return ls == null ? 0 : ls.length;
    }

    @Override
    public void clear() {
        if (this.duplicationStrategies != null) {
            this.duplicationStrategies.clear();
        }
        this.listeners = null;
        this.listenersAsList = null;
    }

    @Override
    public final <U> void fireLazyEventOnEachListener(Supplier<U> eventSupplier, BiConsumer<T, U> actionOnEvent) {
        T[] ls = this.listeners;
        if (ls != null && ls.length != 0) {
            U event = eventSupplier.get();
            for (T listener : ls) {
                actionOnEvent.accept(listener, event);
            }
        }
    }

    @Override
    public final <U> void fireEventOnEachListener(U event, BiConsumer<T, U> actionOnEvent) {
        T[] ls = this.listeners;
        if (ls != null) {
            for (T listener : ls) {
                actionOnEvent.accept(listener, event);
            }
        }
    }

    @Override
    public <U, X> void fireEventOnEachListener(U event, X parameter, EventActionWithParameter<T, U, X> actionOnEvent) {
        T[] ls = this.listeners;
        if (ls != null) {
            for (T listener : ls) {
                actionOnEvent.applyEventToListener(listener, event, parameter);
            }
        }
    }

    @Override
    public void addDuplicationStrategy(DuplicationStrategy strategy) {
        this.duplicationStrategies.add(strategy);
    }

    @Override
    @Deprecated
    public final Iterable<T> listeners() {
        List<T> ls = this.listenersAsList;
        return ls == null ? Collections.EMPTY_LIST : ls;
    }

    @Override
    @SafeVarargs
    public final void appendListeners(T ... listeners) {
        this.internalAppendListeners(listeners);
        this.checkForArrayRefresh();
    }

    private void checkForArrayRefresh() {
        List<Object> list = this.listenersAsList;
        if (this.listeners == null) {
            Object[] a = (Object[])Array.newInstance(this.eventType.baseListenerInterface(), list.size());
            this.listeners = list.toArray(a);
        }
    }

    private void internalAppendListeners(T[] listeners) {
        for (T listener : listeners) {
            this.internalAppendListener(listener);
        }
    }

    @Override
    public void appendListener(T listener) {
        this.internalAppendListener(listener);
        this.checkForArrayRefresh();
    }

    private void internalAppendListener(T listener) {
        if (this.listenerShouldGetAdded(listener)) {
            this.internalAppend(listener);
        }
    }

    @Override
    @SafeVarargs
    public final void prependListeners(T ... listeners) {
        this.internalPrependListeners(listeners);
        this.checkForArrayRefresh();
    }

    private void internalPrependListeners(T[] listeners) {
        for (T listener : listeners) {
            this.internalPreprendListener(listener);
        }
    }

    @Override
    public void prependListener(T listener) {
        this.internalPreprendListener(listener);
        this.checkForArrayRefresh();
    }

    private void internalPreprendListener(T listener) {
        if (this.listenerShouldGetAdded(listener)) {
            this.internalPrepend(listener);
        }
    }

    private boolean listenerShouldGetAdded(T listener) {
        List<T> ts = this.listenersAsList;
        if (ts == null) {
            this.listenersAsList = new ArrayList<T>();
            return true;
        }
        boolean doAdd = true;
        block5: for (DuplicationStrategy strategy : this.duplicationStrategies) {
            ListIterator<T> itr = ts.listIterator();
            while (itr.hasNext()) {
                T existingListener = itr.next();
                if (!strategy.areMatch(listener, existingListener)) continue;
                switch (strategy.getAction()) {
                    case ERROR: {
                        throw new EventListenerRegistrationException("Duplicate event listener found");
                    }
                    case KEEP_ORIGINAL: {
                        doAdd = false;
                        break block5;
                    }
                    case REPLACE_ORIGINAL: {
                        this.checkAgainstBaseInterface(listener);
                        this.performInjections(listener);
                        itr.set(listener);
                        doAdd = false;
                        break block5;
                    }
                }
            }
        }
        return doAdd;
    }

    private void internalPrepend(T listener) {
        this.checkAgainstBaseInterface(listener);
        this.performInjections(listener);
        this.listenersAsList.add(0, listener);
        this.listeners = null;
    }

    private void performInjections(T listener) {
        if (CallbackRegistryConsumer.class.isInstance(listener)) {
            ((CallbackRegistryConsumer)listener).injectCallbackRegistry(this.listenerRegistry.getCallbackRegistry());
        }
        if (JpaBootstrapSensitive.class.isInstance(listener)) {
            ((JpaBootstrapSensitive)listener).wasJpaBootstrap(this.listenerRegistry.getSessionFactory().getSessionFactoryOptions().isJpaBootstrap());
        }
    }

    private void checkAgainstBaseInterface(T listener) {
        if (!this.eventType.baseListenerInterface().isInstance(listener)) {
            throw new EventListenerRegistrationException("Listener did not implement expected interface [" + this.eventType.baseListenerInterface().getName() + "]");
        }
    }

    private void internalAppend(T listener) {
        this.checkAgainstBaseInterface(listener);
        this.performInjections(listener);
        this.listenersAsList.add(listener);
        this.listeners = null;
    }
}

