/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.MappingException;
import org.hibernate.engine.internal.JoinHelper;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.JoinType;
import org.hibernate.sql.QueryJoinFragment;
import org.hibernate.type.AssociationType;

public class JoinSequence {
    private final SessionFactoryImplementor factory;
    private final boolean collectionJoinSubquery;
    private final StringBuilder conditions = new StringBuilder();
    private final List<Join> joins = new ArrayList<Join>();
    private boolean useThetaStyle;
    private String rootAlias;
    private Joinable rootJoinable;
    private Selector selector;
    private JoinSequence next;
    private boolean isFromPart;
    private Set<String> treatAsDeclarations;

    public JoinSequence(SessionFactoryImplementor factory) {
        this.factory = factory;
        this.collectionJoinSubquery = factory.getSessionFactoryOptions().isCollectionJoinSubqueryRewriteEnabled();
    }

    public JoinSequence getFromPart() {
        JoinSequence fromPart = new JoinSequence(this.factory);
        fromPart.joins.addAll(this.joins);
        fromPart.useThetaStyle = this.useThetaStyle;
        fromPart.rootAlias = this.rootAlias;
        fromPart.rootJoinable = this.rootJoinable;
        fromPart.selector = this.selector;
        fromPart.next = this.next == null ? null : this.next.getFromPart();
        fromPart.isFromPart = true;
        return fromPart;
    }

    public void applyTreatAsDeclarations(Set<String> treatAsDeclarations) {
        if (treatAsDeclarations == null || treatAsDeclarations.isEmpty()) {
            return;
        }
        if (this.treatAsDeclarations == null) {
            this.treatAsDeclarations = new HashSet<String>();
        }
        this.treatAsDeclarations.addAll(treatAsDeclarations);
    }

    public JoinSequence copy() {
        JoinSequence copy = new JoinSequence(this.factory);
        copy.joins.addAll(this.joins);
        copy.useThetaStyle = this.useThetaStyle;
        copy.rootAlias = this.rootAlias;
        copy.rootJoinable = this.rootJoinable;
        copy.selector = this.selector;
        copy.next = this.next == null ? null : this.next.copy();
        copy.isFromPart = this.isFromPart;
        copy.conditions.append(this.conditions.toString());
        return copy;
    }

    public JoinSequence addJoin(AssociationType associationType, String alias, JoinType joinType, String[] referencingKey) throws MappingException {
        this.joins.add(new Join(this.factory, associationType, alias, joinType, referencingKey));
        return this;
    }

    public JoinFragment toJoinFragment() throws MappingException {
        return this.toJoinFragment(Collections.EMPTY_MAP, true);
    }

    public JoinFragment toJoinFragment(Map enabledFilters, boolean includeAllSubclassJoins) throws MappingException {
        return this.toJoinFragment(enabledFilters, includeAllSubclassJoins, null, null);
    }

    public JoinFragment toJoinFragment(Map enabledFilters, boolean includeAllSubclassJoins, String withClauseFragment, String withClauseJoinAlias) throws MappingException {
        return this.toJoinFragment(enabledFilters, includeAllSubclassJoins, true, withClauseFragment, withClauseJoinAlias);
    }

    public JoinFragment toJoinFragment(Map enabledFilters, boolean includeAllSubclassJoins, boolean renderSubclassJoins, String withClauseFragment, String withClauseJoinAlias) throws MappingException {
        Joinable last;
        QueryJoinFragment joinFragment = new QueryJoinFragment(this.factory.getDialect(), this.useThetaStyle);
        if (this.rootJoinable != null) {
            joinFragment.addCrossJoin(this.rootJoinable.getTableName(), this.rootAlias);
            String filterCondition = this.rootJoinable.filterFragment(this.rootAlias, enabledFilters, this.treatAsDeclarations);
            joinFragment.setHasFilterCondition(joinFragment.addCondition(filterCondition));
            this.addSubclassJoins(joinFragment, this.rootAlias, this.rootJoinable, true, includeAllSubclassJoins, this.treatAsDeclarations);
            last = this.rootJoinable;
        } else {
            Iterator<Join> iter;
            Join first;
            if (this.collectionJoinSubquery && withClauseFragment != null && this.joins.size() > 1 && withClauseFragment.contains(withClauseJoinAlias) && (first = (iter = this.joins.iterator()).next()).joinType == JoinType.LEFT_OUTER_JOIN) {
                QueryJoinFragment subqueryJoinFragment = new QueryJoinFragment(this.factory.getDialect(), this.useThetaStyle);
                subqueryJoinFragment.addFromFragmentString("(select ");
                subqueryJoinFragment.addFromFragmentString(first.getAlias());
                subqueryJoinFragment.addFromFragmentString(".*");
                Pattern p = Pattern.compile(Pattern.quote(withClauseJoinAlias + ".") + "(([a-zA-Z0-9_]+)|(\"[a-zA-Z0-9_]+\"((\"\"[a-zA-Z0-9_]+)+\")?)|(`[a-zA-Z0-9_]+`((``[a-zA-Z0-9_]+)+`)?)|(\\[[a-zA-Z0-9_\\s]+\\]))");
                Matcher matcher = p.matcher(withClauseFragment);
                StringBuilder withClauseSb = new StringBuilder(withClauseFragment.length());
                withClauseSb.append(" and ");
                int start = 0;
                int aliasNumber = 0;
                while (matcher.find()) {
                    String column = matcher.group(1);
                    String alias = "c_" + aliasNumber + "_" + column.replaceAll("[\\[\\]\\s\"']+", "");
                    withClauseSb.append(withClauseFragment, start, matcher.start());
                    withClauseSb.append(first.getAlias());
                    withClauseSb.append('.');
                    withClauseSb.append(alias);
                    withClauseSb.append(' ');
                    subqueryJoinFragment.addFromFragmentString(", ");
                    subqueryJoinFragment.addFromFragmentString(withClauseJoinAlias);
                    subqueryJoinFragment.addFromFragmentString(".");
                    subqueryJoinFragment.addFromFragmentString(column);
                    subqueryJoinFragment.addFromFragmentString(" as ");
                    subqueryJoinFragment.addFromFragmentString(alias);
                    start = matcher.end();
                    ++aliasNumber;
                }
                withClauseSb.append(withClauseFragment, start, withClauseFragment.length());
                subqueryJoinFragment.addFromFragmentString(" from ");
                subqueryJoinFragment.addFromFragmentString(first.joinable.getTableName());
                subqueryJoinFragment.addFromFragmentString(" ");
                subqueryJoinFragment.addFromFragmentString(first.getAlias());
                JoinSequence subSequence = new JoinSequence(this.factory);
                while (iter.hasNext()) {
                    Join join = iter.next();
                    subSequence.joins.add(join);
                }
                JoinFragment subFragment = subSequence.toJoinFragment(enabledFilters, false, true, null, null);
                subqueryJoinFragment.addFragment(subFragment);
                subqueryJoinFragment.addFromFragmentString(")");
                joinFragment.addJoin(subqueryJoinFragment.toFromFragmentString(), first.getAlias(), first.getLHSColumns(), JoinHelper.getRHSColumnNames(first.getAssociationType(), this.factory), first.joinType, withClauseSb.toString());
                for (Join join : this.joins) {
                    if (join != first) {
                        joinFragment.addJoin(join.getJoinable().getTableName(), join.getAlias(), join.getLHSColumns(), JoinHelper.getRHSColumnNames(join.getAssociationType(), this.factory), join.joinType, "");
                    }
                    this.addSubclassJoins(joinFragment, join.getAlias(), join.getJoinable(), join.joinType == JoinType.INNER_JOIN, includeAllSubclassJoins, this.treatAsDeclarations);
                }
                return joinFragment;
            }
            last = null;
        }
        for (Join join : this.joins) {
            String manyToManyFilter;
            String on = join.getAssociationType().getOnCondition(join.getAlias(), this.factory, enabledFilters, this.treatAsDeclarations);
            String condition = last != null && this.isManyToManyRoot(last) && ((QueryableCollection)last).getElementType() == join.getAssociationType() ? ("".equals(manyToManyFilter = ((QueryableCollection)last).getManyToManyFilterFragment(join.getAlias(), enabledFilters)) ? on : ("".equals(on) ? manyToManyFilter : on + " and " + manyToManyFilter)) : on;
            if (withClauseFragment != null && !this.isManyToManyRoot(join.joinable)) {
                condition = condition + " and " + withClauseFragment;
            }
            joinFragment.addJoin(join.getJoinable().getTableName(), join.getAlias(), join.getLHSColumns(), JoinHelper.getRHSColumnNames(join.getAssociationType(), this.factory), join.joinType, condition);
            if (renderSubclassJoins) {
                this.addSubclassJoins(joinFragment, join.getAlias(), join.getJoinable(), join.joinType == JoinType.INNER_JOIN, includeAllSubclassJoins, this.treatAsDeclarations);
            }
            last = join.getJoinable();
        }
        if (this.next != null) {
            joinFragment.addFragment(this.next.toJoinFragment(enabledFilters, includeAllSubclassJoins));
        }
        joinFragment.addCondition(this.conditions.toString());
        if (this.isFromPart) {
            joinFragment.clearWherePart();
        }
        return joinFragment;
    }

    private boolean isManyToManyRoot(Joinable joinable) {
        if (joinable != null && joinable.isCollection()) {
            return ((QueryableCollection)joinable).isManyToMany();
        }
        return false;
    }

    private void addSubclassJoins(JoinFragment joinFragment, String alias, Joinable joinable, boolean innerJoin, boolean includeSubclassJoins, Set<String> treatAsDeclarations) {
        boolean include = includeSubclassJoins && this.isIncluded(alias);
        joinFragment.addJoins(joinable.fromJoinFragment(alias, innerJoin, include, treatAsDeclarations), joinable.whereJoinFragment(alias, innerJoin, include, treatAsDeclarations));
    }

    private boolean isIncluded(String alias) {
        return this.selector != null && this.selector.includeSubclasses(alias);
    }

    public JoinSequence addCondition(String condition) {
        if (condition.trim().length() != 0) {
            if (!condition.startsWith(" and ")) {
                this.conditions.append(" and ");
            }
            this.conditions.append(condition);
        }
        return this;
    }

    public JoinSequence addCondition(String alias, String[] columns, String condition) {
        for (String column : columns) {
            this.conditions.append(" and ").append(alias).append('.').append(column).append(condition);
        }
        return this;
    }

    public JoinSequence setRoot(Joinable joinable, String alias) {
        this.rootAlias = alias;
        this.rootJoinable = joinable;
        return this;
    }

    public JoinSequence setNext(JoinSequence next) {
        this.next = next;
        return this;
    }

    public JoinSequence setSelector(Selector selector) {
        this.selector = selector;
        return this;
    }

    public JoinSequence setUseThetaStyle(boolean useThetaStyle) {
        this.useThetaStyle = useThetaStyle;
        return this;
    }

    public boolean isThetaStyle() {
        return this.useThetaStyle;
    }

    public Join getFirstJoin() {
        return this.joins.get(0);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("JoinSequence{");
        if (this.rootJoinable != null) {
            buf.append(this.rootJoinable).append('[').append(this.rootAlias).append(']');
        }
        for (Join join : this.joins) {
            buf.append("->").append(join);
        }
        return buf.append('}').toString();
    }

    public static final class Join {
        private final AssociationType associationType;
        private final Joinable joinable;
        private final JoinType joinType;
        private final String alias;
        private final String[] lhsColumns;

        Join(SessionFactoryImplementor factory, AssociationType associationType, String alias, JoinType joinType, String[] lhsColumns) throws MappingException {
            this.associationType = associationType;
            this.joinable = associationType.getAssociatedJoinable(factory);
            this.alias = alias;
            this.joinType = joinType;
            this.lhsColumns = lhsColumns;
        }

        public String getAlias() {
            return this.alias;
        }

        public AssociationType getAssociationType() {
            return this.associationType;
        }

        public Joinable getJoinable() {
            return this.joinable;
        }

        public JoinType getJoinType() {
            return this.joinType;
        }

        public String[] getLHSColumns() {
            return this.lhsColumns;
        }

        public String toString() {
            return this.joinable.toString() + '[' + this.alias + ']';
        }
    }

    public static interface Selector {
        public boolean includeSubclasses(String var1);
    }
}

