/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.internal.core;

import org.hibernate.SessionFactory;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.DefaultFlushEntityEventListener;
import org.hibernate.jpa.event.spi.jpa.CallbackRegistry;
import org.hibernate.jpa.event.spi.jpa.CallbackRegistryConsumer;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.Type;

public class JpaFlushEntityEventListener
extends DefaultFlushEntityEventListener
implements CallbackRegistryConsumer {
    private CallbackRegistry callbackRegistry;

    @Override
    public void injectCallbackRegistry(CallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    public JpaFlushEntityEventListener() {
    }

    public JpaFlushEntityEventListener(CallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    @Override
    protected boolean invokeInterceptor(SessionImplementor session, Object entity, EntityEntry entry, Object[] values, EntityPersister persister) {
        boolean isDirty = false;
        if (entry.getStatus() != Status.DELETED && this.callbackRegistry.preUpdate(entity)) {
            isDirty = this.copyState(entity, persister.getPropertyTypes(), values, session.getFactory());
        }
        return super.invokeInterceptor(session, entity, entry, values, persister) || isDirty;
    }

    private boolean copyState(Object entity, Type[] types, Object[] state, SessionFactory sf) {
        ClassMetadata metadata = sf.getClassMetadata(entity.getClass());
        Object[] newState = metadata.getPropertyValues(entity);
        int size = newState.length;
        boolean isDirty = false;
        for (int index = 0; index < size; ++index) {
            if ((state[index] != LazyPropertyInitializer.UNFETCHED_PROPERTY || newState[index] == LazyPropertyInitializer.UNFETCHED_PROPERTY) && (state[index] == newState[index] || types[index].isEqual(state[index], newState[index]))) continue;
            isDirty = true;
            state[index] = newState[index];
        }
        return isDirty;
    }
}

