/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.connections.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.connections.internal.ConnectionCreator;
import org.hibernate.engine.jdbc.connections.internal.DriverManagerConnectionProviderImpl;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;

public class PooledConnections {
    private final ConcurrentLinkedQueue<Connection> allConnections = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Connection> availableConnections = new ConcurrentLinkedQueue();
    private static final CoreMessageLogger log = CoreLogging.messageLogger(DriverManagerConnectionProviderImpl.class);
    private final ConnectionCreator connectionCreator;
    private final boolean autoCommit;
    private final int minSize;
    private final int maxSize;
    private boolean primed;

    private PooledConnections(Builder builder) {
        log.debugf("Initializing Connection pool with %s Connections", builder.initialSize);
        this.connectionCreator = builder.connectionCreator;
        this.autoCommit = builder.autoCommit;
        this.maxSize = builder.maxSize;
        this.minSize = builder.minSize;
        log.hibernateConnectionPoolSize(this.maxSize, this.minSize);
        this.addConnections(builder.initialSize);
    }

    public void validate() {
        int size = this.size();
        if (!this.primed && size >= this.minSize) {
            log.debug("Connection pool now considered primed; min-size will be maintained");
            this.primed = true;
        }
        if (size < this.minSize && this.primed) {
            int numberToBeAdded = this.minSize - size;
            log.debugf("Adding %s Connections to the pool", numberToBeAdded);
            this.addConnections(numberToBeAdded);
        } else if (size > this.maxSize) {
            int numberToBeRemoved = size - this.maxSize;
            log.debugf("Removing %s Connections from the pool", numberToBeRemoved);
            this.removeConnections(numberToBeRemoved);
        }
    }

    public void add(Connection conn) throws SQLException {
        conn.setAutoCommit(true);
        conn.clearWarnings();
        this.availableConnections.offer(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection poll() throws SQLException {
        Connection conn = this.availableConnections.poll();
        if (conn == null) {
            ConcurrentLinkedQueue<Connection> concurrentLinkedQueue = this.allConnections;
            synchronized (concurrentLinkedQueue) {
                if (this.allConnections.size() < this.maxSize) {
                    this.addConnections(1);
                    return this.poll();
                }
            }
            throw new HibernateException("The internal connection pool has reached its maximum size and no connection is currently available!");
        }
        conn.setAutoCommit(this.autoCommit);
        return conn;
    }

    public void close() throws SQLException {
        try {
            int allocationCount = this.allConnections.size() - this.availableConnections.size();
            if (allocationCount > 0) {
                log.error("Connection leak detected: there are " + allocationCount + " unclosed connections upon shutting down pool " + this.getUrl());
            }
        }
        finally {
            for (Connection connection : this.allConnections) {
                connection.close();
            }
        }
    }

    public int size() {
        return this.availableConnections.size();
    }

    protected void removeConnections(int numberToBeRemoved) {
        for (int i = 0; i < numberToBeRemoved; ++i) {
            Connection connection = this.availableConnections.poll();
            try {
                if (connection != null) {
                    connection.close();
                }
                this.allConnections.remove(connection);
                continue;
            }
            catch (SQLException e) {
                log.unableToCloseConnection(e);
            }
        }
    }

    protected void addConnections(int numberOfConnections) {
        for (int i = 0; i < numberOfConnections; ++i) {
            Connection connection = this.connectionCreator.createConnection();
            this.allConnections.add(connection);
            this.availableConnections.add(connection);
        }
    }

    public String getUrl() {
        return this.connectionCreator.getUrl();
    }

    public static class Builder {
        private final ConnectionCreator connectionCreator;
        private boolean autoCommit;
        private int initialSize = 1;
        private int minSize = 1;
        private int maxSize = 20;

        public Builder(ConnectionCreator connectionCreator, boolean autoCommit) {
            this.connectionCreator = connectionCreator;
            this.autoCommit = autoCommit;
        }

        public Builder initialSize(int initialSize) {
            this.initialSize = initialSize;
            return this;
        }

        public Builder minSize(int minSize) {
            this.minSize = minSize;
            return this;
        }

        public Builder maxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public PooledConnections build() {
            return new PooledConnections(this);
        }
    }
}

