/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.internal.compile;

import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.TemporalType;
import javax.persistence.criteria.ParameterExpression;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.query.Query;
import org.hibernate.query.criteria.internal.compile.ExplicitParameterInfo;
import org.hibernate.query.internal.AbstractProducedQuery;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.type.Type;

public class CriteriaQueryTypeQueryAdapter<X>
extends AbstractProducedQuery<X>
implements QueryImplementor<X> {
    private final SessionImplementor entityManager;
    private final QueryImplementor<X> jpqlQuery;
    private final Map<ParameterExpression<?>, ExplicitParameterInfo<?>> explicitParameterInfoMap;

    public CriteriaQueryTypeQueryAdapter(SessionImplementor entityManager, QueryImplementor<X> jpqlQuery, Map<ParameterExpression<?>, ExplicitParameterInfo<?>> explicitParameterInfoMap) {
        super(entityManager, jpqlQuery.getParameterMetadata());
        this.entityManager = entityManager;
        this.jpqlQuery = jpqlQuery;
        this.explicitParameterInfoMap = explicitParameterInfoMap;
    }

    @Override
    public List<X> getResultList() {
        return this.jpqlQuery.getResultList();
    }

    @Override
    public X getSingleResult() {
        return (X)this.jpqlQuery.getSingleResult();
    }

    @Override
    public int getMaxResults() {
        return this.jpqlQuery.getMaxResults();
    }

    @Override
    public QueryImplementor<X> setMaxResults(int i) {
        this.jpqlQuery.setMaxResults(i);
        return this;
    }

    @Override
    public int getFirstResult() {
        return this.jpqlQuery.getFirstResult();
    }

    @Override
    public QueryImplementor<X> setFirstResult(int i) {
        this.jpqlQuery.setFirstResult(i);
        return this;
    }

    @Override
    public Map<String, Object> getHints() {
        return this.jpqlQuery.getHints();
    }

    @Override
    public QueryImplementor<X> setHint(String name, Object value) {
        this.jpqlQuery.setHint(name, value);
        return this;
    }

    @Override
    protected boolean isNativeQuery() {
        return false;
    }

    @Override
    public String getQueryString() {
        return this.jpqlQuery.getQueryString();
    }

    @Override
    public FlushModeType getFlushMode() {
        return this.jpqlQuery.getFlushMode();
    }

    @Override
    public Type[] getReturnTypes() {
        return this.jpqlQuery.getReturnTypes();
    }

    @Override
    public QueryImplementor<X> setFlushMode(FlushModeType flushModeType) {
        this.jpqlQuery.setFlushMode(flushModeType);
        return this;
    }

    @Override
    public LockModeType getLockMode() {
        return this.jpqlQuery.getLockMode();
    }

    @Override
    public QueryImplementor<X> setLockMode(LockModeType lockModeType) {
        this.jpqlQuery.setLockMode(lockModeType);
        return this;
    }

    @Override
    public Query<X> setEntity(int position, Object val) {
        return null;
    }

    @Override
    public Query<X> setEntity(String name, Object val) {
        return null;
    }

    @Override
    public String[] getReturnAliases() {
        return new String[0];
    }

    @Override
    public Set<Parameter<?>> getParameters() {
        this.entityManager.checkOpen(false);
        return new HashSet(this.explicitParameterInfoMap.values());
    }

    @Override
    public boolean isBound(Parameter<?> param) {
        this.entityManager.checkOpen(false);
        return this.jpqlQuery.isBound(param);
    }

    @Override
    public <T> T getParameterValue(Parameter<T> param) {
        this.entityManager.checkOpen(false);
        ExplicitParameterInfo parameterInfo = this.resolveParameterInfo(param);
        if (parameterInfo.isNamed()) {
            return (T)this.jpqlQuery.getParameterValue(parameterInfo.getName());
        }
        return (T)this.jpqlQuery.getParameterValue(parameterInfo.getPosition());
    }

    private <T> ExplicitParameterInfo resolveParameterInfo(Parameter<T> param) {
        if (ExplicitParameterInfo.class.isInstance(param)) {
            return (ExplicitParameterInfo)param;
        }
        if (ParameterExpression.class.isInstance(param)) {
            return this.explicitParameterInfoMap.get((ParameterExpression)param);
        }
        for (ExplicitParameterInfo<?> parameterInfo : this.explicitParameterInfoMap.values()) {
            if (param.getName() != null && param.getName().equals(parameterInfo.getName())) {
                return parameterInfo;
            }
            if (param.getPosition() == null || !param.getPosition().equals(parameterInfo.getPosition())) continue;
            return parameterInfo;
        }
        throw new IllegalArgumentException("Unable to locate parameter [" + param + "] in query");
    }

    @Override
    public <T> QueryImplementor<X> setParameter(Parameter<T> param, T t) {
        this.entityManager.checkOpen(false);
        ExplicitParameterInfo parameterInfo = this.resolveParameterInfo(param);
        if (parameterInfo.isNamed()) {
            this.jpqlQuery.setParameter(parameterInfo.getName(), t);
        } else {
            this.jpqlQuery.setParameter(parameterInfo.getPosition(), t);
        }
        return this;
    }

    @Override
    public QueryImplementor<X> setParameter(Parameter<Calendar> param, Calendar calendar, TemporalType temporalType) {
        this.entityManager.checkOpen(false);
        ExplicitParameterInfo parameterInfo = this.resolveParameterInfo(param);
        if (parameterInfo.isNamed()) {
            this.jpqlQuery.setParameter(parameterInfo.getName(), calendar, temporalType);
        } else {
            this.jpqlQuery.setParameter((int)parameterInfo.getPosition(), calendar, temporalType);
        }
        return this;
    }

    @Override
    public QueryImplementor<X> setParameter(Parameter<Date> param, Date date, TemporalType temporalType) {
        this.entityManager.checkOpen(false);
        ExplicitParameterInfo parameterInfo = this.resolveParameterInfo(param);
        if (parameterInfo.isNamed()) {
            this.jpqlQuery.setParameter(parameterInfo.getName(), date, temporalType);
        } else {
            this.jpqlQuery.setParameter((int)parameterInfo.getPosition(), date, temporalType);
        }
        return this;
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        return (T)this.jpqlQuery.unwrap(cls);
    }

    @Override
    public Object getParameterValue(String name) {
        this.entityManager.checkOpen(false);
        this.locateParameterByName(name);
        return this.jpqlQuery.getParameterValue(name);
    }

    private ExplicitParameterInfo locateParameterByName(String name) {
        for (ExplicitParameterInfo<?> parameterInfo : this.explicitParameterInfoMap.values()) {
            if (!parameterInfo.isNamed() || !parameterInfo.getName().equals(name)) continue;
            return parameterInfo;
        }
        throw new IllegalArgumentException("Unable to locate parameter registered with that name [" + name + "]");
    }

    @Override
    public Parameter<?> getParameter(String name) {
        this.entityManager.checkOpen(false);
        return this.locateParameterByName(name);
    }

    @Override
    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        this.entityManager.checkOpen(false);
        ExplicitParameterInfo parameter = this.locateParameterByName(name);
        if (type.isAssignableFrom(parameter.getParameterType())) {
            return parameter;
        }
        throw new IllegalArgumentException("Named parameter [" + name + "] type is not assignanle to request type [" + type.getName() + "]");
    }

    @Override
    public QueryImplementor<X> setParameter(String name, Object value) {
        this.entityManager.checkOpen(true);
        ExplicitParameterInfo parameterInfo = this.locateParameterByName(name);
        parameterInfo.validateBindValue(value);
        this.jpqlQuery.setParameter(name, value);
        return this;
    }

    @Override
    public QueryImplementor<X> setParameter(String name, Calendar calendar, TemporalType temporalType) {
        this.entityManager.checkOpen(true);
        ExplicitParameterInfo parameterInfo = this.locateParameterByName(name);
        parameterInfo.validateCalendarBind();
        this.jpqlQuery.setParameter(name, calendar, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<X> setParameter(String name, Date date, TemporalType temporalType) {
        this.entityManager.checkOpen(true);
        ExplicitParameterInfo parameterInfo = this.locateParameterByName(name);
        parameterInfo.validateDateBind();
        this.jpqlQuery.setParameter(name, date, temporalType);
        return this;
    }

    @Override
    public int executeUpdate() {
        throw new IllegalStateException("Typed criteria queries do not support executeUpdate");
    }

    @Override
    public QueryImplementor<X> setParameter(int i, Object o) {
        throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
    }

    @Override
    public QueryImplementor<X> setParameter(int i, Calendar calendar, TemporalType temporalType) {
        throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
    }

    @Override
    public QueryImplementor<X> setParameter(int i, Date date, TemporalType temporalType) {
        throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
    }

    @Override
    public Object getParameterValue(int position) {
        throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
    }

    @Override
    public Parameter<?> getParameter(int position) {
        throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
    }

    @Override
    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
    }
}

