/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.SecondPass;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;

public class IndexOrUniqueKeySecondPass
implements SecondPass {
    private Table table;
    private final String indexName;
    private final String[] columns;
    private final MetadataBuildingContext buildingContext;
    private final Ejb3Column column;
    private final boolean unique;

    public IndexOrUniqueKeySecondPass(Table table, String indexName, String[] columns, MetadataBuildingContext buildingContext) {
        this.table = table;
        this.indexName = indexName;
        this.columns = columns;
        this.buildingContext = buildingContext;
        this.column = null;
        this.unique = false;
    }

    public IndexOrUniqueKeySecondPass(String indexName, Ejb3Column column, MetadataBuildingContext buildingContext) {
        this(indexName, column, buildingContext, false);
    }

    public IndexOrUniqueKeySecondPass(String indexName, Ejb3Column column, MetadataBuildingContext buildingContext, boolean unique) {
        this.indexName = indexName;
        this.column = column;
        this.columns = null;
        this.buildingContext = buildingContext;
        this.unique = unique;
    }

    @Override
    public void doSecondPass(Map persistentClasses) throws MappingException {
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                this.addConstraintToColumn(this.columns[i]);
            }
        }
        if (this.column != null) {
            this.table = this.column.getTable();
            this.addConstraintToColumn(this.buildingContext.getMetadataCollector().getLogicalColumnName(this.table, this.column.getMappingColumn().getQuotedName()));
        }
    }

    private void addConstraintToColumn(String columnName) {
        Column column = this.table.getColumn(new Column(this.buildingContext.getMetadataCollector().getPhysicalColumnName(this.table, columnName)));
        if (column == null) {
            throw new AnnotationException("@Index references a unknown column: " + columnName);
        }
        if (this.unique) {
            this.table.getOrCreateUniqueKey(this.indexName).addColumn(column);
        } else {
            this.table.getOrCreateIndex(this.indexName).addColumn(column);
        }
    }
}

