/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.PersistentObjectException;
import org.hibernate.TypeMismatchException;
import org.hibernate.WrongClassException;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.cache.spi.entry.ReferenceCacheEntryImpl;
import org.hibernate.cache.spi.entry.StandardCacheEntryImpl;
import org.hibernate.engine.internal.CacheHelper;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.internal.TwoPhaseLoad;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.AbstractLockUpgradeEventListener;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.type.EmbeddedComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;

public class DefaultLoadEventListener
extends AbstractLockUpgradeEventListener
implements LoadEventListener {
    public static final Object REMOVED_ENTITY_MARKER = new Object();
    public static final Object INCONSISTENT_RTN_CLASS_MARKER = new Object();
    public static final LockMode DEFAULT_LOCK_MODE = LockMode.NONE;
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultLoadEventListener.class);
    private static final boolean traceEnabled = LOG.isTraceEnabled();

    @Override
    public void onLoad(LoadEvent event, LoadEventListener.LoadType loadType) throws HibernateException {
        EntityPersister persister = this.getPersister(event);
        if (persister == null) {
            throw new HibernateException("Unable to locate persister: " + event.getEntityClassName());
        }
        Class idClass = persister.getIdentifierType().getReturnedClass();
        if (idClass != null && !idClass.isInstance(event.getEntityId())) {
            this.checkIdClass(persister, event, loadType, idClass);
        }
        this.doOnLoad(persister, event, loadType);
    }

    private EntityPersister getPersister(LoadEvent event) {
        if (event.getInstanceToLoad() != null) {
            event.setEntityClassName(event.getInstanceToLoad().getClass().getName());
            return event.getSession().getEntityPersister(null, event.getInstanceToLoad());
        }
        return event.getSession().getFactory().getEntityPersister(event.getEntityClassName());
    }

    private void doOnLoad(EntityPersister persister, LoadEvent event, LoadEventListener.LoadType loadType) {
        try {
            EntityKey keyToLoad = event.getSession().generateEntityKey(event.getEntityId(), persister);
            if (loadType.isNakedEntityReturned()) {
                event.setResult(this.load(event, persister, keyToLoad, loadType));
            } else if (event.getLockMode() == LockMode.NONE) {
                event.setResult(this.proxyOrLoad(event, persister, keyToLoad, loadType));
            } else {
                event.setResult(this.lockAndLoad(event, persister, keyToLoad, loadType, event.getSession()));
            }
        }
        catch (HibernateException e) {
            LOG.unableToLoadCommand(e);
            throw e;
        }
    }

    private void checkIdClass(EntityPersister persister, LoadEvent event, LoadEventListener.LoadType loadType, Class idClass) {
        EntityType dependentParentType;
        Type dependentParentIdType;
        Type singleSubType;
        EmbeddedComponentType dependentIdType;
        if (persister.getEntityMetamodel().getIdentifierProperty().isEmbedded() && (dependentIdType = (EmbeddedComponentType)persister.getEntityMetamodel().getIdentifierProperty().getType()).getSubtypes().length == 1 && (singleSubType = dependentIdType.getSubtypes()[0]).isEntityType() && (dependentParentIdType = (dependentParentType = (EntityType)singleSubType).getIdentifierOrUniqueKeyType(event.getSession().getFactory())).getReturnedClass().isInstance(event.getEntityId())) {
            this.loadByDerivedIdentitySimplePkValue(event, loadType, persister, dependentIdType, event.getSession().getFactory().getEntityPersister(dependentParentType.getAssociatedEntityName()));
            return;
        }
        throw new TypeMismatchException("Provided id of the wrong type for class " + persister.getEntityName() + ". Expected: " + idClass + ", got " + event.getEntityId().getClass());
    }

    private void loadByDerivedIdentitySimplePkValue(LoadEvent event, LoadEventListener.LoadType options, EntityPersister dependentPersister, EmbeddedComponentType dependentIdType, EntityPersister parentPersister) {
        EntityKey parentEntityKey = event.getSession().generateEntityKey(event.getEntityId(), parentPersister);
        Object parent = this.doLoad(event, parentPersister, parentEntityKey, options);
        Serializable dependent = (Serializable)dependentIdType.instantiate(parent, event.getSession());
        dependentIdType.setPropertyValues(dependent, new Object[]{parent}, dependentPersister.getEntityMode());
        EntityKey dependentEntityKey = event.getSession().generateEntityKey(dependent, dependentPersister);
        event.setEntityId(dependent);
        event.setResult(this.doLoad(event, dependentPersister, dependentEntityKey, options));
    }

    private Object load(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        boolean isOptionalInstance;
        if (event.getInstanceToLoad() != null) {
            if (event.getSession().getPersistenceContext().getEntry(event.getInstanceToLoad()) != null) {
                throw new PersistentObjectException("attempted to load into an instance that was already associated with the session: " + MessageHelper.infoString(persister, event.getEntityId(), event.getSession().getFactory()));
            }
            persister.setIdentifier(event.getInstanceToLoad(), event.getEntityId(), event.getSession());
        }
        Object entity = this.doLoad(event, persister, keyToLoad, options);
        boolean bl = isOptionalInstance = event.getInstanceToLoad() != null;
        if (entity == null && (!options.isAllowNulls() || isOptionalInstance)) {
            event.getSession().getFactory().getEntityNotFoundDelegate().handleEntityNotFound(event.getEntityClassName(), event.getEntityId());
        } else if (isOptionalInstance && entity != event.getInstanceToLoad()) {
            throw new NonUniqueObjectException(event.getEntityId(), event.getEntityClassName());
        }
        return entity;
    }

    private Object proxyOrLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        if (traceEnabled) {
            LOG.tracev("Loading entity: {0}", MessageHelper.infoString(persister, event.getEntityId(), event.getSession().getFactory()));
        }
        if (!persister.hasProxy()) {
            return this.load(event, persister, keyToLoad, options);
        }
        PersistenceContext persistenceContext = event.getSession().getPersistenceContext();
        Object proxy = persistenceContext.getProxy(keyToLoad);
        if (proxy != null) {
            return this.returnNarrowedProxy(event, persister, keyToLoad, options, persistenceContext, proxy);
        }
        if (options.isAllowProxyCreation()) {
            return this.createProxyIfNecessary(event, persister, keyToLoad, options, persistenceContext);
        }
        return this.load(event, persister, keyToLoad, options);
    }

    private Object returnNarrowedProxy(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options, PersistenceContext persistenceContext, Object proxy) {
        LazyInitializer li;
        if (traceEnabled) {
            LOG.trace("Entity proxy found in session cache");
        }
        if ((li = ((HibernateProxy)proxy).getHibernateLazyInitializer()).isUnwrap()) {
            return li.getImplementation();
        }
        Object impl = null;
        if (!options.isAllowProxyCreation() && (impl = this.load(event, persister, keyToLoad, options)) == null) {
            event.getSession().getFactory().getEntityNotFoundDelegate().handleEntityNotFound(persister.getEntityName(), keyToLoad.getIdentifier());
        }
        return persistenceContext.narrowProxy(proxy, persister, keyToLoad, impl);
    }

    private Object createProxyIfNecessary(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options, PersistenceContext persistenceContext) {
        Object existing = persistenceContext.getEntity(keyToLoad);
        if (existing != null) {
            EntityEntry entry;
            Status status;
            if (traceEnabled) {
                LOG.trace("Entity found in session cache");
            }
            if (options.isCheckDeleted() && ((status = (entry = persistenceContext.getEntry(existing)).getStatus()) == Status.DELETED || status == Status.GONE)) {
                return null;
            }
            return existing;
        }
        if (traceEnabled) {
            LOG.trace("Creating new proxy for entity");
        }
        Object proxy = persister.createProxy(event.getEntityId(), event.getSession());
        persistenceContext.getBatchFetchQueue().addBatchLoadableEntityKey(keyToLoad);
        persistenceContext.addProxy(keyToLoad, proxy);
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object lockAndLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options, SessionImplementor source) {
        Object entity;
        Object ck;
        SoftLock lock = null;
        EntityRegionAccessStrategy cache = persister.getCacheAccessStrategy();
        if (persister.hasCache()) {
            ck = cache.generateCacheKey(event.getEntityId(), persister, source.getFactory(), source.getTenantIdentifier());
            lock = persister.getCacheAccessStrategy().lockItem(source, ck, null);
        } else {
            ck = null;
        }
        try {
            entity = this.load(event, persister, keyToLoad, options);
            if (!persister.hasCache()) return event.getSession().getPersistenceContext().proxyFor(persister, keyToLoad, entity);
        }
        catch (Throwable throwable) {
            if (!persister.hasCache()) throw throwable;
            cache.unlockItem(source, ck, lock);
            throw throwable;
        }
        cache.unlockItem(source, ck, lock);
        return event.getSession().getPersistenceContext().proxyFor(persister, keyToLoad, entity);
    }

    private Object doLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        Object entity;
        if (traceEnabled) {
            LOG.tracev("Attempting to resolve: {0}", MessageHelper.infoString(persister, event.getEntityId(), event.getSession().getFactory()));
        }
        if ((entity = this.loadFromSessionCache(event, keyToLoad, options)) == REMOVED_ENTITY_MARKER) {
            LOG.debug("Load request found matching entity in context, but it is scheduled for removal; returning null");
            return null;
        }
        if (entity == INCONSISTENT_RTN_CLASS_MARKER) {
            LOG.debug("Load request found matching entity in context, but the matched entity was of an inconsistent return type; returning null");
            return null;
        }
        if (entity != null) {
            if (traceEnabled) {
                LOG.tracev("Resolved object in session cache: {0}", MessageHelper.infoString(persister, event.getEntityId(), event.getSession().getFactory()));
            }
            return entity;
        }
        entity = this.loadFromSecondLevelCache(event, persister, keyToLoad);
        if (entity != null) {
            if (traceEnabled) {
                LOG.tracev("Resolved object in second-level cache: {0}", MessageHelper.infoString(persister, event.getEntityId(), event.getSession().getFactory()));
            }
        } else {
            if (traceEnabled) {
                LOG.tracev("Object not resolved in any cache: {0}", MessageHelper.infoString(persister, event.getEntityId(), event.getSession().getFactory()));
            }
            entity = this.loadFromDatasource(event, persister);
        }
        if (entity != null && persister.hasNaturalIdentifier()) {
            event.getSession().getPersistenceContext().getNaturalIdHelper().cacheNaturalIdCrossReferenceFromLoad(persister, event.getEntityId(), event.getSession().getPersistenceContext().getNaturalIdHelper().extractNaturalIdValues(entity, persister));
        }
        return entity;
    }

    private Object loadFromDatasource(LoadEvent event, EntityPersister persister) {
        Object entity = persister.load(event.getEntityId(), event.getInstanceToLoad(), event.getLockOptions(), (SessionImplementor)event.getSession());
        if (event.isAssociationFetch() && event.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
            event.getSession().getFactory().getStatisticsImplementor().fetchEntity(event.getEntityClassName());
        }
        return entity;
    }

    protected Object loadFromSessionCache(LoadEvent event, EntityKey keyToLoad, LoadEventListener.LoadType options) throws HibernateException {
        EventSource session = event.getSession();
        Object old = session.getEntityUsingInterceptor(keyToLoad);
        if (old != null) {
            EntityPersister persister;
            Status status;
            EntityEntry oldEntry = session.getPersistenceContext().getEntry(old);
            if (options.isCheckDeleted() && ((status = oldEntry.getStatus()) == Status.DELETED || status == Status.GONE)) {
                return REMOVED_ENTITY_MARKER;
            }
            if (options.isAllowNulls() && !(persister = event.getSession().getFactory().getEntityPersister(keyToLoad.getEntityName())).isInstance(old)) {
                return INCONSISTENT_RTN_CLASS_MARKER;
            }
            this.upgradeLock(old, oldEntry, event.getLockOptions(), event.getSession());
        }
        return old;
    }

    private Object loadFromSecondLevelCache(LoadEvent event, EntityPersister persister, EntityKey entityKey) {
        boolean useCache;
        EventSource source = event.getSession();
        boolean bl = useCache = persister.hasCache() && source.getCacheMode().isGetEnabled() && event.getLockMode().lessThan(LockMode.READ);
        if (!useCache) {
            return null;
        }
        Object ce = this.getFromSharedCache(event, persister, source);
        if (ce == null) {
            return null;
        }
        return this.processCachedEntry(event, persister, ce, source, entityKey);
    }

    private Object processCachedEntry(LoadEvent event, EntityPersister persister, Object ce, SessionImplementor source, EntityKey entityKey) {
        CacheEntry entry = (CacheEntry)persister.getCacheEntryStructure().destructure(ce, source.getFactory());
        if (entry.isReferenceEntry()) {
            if (event.getInstanceToLoad() != null) {
                throw new HibernateException("Attempt to load entity [%s] from cache using provided object instance, but cache is storing references: " + event.getEntityId());
            }
            return this.convertCacheReferenceEntryToEntity((ReferenceCacheEntryImpl)entry, event.getSession(), entityKey);
        }
        Object entity = this.convertCacheEntryToEntity(entry, event.getEntityId(), persister, event, entityKey);
        if (!persister.isInstance(entity)) {
            throw new WrongClassException("loaded object was of wrong class " + entity.getClass(), event.getEntityId(), persister.getEntityName());
        }
        return entity;
    }

    private Object getFromSharedCache(LoadEvent event, EntityPersister persister, SessionImplementor source) {
        EntityRegionAccessStrategy cache = persister.getCacheAccessStrategy();
        Object ck = cache.generateCacheKey(event.getEntityId(), persister, source.getFactory(), source.getTenantIdentifier());
        Serializable ce = CacheHelper.fromSharedCache(source, ck, persister.getCacheAccessStrategy());
        if (source.getFactory().getStatistics().isStatisticsEnabled()) {
            if (ce == null) {
                source.getFactory().getStatisticsImplementor().secondLevelCacheMiss(cache.getRegion().getName());
            } else {
                source.getFactory().getStatisticsImplementor().secondLevelCacheHit(cache.getRegion().getName());
            }
        }
        return ce;
    }

    private Object convertCacheReferenceEntryToEntity(ReferenceCacheEntryImpl referenceCacheEntry, EventSource session, EntityKey entityKey) {
        Object entity = referenceCacheEntry.getReference();
        if (entity == null) {
            throw new IllegalStateException("Reference cache entry contained null : " + referenceCacheEntry.toString());
        }
        this.makeEntityCircularReferenceSafe(referenceCacheEntry, session, entity, entityKey);
        return entity;
    }

    private void makeEntityCircularReferenceSafe(ReferenceCacheEntryImpl referenceCacheEntry, EventSource session, Object entity, EntityKey entityKey) {
        StatefulPersistenceContext statefulPersistenceContext = (StatefulPersistenceContext)session.getPersistenceContext();
        if (entity instanceof ManagedEntity) {
            statefulPersistenceContext.addReferenceEntry(entity, Status.READ_ONLY);
        } else {
            TwoPhaseLoad.addUninitializedCachedEntity(entityKey, entity, referenceCacheEntry.getSubclassPersister(), LockMode.NONE, referenceCacheEntry.areLazyPropertiesUnfetched(), referenceCacheEntry.getVersion(), session);
        }
        statefulPersistenceContext.initializeNonLazyCollections();
    }

    private Object convertCacheEntryToEntity(CacheEntry entry, Serializable entityId, EntityPersister persister, LoadEvent event, EntityKey entityKey) {
        EventSource session = event.getSession();
        SessionFactoryImplementor factory = session.getFactory();
        if (traceEnabled) {
            LOG.tracef("Converting second-level cache entry [%s] into entity : %s", entry, MessageHelper.infoString(persister, entityId, factory));
        }
        EntityPersister subclassPersister = factory.getEntityPersister(entry.getSubclass());
        Object optionalObject = event.getInstanceToLoad();
        Object entity = optionalObject == null ? session.instantiate(subclassPersister, entityId) : optionalObject;
        TwoPhaseLoad.addUninitializedCachedEntity(entityKey, entity, subclassPersister, LockMode.NONE, entry.areLazyPropertiesUnfetched(), entry.getVersion(), session);
        PersistenceContext persistenceContext = session.getPersistenceContext();
        Type[] types = subclassPersister.getPropertyTypes();
        Object[] values = ((StandardCacheEntryImpl)entry).assemble(entity, entityId, subclassPersister, session.getInterceptor(), session);
        if (((StandardCacheEntryImpl)entry).isDeepCopyNeeded()) {
            TypeHelper.deepCopy(values, types, subclassPersister.getPropertyUpdateability(), values, session);
        }
        Object version = Versioning.getVersion(values, subclassPersister);
        LOG.tracef("Cached Version : %s", version);
        Object proxy = persistenceContext.getProxy(entityKey);
        boolean isReadOnly = proxy != null ? ((HibernateProxy)proxy).getHibernateLazyInitializer().isReadOnly() : session.isDefaultReadOnly();
        persistenceContext.addEntry(entity, isReadOnly ? Status.READ_ONLY : Status.MANAGED, values, null, entityId, version, LockMode.NONE, true, subclassPersister, false, entry.areLazyPropertiesUnfetched());
        subclassPersister.afterInitialize(entity, entry.areLazyPropertiesUnfetched(), session);
        persistenceContext.initializeNonLazyCollections();
        PostLoadEvent postLoadEvent = event.getPostLoadEvent().setEntity(entity).setId(entityId).setPersister(persister);
        for (PostLoadEventListener listener : this.postLoadEventListeners(session)) {
            listener.onPostLoad(postLoadEvent);
        }
        return entity;
    }

    private Object assembleCacheEntry(StandardCacheEntryImpl entry, Serializable id, EntityPersister persister, LoadEvent event) throws HibernateException {
        Object optionalObject = event.getInstanceToLoad();
        EventSource session = event.getSession();
        SessionFactoryImplementor factory = session.getFactory();
        if (traceEnabled) {
            LOG.tracev("Assembling entity from second-level cache: {0}", MessageHelper.infoString(persister, id, factory));
        }
        EntityPersister subclassPersister = factory.getEntityPersister(entry.getSubclass());
        Object result = optionalObject == null ? session.instantiate(subclassPersister, id) : optionalObject;
        EntityKey entityKey = session.generateEntityKey(id, subclassPersister);
        TwoPhaseLoad.addUninitializedCachedEntity(entityKey, result, subclassPersister, LockMode.NONE, entry.areLazyPropertiesUnfetched(), entry.getVersion(), session);
        Type[] types = subclassPersister.getPropertyTypes();
        Object[] values = entry.assemble(result, id, subclassPersister, session.getInterceptor(), session);
        TypeHelper.deepCopy(values, types, subclassPersister.getPropertyUpdateability(), values, session);
        Object version = Versioning.getVersion(values, subclassPersister);
        LOG.tracev("Cached Version: {0}", version);
        PersistenceContext persistenceContext = session.getPersistenceContext();
        boolean isReadOnly = session.isDefaultReadOnly();
        if (persister.isMutable()) {
            Object proxy = persistenceContext.getProxy(entityKey);
            if (proxy != null) {
                isReadOnly = ((HibernateProxy)proxy).getHibernateLazyInitializer().isReadOnly();
            }
        } else {
            isReadOnly = true;
        }
        persistenceContext.addEntry(result, isReadOnly ? Status.READ_ONLY : Status.MANAGED, values, null, id, version, LockMode.NONE, true, subclassPersister, false, entry.areLazyPropertiesUnfetched());
        subclassPersister.afterInitialize(result, entry.areLazyPropertiesUnfetched(), session);
        persistenceContext.initializeNonLazyCollections();
        PostLoadEvent postLoadEvent = event.getPostLoadEvent().setEntity(result).setId(id).setPersister(persister);
        for (PostLoadEventListener listener : this.postLoadEventListeners(session)) {
            listener.onPostLoad(postLoadEvent);
        }
        return result;
    }

    private Iterable<PostLoadEventListener> postLoadEventListeners(EventSource session) {
        return session.getFactory().getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(EventType.POST_LOAD).listeners();
    }

    private EventListenerGroup<PostLoadEventListener> getEvenListenerGroup(EventSource session) {
        return session.getFactory().getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(EventType.POST_LOAD);
    }
}

