/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityNotFoundException;
import javax.transaction.SystemException;
import org.hibernate.CacheMode;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.Criteria;
import org.hibernate.EmptyInterceptor;
import org.hibernate.EntityNameResolver;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.IdentifierLoadAccess;
import org.hibernate.Interceptor;
import org.hibernate.LobHelper;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.NaturalIdLoadAccess;
import org.hibernate.ObjectDeletedException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.ReplicationMode;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionEventListener;
import org.hibernate.SessionException;
import org.hibernate.SharedSessionBuilder;
import org.hibernate.SimpleNaturalIdLoadAccess;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.TransientObjectException;
import org.hibernate.TypeHelper;
import org.hibernate.UnknownProfileException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.criterion.NaturalIdentifier;
import org.hibernate.engine.internal.SessionEventListenerManagerImpl;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.NonContextualLobCreator;
import org.hibernate.engine.jdbc.internal.JdbcCoordinatorImpl;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.query.spi.FilterQueryPlan;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.query.spi.NativeSQLQueryPlan;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SessionOwner;
import org.hibernate.engine.spi.Status;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.engine.transaction.spi.TransactionObserver;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.AutoFlushEvent;
import org.hibernate.event.spi.AutoFlushEventListener;
import org.hibernate.event.spi.ClearEvent;
import org.hibernate.event.spi.ClearEventListener;
import org.hibernate.event.spi.DeleteEvent;
import org.hibernate.event.spi.DeleteEventListener;
import org.hibernate.event.spi.DirtyCheckEvent;
import org.hibernate.event.spi.DirtyCheckEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.EvictEvent;
import org.hibernate.event.spi.EvictEventListener;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.InitializeCollectionEvent;
import org.hibernate.event.spi.InitializeCollectionEventListener;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.event.spi.LockEvent;
import org.hibernate.event.spi.LockEventListener;
import org.hibernate.event.spi.MergeEvent;
import org.hibernate.event.spi.MergeEventListener;
import org.hibernate.event.spi.PersistEvent;
import org.hibernate.event.spi.PersistEventListener;
import org.hibernate.event.spi.RefreshEvent;
import org.hibernate.event.spi.RefreshEventListener;
import org.hibernate.event.spi.ReplicateEvent;
import org.hibernate.event.spi.ReplicateEventListener;
import org.hibernate.event.spi.ResolveNaturalIdEvent;
import org.hibernate.event.spi.ResolveNaturalIdEventListener;
import org.hibernate.event.spi.SaveOrUpdateEvent;
import org.hibernate.event.spi.SaveOrUpdateEventListener;
import org.hibernate.internal.AbstractSessionImpl;
import org.hibernate.internal.CollectionFilterImpl;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.internal.FilterImpl;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.jdbc.Work;
import org.hibernate.jdbc.WorkExecutor;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.hibernate.loader.criteria.CriteriaLoader;
import org.hibernate.loader.custom.CustomLoader;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.resource.jdbc.spi.JdbcSessionContext;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.resource.transaction.TransactionCoordinator;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionCoordinatorImpl;
import org.hibernate.resource.transaction.backend.jta.internal.synchronization.AfterCompletionAction;
import org.hibernate.resource.transaction.backend.jta.internal.synchronization.ExceptionMapper;
import org.hibernate.resource.transaction.backend.jta.internal.synchronization.ManagedFlushChecker;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.hibernate.stat.SessionStatistics;
import org.hibernate.stat.internal.SessionStatisticsImpl;

public final class SessionImpl
extends AbstractSessionImpl
implements EventSource {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(SessionImpl.class);
    private static final boolean TRACE_ENABLED = LOG.isTraceEnabled();
    private transient long timestamp;
    private transient SessionOwner sessionOwner;
    private transient ActionQueue actionQueue;
    private transient StatefulPersistenceContext persistenceContext;
    private transient TransactionCoordinator transactionCoordinator;
    private transient JdbcCoordinatorImpl jdbcCoordinator;
    private transient Interceptor interceptor;
    private StatementInspector statementInspector;
    private transient EntityNameResolver entityNameResolver = new CoordinatingEntityNameResolver();
    private transient ConnectionReleaseMode connectionReleaseMode;
    private transient FlushMode flushMode = FlushMode.AUTO;
    private transient CacheMode cacheMode = CacheMode.NORMAL;
    private transient boolean autoClear;
    private transient boolean autoJoinTransactions = true;
    private transient boolean flushBeforeCompletionEnabled;
    private transient boolean autoCloseSessionEnabled;
    private transient int dontFlushFromFind;
    private transient LoadQueryInfluencers loadQueryInfluencers;
    private final transient boolean isTransactionCoordinatorShared;
    private transient TransactionObserver transactionObserver;
    private SessionEventListenerManagerImpl sessionEventsManager = new SessionEventListenerManagerImpl();
    private transient JdbcSessionContext jdbcSessionContext;
    private transient ExceptionMapper exceptionMapper;
    private transient ManagedFlushChecker managedFlushChecker;
    private transient AfterCompletionAction afterCompletionAction;
    private transient LoadEvent loadEvent;
    private transient LobHelperImpl lobHelper;
    private static final ExceptionMapper STANDARD_EXCEPTION_MAPPER = new ExceptionMapper(){

        @Override
        public RuntimeException mapStatusCheckFailure(String message, SystemException systemException) {
            return new TransactionException("could not determine transaction status in beforeCompletion()", systemException);
        }

        @Override
        public RuntimeException mapManagedFlushFailure(String message, RuntimeException failure) {
            LOG.unableToPerformManagedFlush(failure.getMessage());
            return failure;
        }
    };
    private static final AfterCompletionAction STANDARD_AFTER_COMPLETION_ACTION = new AfterCompletionAction(){

        @Override
        public void doAction(boolean successful) {
        }
    };
    private static final ManagedFlushChecker STANDARD_MANAGED_FLUSH_CHECKER = new ManagedFlushChecker(){

        @Override
        public boolean shouldDoManagedFlush(SessionImpl session) {
            boolean isFlushModeNever = session.isFlushModeNever();
            return !isFlushModeNever && !session.flushBeforeCompletionEnabled || !session.isClosed() && !isFlushModeNever && session.flushBeforeCompletionEnabled;
        }
    };

    SessionImpl(Connection connection, SessionFactoryImpl factory, SessionOwner sessionOwner, TransactionCoordinator transactionCoordinator, JdbcCoordinatorImpl jdbcCoordinator, Transaction transaction, ActionQueue.TransactionCompletionProcesses transactionCompletionProcesses, boolean autoJoinTransactions, long timestamp, Interceptor interceptor, StatementInspector statementInspector, final boolean flushBeforeCompletionEnabled, final boolean autoCloseSessionEnabled, ConnectionReleaseMode connectionReleaseMode, String tenantIdentifier) {
        super(factory, tenantIdentifier);
        this.timestamp = timestamp;
        this.sessionOwner = sessionOwner;
        this.interceptor = interceptor == null ? EmptyInterceptor.INSTANCE : interceptor;
        this.actionQueue = new ActionQueue(this);
        this.persistenceContext = new StatefulPersistenceContext(this);
        this.autoCloseSessionEnabled = autoCloseSessionEnabled;
        this.flushBeforeCompletionEnabled = flushBeforeCompletionEnabled;
        this.initializeFromSessionOwner(sessionOwner);
        this.statementInspector = statementInspector == null ? new StatementInspector(){

            @Override
            public String inspect(String sql) {
                return SessionImpl.this.interceptor.onPrepareStatement(sql);
            }
        } : statementInspector;
        this.jdbcSessionContext = new AbstractSessionImpl.JdbcSessionContextImpl(factory, this.statementInspector);
        if (transactionCoordinator == null) {
            this.isTransactionCoordinatorShared = false;
            this.connectionReleaseMode = connectionReleaseMode;
            this.autoJoinTransactions = autoJoinTransactions;
            this.jdbcCoordinator = new JdbcCoordinatorImpl(connection, this);
            this.transactionCoordinator = this.getTransactionCoordinatorBuilder().buildTransactionCoordinator(this.jdbcCoordinator, this);
            this.currentHibernateTransaction = this.getTransaction();
        } else {
            if (connection != null) {
                throw new SessionException("Cannot simultaneously share transaction context and specify connection");
            }
            this.transactionCoordinator = transactionCoordinator;
            this.jdbcCoordinator = jdbcCoordinator;
            this.currentHibernateTransaction = transaction;
            this.isTransactionCoordinatorShared = true;
            this.autoJoinTransactions = false;
            if (transactionCompletionProcesses != null) {
                this.actionQueue.setTransactionCompletionProcesses(transactionCompletionProcesses, true);
            }
            if (autoJoinTransactions) {
                LOG.debug("Session creation specified 'autoJoinTransactions', which is invalid in conjunction with sharing JDBC connection between sessions; ignoring");
            }
            if (connectionReleaseMode != this.jdbcCoordinator.getConnectionReleaseMode()) {
                LOG.debug("Session creation specified 'getConnectionReleaseMode', which is invalid in conjunction with sharing JDBC connection between sessions; ignoring");
            }
            this.connectionReleaseMode = this.jdbcCoordinator.getConnectionReleaseMode();
            this.transactionObserver = new TransactionObserver(){

                @Override
                public void afterBegin() {
                }

                @Override
                public void beforeCompletion() {
                    if (SessionImpl.this.isOpen() && flushBeforeCompletionEnabled) {
                        SessionImpl.this.managedFlush();
                    }
                    SessionImpl.this.actionQueue.beforeTransactionCompletion();
                    try {
                        SessionImpl.this.interceptor.beforeTransactionCompletion(SessionImpl.this.currentHibernateTransaction);
                    }
                    catch (Throwable t) {
                        LOG.exceptionInBeforeTransactionCompletionInterceptor(t);
                    }
                }

                @Override
                public void afterCompletion(boolean successful, boolean delayed) {
                    SessionImpl.this.afterTransactionCompletion(successful, delayed);
                    if (!SessionImpl.this.isClosed() && autoCloseSessionEnabled) {
                        SessionImpl.this.managedClose();
                    }
                }
            };
            transactionCoordinator.addObserver(this.transactionObserver);
        }
        this.loadQueryInfluencers = new LoadQueryInfluencers(factory);
        if (factory.getStatistics().isStatisticsEnabled()) {
            factory.getStatisticsImplementor().openSession();
        }
        if (TRACE_ENABLED) {
            LOG.tracef("Opened session at timestamp: %s", timestamp);
        }
    }

    private void initializeFromSessionOwner(SessionOwner sessionOwner) {
        if (sessionOwner != null) {
            this.exceptionMapper = sessionOwner.getExceptionMapper() != null ? sessionOwner.getExceptionMapper() : STANDARD_EXCEPTION_MAPPER;
            this.afterCompletionAction = sessionOwner.getAfterCompletionAction() != null ? sessionOwner.getAfterCompletionAction() : STANDARD_AFTER_COMPLETION_ACTION;
            this.managedFlushChecker = sessionOwner.getManagedFlushChecker() != null ? sessionOwner.getManagedFlushChecker() : STANDARD_MANAGED_FLUSH_CHECKER;
        } else {
            this.exceptionMapper = STANDARD_EXCEPTION_MAPPER;
            this.afterCompletionAction = STANDARD_AFTER_COMPLETION_ACTION;
            this.managedFlushChecker = STANDARD_MANAGED_FLUSH_CHECKER;
        }
    }

    @Override
    public SharedSessionBuilder sessionWithOptions() {
        return new SharedSessionBuilderImpl(this);
    }

    @Override
    public void clear() {
        this.errorIfClosed();
        this.pulseTransactionCoordinator();
        this.internalClear();
    }

    private void internalClear() {
        this.persistenceContext.clear();
        this.actionQueue.clear();
        ClearEvent event = new ClearEvent(this);
        for (ClearEventListener listener : this.listeners(EventType.CLEAR)) {
            listener.onClear(event);
        }
    }

    @Override
    public long getTimestamp() {
        this.checkTransactionSynchStatus();
        return this.timestamp;
    }

    @Override
    public void close() throws HibernateException {
        LOG.trace("Closing session");
        if (this.isClosed()) {
            throw new SessionException("Session was already closed");
        }
        if (this.factory.getStatistics().isStatisticsEnabled()) {
            this.factory.getStatisticsImplementor().closeSession();
        }
        this.getEventListenerManager().end();
        try {
            if (!this.isTransactionCoordinatorShared) {
                this.jdbcCoordinator.close();
                return;
            }
            if (this.getActionQueue().hasBeforeTransactionActions() || this.getActionQueue().hasAfterTransactionActions()) {
                LOG.warn("On close, shared Session had before / after transaction actions that have not yet been processed");
            }
            return;
        }
        finally {
            this.setClosed();
            this.cleanup();
        }
    }

    @Override
    public boolean isAutoCloseSessionEnabled() {
        return this.autoCloseSessionEnabled;
    }

    @Override
    public boolean shouldAutoJoinTransaction() {
        return this.autoJoinTransactions;
    }

    @Override
    public boolean isOpen() {
        this.checkTransactionSynchStatus();
        return !this.isClosed();
    }

    private boolean isFlushModeNever() {
        return FlushMode.isManualFlushMode(this.getFlushMode());
    }

    private void managedFlush() {
        if (this.isClosed()) {
            LOG.trace("Skipping auto-flush due to session closed");
            return;
        }
        LOG.trace("Automatically flushing session");
        this.flush();
    }

    @Override
    public boolean shouldAutoClose() {
        if (this.isClosed()) {
            return false;
        }
        if (this.sessionOwner != null) {
            return this.sessionOwner.shouldAutoCloseSession();
        }
        return this.isAutoCloseSessionEnabled();
    }

    private void managedClose() {
        LOG.trace("Automatically closing session");
        this.close();
    }

    @Override
    public Connection connection() throws HibernateException {
        this.errorIfClosed();
        return this.jdbcCoordinator.getLogicalConnection().getPhysicalConnection();
    }

    @Override
    public boolean isConnected() {
        this.checkTransactionSynchStatus();
        return !this.isClosed() && this.jdbcCoordinator.getLogicalConnection().isOpen();
    }

    @Override
    public boolean isTransactionInProgress() {
        this.checkTransactionSynchStatus();
        return !this.isClosed() && this.transactionCoordinator.getTransactionDriverControl().getStatus() == TransactionStatus.ACTIVE && this.transactionCoordinator.isJoined();
    }

    @Override
    public Connection disconnect() throws HibernateException {
        this.errorIfClosed();
        LOG.debug("Disconnecting session");
        return this.jdbcCoordinator.getLogicalConnection().manualDisconnect();
    }

    @Override
    public void reconnect(Connection conn) throws HibernateException {
        this.errorIfClosed();
        LOG.debug("Reconnecting session");
        this.checkTransactionSynchStatus();
        this.jdbcCoordinator.getLogicalConnection().manualReconnect(conn);
    }

    @Override
    public void setAutoClear(boolean enabled) {
        this.errorIfClosed();
        this.autoClear = enabled;
    }

    @Override
    public void disableTransactionAutoJoin() {
        this.errorIfClosed();
        this.autoJoinTransactions = false;
    }

    public void afterOperation(boolean success) {
        if (!this.isTransactionInProgress()) {
            this.jdbcCoordinator.afterTransaction();
        }
    }

    @Override
    public SessionEventListenerManagerImpl getEventListenerManager() {
        return this.sessionEventsManager;
    }

    @Override
    public void addEventListeners(SessionEventListener ... listeners) {
        this.getEventListenerManager().addListener(listeners);
    }

    private void cleanup() {
        this.persistenceContext.clear();
    }

    @Override
    public LockMode getCurrentLockMode(Object object) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (object == null) {
            throw new NullPointerException("null object passed to getCurrentLockMode()");
        }
        if (object instanceof HibernateProxy && (object = ((HibernateProxy)object).getHibernateLazyInitializer().getImplementation(this)) == null) {
            return LockMode.NONE;
        }
        EntityEntry e = this.persistenceContext.getEntry(object);
        if (e == null) {
            throw new TransientObjectException("Given object not associated with the session");
        }
        if (e.getStatus() != Status.MANAGED) {
            throw new ObjectDeletedException("The given object was deleted", e.getId(), e.getPersister().getEntityName());
        }
        return e.getLockMode();
    }

    @Override
    public Object getEntityUsingInterceptor(EntityKey key) throws HibernateException {
        this.errorIfClosed();
        Object result = this.persistenceContext.getEntity(key);
        if (result == null) {
            Object newObject = this.interceptor.getEntity(key.getEntityName(), key.getIdentifier());
            if (newObject != null) {
                this.lock(newObject, LockMode.NONE);
            }
            return newObject;
        }
        return result;
    }

    private void checkNoUnresolvedActionsBeforeOperation() {
        if (this.persistenceContext.getCascadeLevel() == 0 && this.actionQueue.hasUnresolvedEntityInsertActions()) {
            throw new IllegalStateException("There are delayed insert actions before operation as cascade level 0.");
        }
    }

    private void checkNoUnresolvedActionsAfterOperation() {
        if (this.persistenceContext.getCascadeLevel() == 0) {
            this.actionQueue.checkNoUnresolvedActionsAfterOperation();
        }
        this.delayedAfterCompletion();
    }

    private void delayedAfterCompletion() {
        if (this.transactionCoordinator instanceof JtaTransactionCoordinatorImpl) {
            ((JtaTransactionCoordinatorImpl)this.transactionCoordinator).getSynchronizationCallbackCoordinator().processAnyDelayedAfterCompletion();
        }
    }

    @Override
    public void saveOrUpdate(Object object) throws HibernateException {
        this.saveOrUpdate(null, object);
    }

    @Override
    public void saveOrUpdate(String entityName, Object obj) throws HibernateException {
        this.fireSaveOrUpdate(new SaveOrUpdateEvent(entityName, obj, this));
    }

    private void fireSaveOrUpdate(SaveOrUpdateEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.checkNoUnresolvedActionsBeforeOperation();
        for (SaveOrUpdateEventListener listener : this.listeners(EventType.SAVE_UPDATE)) {
            listener.onSaveOrUpdate(event);
        }
        this.checkNoUnresolvedActionsAfterOperation();
    }

    private <T> Iterable<T> listeners(EventType<T> type) {
        return this.eventListenerGroup(type).listeners();
    }

    private <T> EventListenerGroup<T> eventListenerGroup(EventType<T> type) {
        return this.factory.getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(type);
    }

    @Override
    public Serializable save(Object obj) throws HibernateException {
        return this.save(null, obj);
    }

    @Override
    public Serializable save(String entityName, Object object) throws HibernateException {
        return this.fireSave(new SaveOrUpdateEvent(entityName, object, this));
    }

    private Serializable fireSave(SaveOrUpdateEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.checkNoUnresolvedActionsBeforeOperation();
        for (SaveOrUpdateEventListener listener : this.listeners(EventType.SAVE)) {
            listener.onSaveOrUpdate(event);
        }
        this.checkNoUnresolvedActionsAfterOperation();
        return event.getResultId();
    }

    @Override
    public void update(Object obj) throws HibernateException {
        this.update(null, obj);
    }

    @Override
    public void update(String entityName, Object object) throws HibernateException {
        this.fireUpdate(new SaveOrUpdateEvent(entityName, object, this));
    }

    private void fireUpdate(SaveOrUpdateEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.checkNoUnresolvedActionsBeforeOperation();
        for (SaveOrUpdateEventListener listener : this.listeners(EventType.UPDATE)) {
            listener.onSaveOrUpdate(event);
        }
        this.checkNoUnresolvedActionsAfterOperation();
    }

    @Override
    public void lock(String entityName, Object object, LockMode lockMode) throws HibernateException {
        this.fireLock(new LockEvent(entityName, object, lockMode, (EventSource)this));
    }

    @Override
    public Session.LockRequest buildLockRequest(LockOptions lockOptions) {
        return new LockRequestImpl(lockOptions);
    }

    @Override
    public void lock(Object object, LockMode lockMode) throws HibernateException {
        this.fireLock(new LockEvent(object, lockMode, (EventSource)this));
    }

    private void fireLock(String entityName, Object object, LockOptions options) {
        this.fireLock(new LockEvent(entityName, object, options, (EventSource)this));
    }

    private void fireLock(Object object, LockOptions options) {
        this.fireLock(new LockEvent(object, options, (EventSource)this));
    }

    private void fireLock(LockEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (LockEventListener listener : this.listeners(EventType.LOCK)) {
            listener.onLock(event);
        }
        this.delayedAfterCompletion();
    }

    @Override
    public void persist(String entityName, Object object) throws HibernateException {
        this.firePersist(new PersistEvent(entityName, object, this));
    }

    @Override
    public void persist(Object object) throws HibernateException {
        this.persist(null, object);
    }

    @Override
    public void persist(String entityName, Object object, Map copiedAlready) throws HibernateException {
        this.firePersist(copiedAlready, new PersistEvent(entityName, object, this));
    }

    private void firePersist(Map copiedAlready, PersistEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (PersistEventListener listener : this.listeners(EventType.PERSIST)) {
            listener.onPersist(event, copiedAlready);
        }
        this.delayedAfterCompletion();
    }

    private void firePersist(PersistEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.checkNoUnresolvedActionsBeforeOperation();
        for (PersistEventListener listener : this.listeners(EventType.PERSIST)) {
            listener.onPersist(event);
        }
        this.checkNoUnresolvedActionsAfterOperation();
    }

    public void persistOnFlush(String entityName, Object object) throws HibernateException {
        this.firePersistOnFlush(new PersistEvent(entityName, object, this));
    }

    public void persistOnFlush(Object object) throws HibernateException {
        this.persist(null, object);
    }

    @Override
    public void persistOnFlush(String entityName, Object object, Map copiedAlready) throws HibernateException {
        this.firePersistOnFlush(copiedAlready, new PersistEvent(entityName, object, this));
    }

    private void firePersistOnFlush(Map copiedAlready, PersistEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (PersistEventListener listener : this.listeners(EventType.PERSIST_ONFLUSH)) {
            listener.onPersist(event, copiedAlready);
        }
        this.delayedAfterCompletion();
    }

    private void firePersistOnFlush(PersistEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.checkNoUnresolvedActionsBeforeOperation();
        for (PersistEventListener listener : this.listeners(EventType.PERSIST_ONFLUSH)) {
            listener.onPersist(event);
        }
        this.checkNoUnresolvedActionsAfterOperation();
    }

    @Override
    public Object merge(String entityName, Object object) throws HibernateException {
        return this.fireMerge(new MergeEvent(entityName, object, this));
    }

    @Override
    public Object merge(Object object) throws HibernateException {
        return this.merge(null, object);
    }

    @Override
    public void merge(String entityName, Object object, Map copiedAlready) throws HibernateException {
        this.fireMerge(copiedAlready, new MergeEvent(entityName, object, this));
    }

    private Object fireMerge(MergeEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.checkNoUnresolvedActionsBeforeOperation();
        for (MergeEventListener listener : this.listeners(EventType.MERGE)) {
            listener.onMerge(event);
        }
        this.checkNoUnresolvedActionsAfterOperation();
        return event.getResult();
    }

    private void fireMerge(Map copiedAlready, MergeEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (MergeEventListener listener : this.listeners(EventType.MERGE)) {
            listener.onMerge(event, copiedAlready);
        }
        this.delayedAfterCompletion();
    }

    @Override
    public void delete(Object object) throws HibernateException {
        this.fireDelete(new DeleteEvent(object, this));
    }

    @Override
    public void delete(String entityName, Object object) throws HibernateException {
        this.fireDelete(new DeleteEvent(entityName, object, this));
    }

    @Override
    public void delete(String entityName, Object object, boolean isCascadeDeleteEnabled, Set transientEntities) throws HibernateException {
        if (TRACE_ENABLED && this.persistenceContext.isRemovingOrphanBeforeUpates()) {
            this.logRemoveOrphanBeforeUpdates("before continuing", entityName, object);
        }
        this.fireDelete(new DeleteEvent(entityName, object, isCascadeDeleteEnabled, this.persistenceContext.isRemovingOrphanBeforeUpates(), this), transientEntities);
        if (TRACE_ENABLED && this.persistenceContext.isRemovingOrphanBeforeUpates()) {
            this.logRemoveOrphanBeforeUpdates("after continuing", entityName, object);
        }
    }

    @Override
    public void removeOrphanBeforeUpdates(String entityName, Object child) {
        if (TRACE_ENABLED) {
            this.logRemoveOrphanBeforeUpdates("begin", entityName, child);
        }
        this.persistenceContext.beginRemoveOrphanBeforeUpdates();
        try {
            this.fireDelete(new DeleteEvent(entityName, child, false, true, this));
        }
        finally {
            this.persistenceContext.endRemoveOrphanBeforeUpdates();
            if (TRACE_ENABLED) {
                this.logRemoveOrphanBeforeUpdates("end", entityName, child);
            }
        }
    }

    private void logRemoveOrphanBeforeUpdates(String timing, String entityName, Object entity) {
        EntityEntry entityEntry = this.persistenceContext.getEntry(entity);
        LOG.tracef("%s remove orphan before updates: [%s]", timing, entityEntry == null ? entityName : MessageHelper.infoString(entityName, entityEntry.getId()));
    }

    private void fireDelete(DeleteEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (DeleteEventListener listener : this.listeners(EventType.DELETE)) {
            listener.onDelete(event);
        }
        this.delayedAfterCompletion();
    }

    private void fireDelete(DeleteEvent event, Set transientEntities) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (DeleteEventListener listener : this.listeners(EventType.DELETE)) {
            listener.onDelete(event, transientEntities);
        }
        this.delayedAfterCompletion();
    }

    @Override
    public void load(Object object, Serializable id) throws HibernateException {
        LoadEvent event = this.loadEvent;
        this.loadEvent = null;
        if (event == null) {
            event = new LoadEvent(id, object, this);
        } else {
            event.setEntityClassName(null);
            event.setEntityId(id);
            event.setInstanceToLoad(object);
            event.setLockMode(LoadEvent.DEFAULT_LOCK_MODE);
            event.setLockScope(LoadEvent.DEFAULT_LOCK_OPTIONS.getScope());
            event.setLockTimeout(LoadEvent.DEFAULT_LOCK_OPTIONS.getTimeOut());
        }
        this.fireLoad(event, LoadEventListener.RELOAD);
        if (this.loadEvent == null) {
            event.setEntityClassName(null);
            event.setEntityId(null);
            event.setInstanceToLoad(null);
            event.setResult(null);
            this.loadEvent = event;
        }
    }

    @Override
    public <T> T load(Class<T> entityClass, Serializable id) throws HibernateException {
        return ((IdentifierLoadAccessImpl)this.byId((Class)entityClass)).getReference(id);
    }

    @Override
    public Object load(String entityName, Serializable id) throws HibernateException {
        return this.byId(entityName).getReference(id);
    }

    @Override
    public <T> T get(Class<T> entityClass, Serializable id) throws HibernateException {
        return ((IdentifierLoadAccessImpl)this.byId((Class)entityClass)).load(id);
    }

    @Override
    public Object get(String entityName, Serializable id) throws HibernateException {
        return this.byId(entityName).load(id);
    }

    @Override
    public Object immediateLoad(String entityName, Serializable id) throws HibernateException {
        if (LOG.isDebugEnabled()) {
            EntityPersister persister = this.getFactory().getEntityPersister(entityName);
            LOG.debugf("Initializing proxy: %s", MessageHelper.infoString(persister, id, this.getFactory()));
        }
        LoadEvent event = this.loadEvent;
        this.loadEvent = null;
        event = this.recycleEventInstance(event, id, entityName);
        this.fireLoad(event, LoadEventListener.IMMEDIATE_LOAD);
        Object result = event.getResult();
        if (this.loadEvent == null) {
            event.setEntityClassName(null);
            event.setEntityId(null);
            event.setInstanceToLoad(null);
            event.setResult(null);
            this.loadEvent = event;
        }
        return result;
    }

    @Override
    public Object internalLoad(String entityName, Serializable id, boolean eager, boolean nullable) throws HibernateException {
        LoadEventListener.LoadType type = nullable ? LoadEventListener.INTERNAL_LOAD_NULLABLE : (eager ? LoadEventListener.INTERNAL_LOAD_EAGER : LoadEventListener.INTERNAL_LOAD_LAZY);
        LoadEvent event = this.loadEvent;
        this.loadEvent = null;
        event = this.recycleEventInstance(event, id, entityName);
        this.fireLoad(event, type);
        Object result = event.getResult();
        if (!nullable) {
            UnresolvableObjectException.throwIfNull(result, id, entityName);
        }
        if (this.loadEvent == null) {
            event.setEntityClassName(null);
            event.setEntityId(null);
            event.setInstanceToLoad(null);
            event.setResult(null);
            this.loadEvent = event;
        }
        return result;
    }

    private LoadEvent recycleEventInstance(LoadEvent event, Serializable id, String entityName) {
        if (event == null) {
            return new LoadEvent(id, entityName, true, (EventSource)this);
        }
        event.setEntityClassName(entityName);
        event.setEntityId(id);
        event.setInstanceToLoad(null);
        event.setLockMode(LoadEvent.DEFAULT_LOCK_MODE);
        event.setLockScope(LoadEvent.DEFAULT_LOCK_OPTIONS.getScope());
        event.setLockTimeout(LoadEvent.DEFAULT_LOCK_OPTIONS.getTimeOut());
        return event;
    }

    @Override
    public <T> T load(Class<T> entityClass, Serializable id, LockMode lockMode) throws HibernateException {
        return ((IdentifierLoadAccessImpl)((IdentifierLoadAccessImpl)this.byId((Class)entityClass)).with(new LockOptions(lockMode))).getReference(id);
    }

    @Override
    public <T> T load(Class<T> entityClass, Serializable id, LockOptions lockOptions) throws HibernateException {
        return ((IdentifierLoadAccessImpl)((IdentifierLoadAccessImpl)this.byId((Class)entityClass)).with(lockOptions)).getReference(id);
    }

    @Override
    public Object load(String entityName, Serializable id, LockMode lockMode) throws HibernateException {
        return ((IdentifierLoadAccessImpl)this.byId(entityName).with(new LockOptions(lockMode))).getReference(id);
    }

    @Override
    public Object load(String entityName, Serializable id, LockOptions lockOptions) throws HibernateException {
        return ((IdentifierLoadAccessImpl)this.byId(entityName).with(lockOptions)).getReference(id);
    }

    @Override
    public <T> T get(Class<T> entityClass, Serializable id, LockMode lockMode) throws HibernateException {
        return ((IdentifierLoadAccessImpl)((IdentifierLoadAccessImpl)this.byId((Class)entityClass)).with(new LockOptions(lockMode))).load(id);
    }

    @Override
    public <T> T get(Class<T> entityClass, Serializable id, LockOptions lockOptions) throws HibernateException {
        return ((IdentifierLoadAccessImpl)((IdentifierLoadAccessImpl)this.byId((Class)entityClass)).with(lockOptions)).load(id);
    }

    @Override
    public Object get(String entityName, Serializable id, LockMode lockMode) throws HibernateException {
        return ((IdentifierLoadAccessImpl)this.byId(entityName).with(new LockOptions(lockMode))).load(id);
    }

    @Override
    public Object get(String entityName, Serializable id, LockOptions lockOptions) throws HibernateException {
        return ((IdentifierLoadAccessImpl)this.byId(entityName).with(lockOptions)).load(id);
    }

    @Override
    public IdentifierLoadAccessImpl byId(String entityName) {
        return new IdentifierLoadAccessImpl(entityName);
    }

    public <T> IdentifierLoadAccessImpl<T> byId(Class<T> entityClass) {
        return new IdentifierLoadAccessImpl(entityClass);
    }

    @Override
    public NaturalIdLoadAccess byNaturalId(String entityName) {
        return new NaturalIdLoadAccessImpl(entityName);
    }

    @Override
    public <T> NaturalIdLoadAccess<T> byNaturalId(Class<T> entityClass) {
        return new NaturalIdLoadAccessImpl(entityClass);
    }

    @Override
    public SimpleNaturalIdLoadAccess bySimpleNaturalId(String entityName) {
        return new SimpleNaturalIdLoadAccessImpl(entityName);
    }

    @Override
    public <T> SimpleNaturalIdLoadAccess<T> bySimpleNaturalId(Class<T> entityClass) {
        return new SimpleNaturalIdLoadAccessImpl(entityClass);
    }

    private void fireLoad(LoadEvent event, LoadEventListener.LoadType loadType) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (LoadEventListener listener : this.listeners(EventType.LOAD)) {
            listener.onLoad(event, loadType);
        }
        this.delayedAfterCompletion();
    }

    private void fireResolveNaturalId(ResolveNaturalIdEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (ResolveNaturalIdEventListener listener : this.listeners(EventType.RESOLVE_NATURAL_ID)) {
            listener.onResolveNaturalId(event);
        }
        this.delayedAfterCompletion();
    }

    @Override
    public void refresh(Object object) throws HibernateException {
        this.refresh(null, object);
    }

    @Override
    public void refresh(String entityName, Object object) throws HibernateException {
        this.fireRefresh(new RefreshEvent(entityName, object, (EventSource)this));
    }

    @Override
    public void refresh(Object object, LockMode lockMode) throws HibernateException {
        this.fireRefresh(new RefreshEvent(object, lockMode, (EventSource)this));
    }

    @Override
    public void refresh(Object object, LockOptions lockOptions) throws HibernateException {
        this.refresh(null, object, lockOptions);
    }

    @Override
    public void refresh(String entityName, Object object, LockOptions lockOptions) throws HibernateException {
        this.fireRefresh(new RefreshEvent(entityName, object, lockOptions, this));
    }

    @Override
    public void refresh(String entityName, Object object, Map refreshedAlready) throws HibernateException {
        this.fireRefresh(refreshedAlready, new RefreshEvent(entityName, object, (EventSource)this));
    }

    private void fireRefresh(RefreshEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (RefreshEventListener listener : this.listeners(EventType.REFRESH)) {
            listener.onRefresh(event);
        }
        this.delayedAfterCompletion();
    }

    private void fireRefresh(Map refreshedAlready, RefreshEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (RefreshEventListener listener : this.listeners(EventType.REFRESH)) {
            listener.onRefresh(event, refreshedAlready);
        }
        this.delayedAfterCompletion();
    }

    @Override
    public void replicate(Object obj, ReplicationMode replicationMode) throws HibernateException {
        this.fireReplicate(new ReplicateEvent(obj, replicationMode, this));
    }

    @Override
    public void replicate(String entityName, Object obj, ReplicationMode replicationMode) throws HibernateException {
        this.fireReplicate(new ReplicateEvent(entityName, obj, replicationMode, this));
    }

    private void fireReplicate(ReplicateEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (ReplicateEventListener listener : this.listeners(EventType.REPLICATE)) {
            listener.onReplicate(event);
        }
        this.delayedAfterCompletion();
    }

    @Override
    public void evict(Object object) throws HibernateException {
        this.fireEvict(new EvictEvent(object, this));
    }

    private void fireEvict(EvictEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (EvictEventListener listener : this.listeners(EventType.EVICT)) {
            listener.onEvict(event);
        }
        this.delayedAfterCompletion();
    }

    protected boolean autoFlushIfRequired(Set querySpaces) throws HibernateException {
        this.errorIfClosed();
        if (!this.isTransactionInProgress()) {
            return false;
        }
        AutoFlushEvent event = new AutoFlushEvent(querySpaces, this);
        this.listeners(EventType.AUTO_FLUSH);
        for (AutoFlushEventListener listener : this.listeners(EventType.AUTO_FLUSH)) {
            listener.onAutoFlush(event);
        }
        return event.isFlushRequired();
    }

    @Override
    public boolean isDirty() throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        LOG.debug("Checking session dirtiness");
        if (this.actionQueue.areInsertionsOrDeletionsQueued()) {
            LOG.debug("Session dirty (scheduled updates and insertions)");
            return true;
        }
        DirtyCheckEvent event = new DirtyCheckEvent(this);
        for (DirtyCheckEventListener listener : this.listeners(EventType.DIRTY_CHECK)) {
            listener.onDirtyCheck(event);
        }
        this.delayedAfterCompletion();
        return event.isDirty();
    }

    @Override
    public void flush() throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (this.persistenceContext.getCascadeLevel() > 0) {
            throw new HibernateException("Flush during cascade is dangerous");
        }
        FlushEvent flushEvent = new FlushEvent(this);
        for (FlushEventListener listener : this.listeners(EventType.FLUSH)) {
            listener.onFlush(flushEvent);
        }
        this.delayedAfterCompletion();
    }

    @Override
    public void forceFlush(EntityEntry entityEntry) throws HibernateException {
        this.errorIfClosed();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Flushing to force deletion of re-saved object: %s", MessageHelper.infoString(entityEntry.getPersister(), entityEntry.getId(), this.getFactory()));
        }
        if (this.persistenceContext.getCascadeLevel() > 0) {
            throw new ObjectDeletedException("deleted object would be re-saved by cascade (remove deleted object from associations)", entityEntry.getId(), entityEntry.getPersister().getEntityName());
        }
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List list(String query, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        queryParameters.validateParameters();
        HQLQueryPlan plan = queryParameters.getQueryPlan();
        if (plan == null) {
            plan = this.getHQLQueryPlan(query, false);
        }
        this.autoFlushIfRequired(plan.getQuerySpaces());
        List results = Collections.EMPTY_LIST;
        boolean success = false;
        ++this.dontFlushFromFind;
        try {
            results = plan.performList(queryParameters, this);
            success = true;
        }
        finally {
            --this.dontFlushFromFind;
            this.afterOperation(success);
            this.delayedAfterCompletion();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String query, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        queryParameters.validateParameters();
        HQLQueryPlan plan = this.getHQLQueryPlan(query, false);
        this.autoFlushIfRequired(plan.getQuerySpaces());
        boolean success = false;
        int result = 0;
        try {
            result = plan.performExecuteUpdate(queryParameters, this);
            success = true;
        }
        finally {
            this.afterOperation(success);
            this.delayedAfterCompletion();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeNativeUpdate(NativeSQLQuerySpecification nativeQuerySpecification, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        queryParameters.validateParameters();
        NativeSQLQueryPlan plan = this.getNativeSQLQueryPlan(nativeQuerySpecification);
        this.autoFlushIfRequired(plan.getCustomQuery().getQuerySpaces());
        boolean success = false;
        int result = 0;
        try {
            result = plan.performExecuteUpdate(queryParameters, this);
            success = true;
        }
        finally {
            this.afterOperation(success);
            this.delayedAfterCompletion();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator iterate(String query, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        queryParameters.validateParameters();
        HQLQueryPlan plan = queryParameters.getQueryPlan();
        if (plan == null) {
            plan = this.getHQLQueryPlan(query, true);
        }
        this.autoFlushIfRequired(plan.getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            Iterator iterator = plan.performIterate(queryParameters, this);
            return iterator;
        }
        finally {
            this.delayedAfterCompletion();
            --this.dontFlushFromFind;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScrollableResults scroll(String query, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        HQLQueryPlan plan = queryParameters.getQueryPlan();
        if (plan == null) {
            plan = this.getHQLQueryPlan(query, false);
        }
        this.autoFlushIfRequired(plan.getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            ScrollableResults scrollableResults = plan.performScroll(queryParameters, this);
            return scrollableResults;
        }
        finally {
            this.delayedAfterCompletion();
            --this.dontFlushFromFind;
        }
    }

    @Override
    public Query createFilter(Object collection, String queryString) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        CollectionFilterImpl filter = new CollectionFilterImpl(queryString, collection, (SessionImplementor)this, this.getFilterQueryPlan(collection, queryString, null, false).getParameterMetadata());
        filter.setComment(queryString);
        this.delayedAfterCompletion();
        return filter;
    }

    @Override
    public Query getNamedQuery(String queryName) throws MappingException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        Query query = super.getNamedQuery(queryName);
        this.delayedAfterCompletion();
        return query;
    }

    @Override
    public Object instantiate(String entityName, Serializable id) throws HibernateException {
        return this.instantiate(this.factory.getEntityPersister(entityName), id);
    }

    @Override
    public Object instantiate(EntityPersister persister, Serializable id) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        Object result = this.interceptor.instantiate(persister.getEntityName(), persister.getEntityMetamodel().getEntityMode(), id);
        if (result == null) {
            result = persister.instantiate(id, this);
        }
        this.delayedAfterCompletion();
        return result;
    }

    @Override
    public void setFlushMode(FlushMode flushMode) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        LOG.tracev("Setting flush mode to: {0}", (Object)flushMode);
        this.flushMode = flushMode;
    }

    @Override
    public FlushMode getFlushMode() {
        this.checkTransactionSynchStatus();
        return this.flushMode;
    }

    @Override
    public CacheMode getCacheMode() {
        this.checkTransactionSynchStatus();
        return this.cacheMode;
    }

    @Override
    public void setCacheMode(CacheMode cacheMode) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        LOG.tracev("Setting cache mode to: {0}", (Object)cacheMode);
        this.cacheMode = cacheMode;
    }

    @Override
    public Transaction beginTransaction() throws HibernateException {
        this.errorIfClosed();
        Transaction result = this.getTransaction();
        if (result.getStatus() != TransactionStatus.ACTIVE) {
            this.timestamp = this.factory.getSettings().getRegionFactory().nextTimestamp();
        }
        result.begin();
        return result;
    }

    @Override
    public EntityPersister getEntityPersister(String entityName, Object object) {
        this.errorIfClosed();
        if (entityName == null) {
            return this.factory.getEntityPersister(this.guessEntityName(object));
        }
        try {
            return this.factory.getEntityPersister(entityName).getSubclassEntityPersister(object, this.getFactory());
        }
        catch (HibernateException e) {
            try {
                return this.getEntityPersister(null, object);
            }
            catch (HibernateException e2) {
                throw e;
            }
        }
    }

    @Override
    public Serializable getIdentifier(Object object) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (object instanceof HibernateProxy) {
            LazyInitializer li = ((HibernateProxy)object).getHibernateLazyInitializer();
            if (li.getSession() != this) {
                throw new TransientObjectException("The proxy was not associated with this session");
            }
            return li.getIdentifier();
        }
        EntityEntry entry = this.persistenceContext.getEntry(object);
        if (entry == null) {
            throw new TransientObjectException("The instance was not associated with this session");
        }
        return entry.getId();
    }

    @Override
    public Serializable getContextEntityIdentifier(Object object) {
        this.errorIfClosed();
        if (object instanceof HibernateProxy) {
            return this.getProxyIdentifier(object);
        }
        EntityEntry entry = this.persistenceContext.getEntry(object);
        return entry != null ? entry.getId() : null;
    }

    private Serializable getProxyIdentifier(Object proxy) {
        return ((HibernateProxy)proxy).getHibernateLazyInitializer().getIdentifier();
    }

    private FilterQueryPlan getFilterQueryPlan(Object collection, String filter, QueryParameters parameters, boolean shallow) throws HibernateException {
        if (collection == null) {
            throw new NullPointerException("null collection passed to filter");
        }
        CollectionEntry entry = this.persistenceContext.getCollectionEntryOrNull(collection);
        CollectionPersister roleBeforeFlush = entry == null ? null : entry.getLoadedPersister();
        FilterQueryPlan plan = null;
        if (roleBeforeFlush == null) {
            CollectionPersister roleAfterFlush;
            this.flush();
            entry = this.persistenceContext.getCollectionEntryOrNull(collection);
            CollectionPersister collectionPersister = roleAfterFlush = entry == null ? null : entry.getLoadedPersister();
            if (roleAfterFlush == null) {
                throw new QueryException("The collection was unreferenced");
            }
            plan = this.factory.getQueryPlanCache().getFilterQueryPlan(filter, roleAfterFlush.getRole(), shallow, this.getLoadQueryInfluencers().getEnabledFilters());
        } else {
            plan = this.factory.getQueryPlanCache().getFilterQueryPlan(filter, roleBeforeFlush.getRole(), shallow, this.getLoadQueryInfluencers().getEnabledFilters());
            if (this.autoFlushIfRequired(plan.getQuerySpaces())) {
                CollectionPersister roleAfterFlush;
                entry = this.persistenceContext.getCollectionEntryOrNull(collection);
                CollectionPersister collectionPersister = roleAfterFlush = entry == null ? null : entry.getLoadedPersister();
                if (roleBeforeFlush != roleAfterFlush) {
                    if (roleAfterFlush == null) {
                        throw new QueryException("The collection was dereferenced");
                    }
                    plan = this.factory.getQueryPlanCache().getFilterQueryPlan(filter, roleAfterFlush.getRole(), shallow, this.getLoadQueryInfluencers().getEnabledFilters());
                }
            }
        }
        if (parameters != null) {
            parameters.getPositionalParameterValues()[0] = entry.getLoadedKey();
            parameters.getPositionalParameterTypes()[0] = entry.getLoadedPersister().getKeyType();
        }
        return plan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List listFilter(Object collection, String filter, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        FilterQueryPlan plan = this.getFilterQueryPlan(collection, filter, queryParameters, false);
        List results = Collections.EMPTY_LIST;
        boolean success = false;
        ++this.dontFlushFromFind;
        try {
            results = plan.performList(queryParameters, this);
            success = true;
        }
        finally {
            --this.dontFlushFromFind;
            this.afterOperation(success);
            this.delayedAfterCompletion();
        }
        return results;
    }

    @Override
    public Iterator iterateFilter(Object collection, String filter, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        FilterQueryPlan plan = this.getFilterQueryPlan(collection, filter, queryParameters, true);
        Iterator itr = plan.performIterate(queryParameters, this);
        this.delayedAfterCompletion();
        return itr;
    }

    @Override
    public Criteria createCriteria(Class persistentClass, String alias) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new CriteriaImpl(persistentClass.getName(), alias, this);
    }

    @Override
    public Criteria createCriteria(String entityName, String alias) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new CriteriaImpl(entityName, alias, this);
    }

    @Override
    public Criteria createCriteria(Class persistentClass) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new CriteriaImpl(persistentClass.getName(), this);
    }

    @Override
    public Criteria createCriteria(String entityName) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new CriteriaImpl(entityName, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScrollableResults scroll(Criteria criteria, ScrollMode scrollMode) {
        CriteriaImpl criteriaImpl = (CriteriaImpl)criteria;
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        String entityName = criteriaImpl.getEntityOrClassName();
        CriteriaLoader loader = new CriteriaLoader(this.getOuterJoinLoadable(entityName), this.factory, criteriaImpl, entityName, this.getLoadQueryInfluencers());
        this.autoFlushIfRequired(loader.getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            ScrollableResults scrollableResults = loader.scroll(this, scrollMode);
            return scrollableResults;
        }
        finally {
            this.delayedAfterCompletion();
            --this.dontFlushFromFind;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List list(Criteria criteria) throws HibernateException {
        CriteriaImpl criteriaImpl = (CriteriaImpl)criteria;
        NaturalIdLoadAccess naturalIdLoadAccess = this.tryNaturalIdLoadAccess(criteriaImpl);
        if (naturalIdLoadAccess != null) {
            return Arrays.asList(naturalIdLoadAccess.load());
        }
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        String[] implementors = this.factory.getImplementors(criteriaImpl.getEntityOrClassName());
        int size = implementors.length;
        CriteriaLoader[] loaders = new CriteriaLoader[size];
        HashSet spaces = new HashSet();
        for (int i = 0; i < size; ++i) {
            loaders[i] = new CriteriaLoader(this.getOuterJoinLoadable(implementors[i]), this.factory, criteriaImpl, implementors[i], this.getLoadQueryInfluencers());
            spaces.addAll(loaders[i].getQuerySpaces());
        }
        this.autoFlushIfRequired(spaces);
        List results = Collections.EMPTY_LIST;
        ++this.dontFlushFromFind;
        boolean success = false;
        try {
            for (int i = 0; i < size; ++i) {
                List currentResults = loaders[i].list(this);
                currentResults.addAll(results);
                results = currentResults;
            }
            success = true;
        }
        finally {
            --this.dontFlushFromFind;
            this.afterOperation(success);
            this.delayedAfterCompletion();
        }
        return results;
    }

    private NaturalIdLoadAccess tryNaturalIdLoadAccess(CriteriaImpl criteria) {
        if (!criteria.isLookupByNaturalKey()) {
            return null;
        }
        String entityName = criteria.getEntityOrClassName();
        EntityPersister entityPersister = this.factory.getEntityPersister(entityName);
        if (!entityPersister.hasNaturalIdentifier()) {
            return null;
        }
        CriteriaImpl.CriterionEntry criterionEntry = criteria.iterateExpressionEntries().next();
        NaturalIdentifier naturalIdentifier = (NaturalIdentifier)criterionEntry.getCriterion();
        Map<String, Object> naturalIdValues = naturalIdentifier.getNaturalIdValues();
        int[] naturalIdentifierProperties = entityPersister.getNaturalIdentifierProperties();
        if (naturalIdentifierProperties.length != naturalIdValues.size()) {
            return null;
        }
        String[] propertyNames = entityPersister.getPropertyNames();
        NaturalIdLoadAccess naturalIdLoader = this.byNaturalId(entityName);
        for (int naturalIdentifierProperty : naturalIdentifierProperties) {
            String naturalIdProperty = propertyNames[naturalIdentifierProperty];
            Object naturalIdValue = naturalIdValues.get(naturalIdProperty);
            if (naturalIdValue == null) {
                return null;
            }
            naturalIdLoader.using(naturalIdProperty, naturalIdValue);
        }
        LOG.warn("Session.byNaturalId(" + entityName + ") should be used for naturalId queries instead of Restrictions.naturalId() from a Criteria");
        return naturalIdLoader;
    }

    private OuterJoinLoadable getOuterJoinLoadable(String entityName) throws MappingException {
        EntityPersister persister = this.factory.getEntityPersister(entityName);
        if (!(persister instanceof OuterJoinLoadable)) {
            throw new MappingException("class persister is not OuterJoinLoadable: " + entityName);
        }
        return (OuterJoinLoadable)persister;
    }

    @Override
    public boolean contains(Object object) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (object instanceof HibernateProxy) {
            LazyInitializer li = ((HibernateProxy)object).getHibernateLazyInitializer();
            if (li.isUninitialized()) {
                return li.getSession() == this;
            }
            object = li.getImplementation();
        }
        EntityEntry entry = this.persistenceContext.getEntry(object);
        this.delayedAfterCompletion();
        return entry != null && entry.getStatus() != Status.DELETED && entry.getStatus() != Status.GONE;
    }

    @Override
    public Query createQuery(String queryString) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return super.createQuery(queryString);
    }

    @Override
    public SQLQuery createSQLQuery(String sql) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return super.createSQLQuery(sql);
    }

    @Override
    public ProcedureCall createStoredProcedureCall(String procedureName) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return super.createStoredProcedureCall(procedureName);
    }

    @Override
    public ProcedureCall createStoredProcedureCall(String procedureName, String ... resultSetMappings) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return super.createStoredProcedureCall(procedureName, resultSetMappings);
    }

    @Override
    public ProcedureCall createStoredProcedureCall(String procedureName, Class ... resultClasses) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return super.createStoredProcedureCall(procedureName, resultClasses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScrollableResults scrollCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Scroll SQL query: {0}", customQuery.getSQL());
        }
        CustomLoader loader = new CustomLoader(customQuery, this.getFactory());
        this.autoFlushIfRequired(loader.getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            ScrollableResults scrollableResults = loader.scroll(queryParameters, this);
            return scrollableResults;
        }
        finally {
            this.delayedAfterCompletion();
            --this.dontFlushFromFind;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List listCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (LOG.isTraceEnabled()) {
            LOG.tracev("SQL query: {0}", customQuery.getSQL());
        }
        CustomLoader loader = new CustomLoader(customQuery, this.getFactory());
        this.autoFlushIfRequired(loader.getQuerySpaces());
        ++this.dontFlushFromFind;
        boolean success = false;
        try {
            List results = loader.list(this, queryParameters);
            success = true;
            List list = results;
            return list;
        }
        finally {
            --this.dontFlushFromFind;
            this.delayedAfterCompletion();
            this.afterOperation(success);
        }
    }

    @Override
    public SessionFactoryImplementor getSessionFactory() {
        this.checkTransactionSynchStatus();
        return this.factory;
    }

    @Override
    public void initializeCollection(PersistentCollection collection, boolean writing) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        InitializeCollectionEvent event = new InitializeCollectionEvent(collection, this);
        for (InitializeCollectionEventListener listener : this.listeners(EventType.INIT_COLLECTION)) {
            listener.onInitializeCollection(event);
        }
        this.delayedAfterCompletion();
    }

    @Override
    public String bestGuessEntityName(Object object) {
        EntityEntry entry;
        if (object instanceof HibernateProxy) {
            LazyInitializer initializer = ((HibernateProxy)object).getHibernateLazyInitializer();
            if (initializer.isUninitialized()) {
                return initializer.getEntityName();
            }
            object = initializer.getImplementation();
        }
        if ((entry = this.persistenceContext.getEntry(object)) == null) {
            return this.guessEntityName(object);
        }
        return entry.getPersister().getEntityName();
    }

    @Override
    public String getEntityName(Object object) {
        EntityEntry entry;
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (object instanceof HibernateProxy) {
            if (!this.persistenceContext.containsProxy(object)) {
                throw new TransientObjectException("proxy was not associated with the session");
            }
            object = ((HibernateProxy)object).getHibernateLazyInitializer().getImplementation();
        }
        if ((entry = this.persistenceContext.getEntry(object)) == null) {
            this.throwTransientObjectException(object);
        }
        return entry.getPersister().getEntityName();
    }

    private void throwTransientObjectException(Object object) throws HibernateException {
        throw new TransientObjectException("object references an unsaved transient instance - save the transient instance before flushing: " + this.guessEntityName(object));
    }

    @Override
    public String guessEntityName(Object object) throws HibernateException {
        this.errorIfClosed();
        return this.entityNameResolver.resolveEntityName(object);
    }

    @Override
    public void cancelQuery() throws HibernateException {
        this.errorIfClosed();
        this.jdbcCoordinator.cancelLastQuery();
    }

    @Override
    public Interceptor getInterceptor() {
        this.checkTransactionSynchStatus();
        return this.interceptor;
    }

    @Override
    public int getDontFlushFromFind() {
        return this.dontFlushFromFind;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(500).append("SessionImpl(");
        if (!this.isClosed()) {
            buf.append(this.persistenceContext).append(";").append(this.actionQueue);
        } else {
            buf.append("<closed>");
        }
        return buf.append(')').toString();
    }

    @Override
    public ActionQueue getActionQueue() {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.actionQueue;
    }

    @Override
    public PersistenceContext getPersistenceContext() {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.persistenceContext;
    }

    @Override
    public SessionStatistics getStatistics() {
        this.checkTransactionSynchStatus();
        return new SessionStatisticsImpl(this);
    }

    @Override
    public boolean isEventSource() {
        this.checkTransactionSynchStatus();
        return true;
    }

    @Override
    public boolean isDefaultReadOnly() {
        return this.persistenceContext.isDefaultReadOnly();
    }

    @Override
    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this.persistenceContext.setDefaultReadOnly(defaultReadOnly);
    }

    @Override
    public boolean isReadOnly(Object entityOrProxy) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.persistenceContext.isReadOnly(entityOrProxy);
    }

    @Override
    public void setReadOnly(Object entity, boolean readOnly) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.persistenceContext.setReadOnly(entity, readOnly);
    }

    @Override
    public void doWork(final Work work) throws HibernateException {
        WorkExecutorVisitable<Void> realWork = new WorkExecutorVisitable<Void>(){

            @Override
            public Void accept(WorkExecutor<Void> workExecutor, Connection connection) throws SQLException {
                workExecutor.executeWork(work, connection);
                return null;
            }
        };
        this.doWork(realWork);
    }

    @Override
    public <T> T doReturningWork(final ReturningWork<T> work) throws HibernateException {
        WorkExecutorVisitable realWork = new WorkExecutorVisitable<T>(){

            @Override
            public T accept(WorkExecutor<T> workExecutor, Connection connection) throws SQLException {
                return workExecutor.executeReturningWork(work, connection);
            }
        };
        return this.doWork(realWork);
    }

    private <T> T doWork(WorkExecutorVisitable<T> work) throws HibernateException {
        return this.jdbcCoordinator.coordinateWork(work);
    }

    @Override
    public void afterScrollOperation() {
    }

    @Override
    public TransactionCoordinator getTransactionCoordinator() {
        this.errorIfClosed();
        return this.transactionCoordinator;
    }

    @Override
    public JdbcCoordinator getJdbcCoordinator() {
        return this.jdbcCoordinator;
    }

    @Override
    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return this.loadQueryInfluencers;
    }

    @Override
    public Filter getEnabledFilter(String filterName) {
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.getEnabledFilter(filterName);
    }

    @Override
    public Filter enableFilter(String filterName) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.enableFilter(filterName);
    }

    @Override
    public void disableFilter(String filterName) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.loadQueryInfluencers.disableFilter(filterName);
    }

    @Override
    public boolean isFetchProfileEnabled(String name) throws UnknownProfileException {
        return this.loadQueryInfluencers.isFetchProfileEnabled(name);
    }

    @Override
    public void enableFetchProfile(String name) throws UnknownProfileException {
        this.loadQueryInfluencers.enableFetchProfile(name);
    }

    @Override
    public void disableFetchProfile(String name) throws UnknownProfileException {
        this.loadQueryInfluencers.disableFetchProfile(name);
    }

    private void checkTransactionSynchStatus() {
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
    }

    private void pulseTransactionCoordinator() {
        if (!this.isClosed()) {
            this.transactionCoordinator.pulse();
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException, SQLException {
        LOG.trace("Deserializing session");
        ois.defaultReadObject();
        this.entityNameResolver = new CoordinatingEntityNameResolver();
        this.connectionReleaseMode = ConnectionReleaseMode.parse((String)ois.readObject());
        this.autoClear = ois.readBoolean();
        this.autoJoinTransactions = ois.readBoolean();
        this.flushMode = FlushMode.valueOf((String)ois.readObject());
        this.cacheMode = CacheMode.valueOf((String)ois.readObject());
        this.flushBeforeCompletionEnabled = ois.readBoolean();
        this.autoCloseSessionEnabled = ois.readBoolean();
        this.interceptor = (Interceptor)ois.readObject();
        this.factory = SessionFactoryImpl.deserialize(ois);
        this.jdbcSessionContext = new AbstractSessionImpl.JdbcSessionContextImpl(this.factory, this.statementInspector);
        this.sessionOwner = (SessionOwner)ois.readObject();
        this.initializeFromSessionOwner(this.sessionOwner);
        this.jdbcCoordinator = JdbcCoordinatorImpl.deserialize(ois, this);
        this.transactionCoordinator = this.getTransactionCoordinatorBuilder().buildTransactionCoordinator(this.jdbcCoordinator, this);
        this.persistenceContext = StatefulPersistenceContext.deserialize(ois, this);
        this.actionQueue = ActionQueue.deserialize(ois, this);
        this.loadQueryInfluencers = (LoadQueryInfluencers)ois.readObject();
        for (String filterName : this.loadQueryInfluencers.getEnabledFilterNames()) {
            ((FilterImpl)this.loadQueryInfluencers.getEnabledFilter(filterName)).afterDeserialize(this.factory);
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (!this.jdbcCoordinator.isReadyForSerialization()) {
            throw new IllegalStateException("Cannot serialize a session while connected");
        }
        LOG.trace("Serializing session");
        oos.defaultWriteObject();
        oos.writeObject(this.connectionReleaseMode.toString());
        oos.writeBoolean(this.autoClear);
        oos.writeBoolean(this.autoJoinTransactions);
        oos.writeObject(this.flushMode.toString());
        oos.writeObject(this.cacheMode.name());
        oos.writeBoolean(this.flushBeforeCompletionEnabled);
        oos.writeBoolean(this.autoCloseSessionEnabled);
        oos.writeObject(this.interceptor);
        this.factory.serialize(oos);
        oos.writeObject(this.sessionOwner);
        this.jdbcCoordinator.serialize(oos);
        this.persistenceContext.serialize(oos);
        this.actionQueue.serialize(oos);
        oos.writeObject(this.loadQueryInfluencers);
    }

    @Override
    public TypeHelper getTypeHelper() {
        return this.getSessionFactory().getTypeHelper();
    }

    @Override
    public LobHelper getLobHelper() {
        if (this.lobHelper == null) {
            this.lobHelper = new LobHelperImpl(this);
        }
        return this.lobHelper;
    }

    @Override
    public JdbcSessionContext getJdbcSessionContext() {
        return this.jdbcSessionContext;
    }

    @Override
    public void beforeTransactionCompletion() {
        LOG.tracef("SessionImpl#beforeTransactionCompletion()", new Object[0]);
        this.flushBeforeTransactionCompletion();
        this.actionQueue.beforeTransactionCompletion();
        try {
            this.interceptor.beforeTransactionCompletion(this.currentHibernateTransaction);
        }
        catch (Throwable t) {
            LOG.exceptionInBeforeTransactionCompletionInterceptor(t);
        }
    }

    @Override
    public void afterTransactionCompletion(boolean successful, boolean delayed) {
        LOG.tracef("SessionImpl#afterTransactionCompletion(successful=%s, delayed=%s)", successful, delayed);
        this.afterCompletionAction.doAction(successful);
        this.persistenceContext.afterTransactionCompletion();
        this.actionQueue.afterTransactionCompletion(successful);
        this.getEventListenerManager().transactionCompletion(successful);
        if (this.factory.getStatistics().isStatisticsEnabled()) {
            this.factory.getStatisticsImplementor().endTransaction(successful);
        }
        try {
            this.interceptor.afterTransactionCompletion(this.currentHibernateTransaction);
        }
        catch (Throwable t) {
            LOG.exceptionInAfterTransactionCompletionInterceptor(t);
        }
        if (!delayed && this.shouldAutoClose() && !this.isClosed()) {
            this.managedClose();
        }
        if (this.autoClear) {
            this.internalClear();
        }
    }

    private EntityPersister locateEntityPersister(Class entityClass) {
        return this.factory.locateEntityPersister(entityClass);
    }

    private EntityPersister locateEntityPersister(String entityName) {
        return this.factory.locateEntityPersister(entityName);
    }

    @Override
    public void afterTransactionBegin() {
        this.errorIfClosed();
        this.interceptor.afterTransactionBegin(this.currentHibernateTransaction);
    }

    @Override
    public void flushBeforeTransactionCompletion() {
        boolean flush = this.isTransactionFlushable() && this.managedFlushChecker.shouldDoManagedFlush(this);
        try {
            if (flush) {
                this.managedFlush();
            }
        }
        catch (HibernateException he) {
            throw this.exceptionMapper.mapManagedFlushFailure("error during managed flush", he);
        }
        catch (RuntimeException re) {
            throw this.exceptionMapper.mapManagedFlushFailure("error during managed flush", re);
        }
    }

    private boolean isTransactionFlushable() {
        if (this.currentHibernateTransaction == null) {
            return true;
        }
        TransactionStatus status = this.currentHibernateTransaction.getStatus();
        return status == TransactionStatus.ACTIVE || status == TransactionStatus.COMMITTING;
    }

    private JtaPlatform getJtaPlatform() {
        return this.factory.getServiceRegistry().getService(JtaPlatform.class);
    }

    private class SimpleNaturalIdLoadAccessImpl<T>
    extends BaseNaturalIdLoadAccessImpl<T>
    implements SimpleNaturalIdLoadAccess<T> {
        private final String naturalIdAttributeName;

        private SimpleNaturalIdLoadAccessImpl(EntityPersister entityPersister) {
            super(entityPersister);
            if (entityPersister.getNaturalIdentifierProperties().length != 1) {
                throw new HibernateException(String.format("Entity [%s] did not define a simple natural id", entityPersister.getEntityName()));
            }
            int naturalIdAttributePosition = entityPersister.getNaturalIdentifierProperties()[0];
            this.naturalIdAttributeName = entityPersister.getPropertyNames()[naturalIdAttributePosition];
        }

        private SimpleNaturalIdLoadAccessImpl(String entityName) {
            this(sessionImpl.locateEntityPersister(entityName));
        }

        private SimpleNaturalIdLoadAccessImpl(Class entityClass) {
            this(sessionImpl.locateEntityPersister(entityClass));
        }

        @Override
        public final SimpleNaturalIdLoadAccessImpl<T> with(LockOptions lockOptions) {
            return (SimpleNaturalIdLoadAccessImpl)super.with(lockOptions);
        }

        private Map<String, Object> getNaturalIdParameters(Object naturalIdValue) {
            return Collections.singletonMap(this.naturalIdAttributeName, naturalIdValue);
        }

        @Override
        public SimpleNaturalIdLoadAccessImpl<T> setSynchronizationEnabled(boolean synchronizationEnabled) {
            super.synchronizationEnabled(synchronizationEnabled);
            return this;
        }

        @Override
        public T getReference(Object naturalIdValue) {
            Serializable entityId = this.resolveNaturalId(this.getNaturalIdParameters(naturalIdValue));
            if (entityId == null) {
                return null;
            }
            return this.getIdentifierLoadAccess().getReference(entityId);
        }

        @Override
        public T load(Object naturalIdValue) {
            Serializable entityId = this.resolveNaturalId(this.getNaturalIdParameters(naturalIdValue));
            if (entityId == null) {
                return null;
            }
            try {
                return this.getIdentifierLoadAccess().load(entityId);
            }
            catch (EntityNotFoundException entityNotFoundException) {
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            return null;
        }
    }

    private class NaturalIdLoadAccessImpl<T>
    extends BaseNaturalIdLoadAccessImpl<T>
    implements NaturalIdLoadAccess<T> {
        private final Map<String, Object> naturalIdParameters;

        private NaturalIdLoadAccessImpl(EntityPersister entityPersister) {
            super(entityPersister);
            this.naturalIdParameters = new LinkedHashMap<String, Object>();
        }

        private NaturalIdLoadAccessImpl(String entityName) {
            this(sessionImpl.locateEntityPersister(entityName));
        }

        private NaturalIdLoadAccessImpl(Class entityClass) {
            this(sessionImpl.locateEntityPersister(entityClass));
        }

        @Override
        public NaturalIdLoadAccessImpl<T> with(LockOptions lockOptions) {
            return (NaturalIdLoadAccessImpl)super.with(lockOptions);
        }

        @Override
        public NaturalIdLoadAccess<T> using(String attributeName, Object value) {
            this.naturalIdParameters.put(attributeName, value);
            return this;
        }

        @Override
        public NaturalIdLoadAccessImpl<T> setSynchronizationEnabled(boolean synchronizationEnabled) {
            super.synchronizationEnabled(synchronizationEnabled);
            return this;
        }

        @Override
        public final T getReference() {
            Serializable entityId = this.resolveNaturalId(this.naturalIdParameters);
            if (entityId == null) {
                return null;
            }
            return this.getIdentifierLoadAccess().getReference(entityId);
        }

        @Override
        public final T load() {
            Serializable entityId = this.resolveNaturalId(this.naturalIdParameters);
            if (entityId == null) {
                return null;
            }
            try {
                return this.getIdentifierLoadAccess().load(entityId);
            }
            catch (EntityNotFoundException entityNotFoundException) {
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            return null;
        }
    }

    private abstract class BaseNaturalIdLoadAccessImpl<T> {
        private final EntityPersister entityPersister;
        private LockOptions lockOptions;
        private boolean synchronizationEnabled = true;

        private BaseNaturalIdLoadAccessImpl(EntityPersister entityPersister) {
            this.entityPersister = entityPersister;
            if (!entityPersister.hasNaturalIdentifier()) {
                throw new HibernateException(String.format("Entity [%s] did not define a natural id", entityPersister.getEntityName()));
            }
        }

        public BaseNaturalIdLoadAccessImpl<T> with(LockOptions lockOptions) {
            this.lockOptions = lockOptions;
            return this;
        }

        protected void synchronizationEnabled(boolean synchronizationEnabled) {
            this.synchronizationEnabled = synchronizationEnabled;
        }

        protected final Serializable resolveNaturalId(Map<String, Object> naturalIdParameters) {
            this.performAnyNeededCrossReferenceSynchronizations();
            ResolveNaturalIdEvent event = new ResolveNaturalIdEvent(naturalIdParameters, this.entityPersister, SessionImpl.this);
            SessionImpl.this.fireResolveNaturalId(event);
            if (event.getEntityId() == PersistenceContext.NaturalIdHelper.INVALID_NATURAL_ID_REFERENCE) {
                return null;
            }
            return event.getEntityId();
        }

        protected void performAnyNeededCrossReferenceSynchronizations() {
            if (!this.synchronizationEnabled) {
                return;
            }
            if (this.entityPersister.getEntityMetamodel().hasImmutableNaturalId()) {
                return;
            }
            if (!SessionImpl.this.isTransactionInProgress()) {
                return;
            }
            boolean debugEnabled = LOG.isDebugEnabled();
            for (Serializable pk : SessionImpl.this.getPersistenceContext().getNaturalIdHelper().getCachedPkResolutions(this.entityPersister)) {
                EntityKey entityKey = SessionImpl.this.generateEntityKey(pk, this.entityPersister);
                Object entity = SessionImpl.this.getPersistenceContext().getEntity(entityKey);
                EntityEntry entry = SessionImpl.this.getPersistenceContext().getEntry(entity);
                if (entry == null) {
                    if (!debugEnabled) continue;
                    LOG.debug("Cached natural-id/pk resolution linked to null EntityEntry in persistence context : " + MessageHelper.infoString(this.entityPersister, pk, SessionImpl.this.getFactory()));
                    continue;
                }
                if (!entry.requiresDirtyCheck(entity) || entry.getStatus() != Status.MANAGED) continue;
                SessionImpl.this.getPersistenceContext().getNaturalIdHelper().handleSynchronization(this.entityPersister, pk, entity);
            }
        }

        protected final IdentifierLoadAccess getIdentifierLoadAccess() {
            IdentifierLoadAccessImpl identifierLoadAccess = new IdentifierLoadAccessImpl(this.entityPersister);
            if (this.lockOptions != null) {
                identifierLoadAccess.with(this.lockOptions);
            }
            return identifierLoadAccess;
        }

        protected EntityPersister entityPersister() {
            return this.entityPersister;
        }
    }

    private class IdentifierLoadAccessImpl<T>
    implements IdentifierLoadAccess<T> {
        private final EntityPersister entityPersister;
        private LockOptions lockOptions;

        private IdentifierLoadAccessImpl(EntityPersister entityPersister) {
            this.entityPersister = entityPersister;
        }

        private IdentifierLoadAccessImpl(String entityName) {
            this(sessionImpl.locateEntityPersister(entityName));
        }

        private IdentifierLoadAccessImpl(Class<T> entityClass) {
            this(sessionImpl.locateEntityPersister(entityClass));
        }

        @Override
        public final IdentifierLoadAccessImpl<T> with(LockOptions lockOptions) {
            this.lockOptions = lockOptions;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T getReference(Serializable id) {
            if (this.lockOptions != null) {
                LoadEvent event = new LoadEvent(id, this.entityPersister.getEntityName(), this.lockOptions, (EventSource)SessionImpl.this);
                SessionImpl.this.fireLoad(event, LoadEventListener.LOAD);
                return (T)event.getResult();
            }
            LoadEvent event = new LoadEvent(id, this.entityPersister.getEntityName(), false, (EventSource)SessionImpl.this);
            boolean success = false;
            try {
                SessionImpl.this.fireLoad(event, LoadEventListener.LOAD);
                if (event.getResult() == null) {
                    SessionImpl.this.getFactory().getEntityNotFoundDelegate().handleEntityNotFound(this.entityPersister.getEntityName(), id);
                }
                success = true;
                Object object = event.getResult();
                return (T)object;
            }
            finally {
                SessionImpl.this.afterOperation(success);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T load(Serializable id) {
            if (this.lockOptions != null) {
                LoadEvent event = new LoadEvent(id, this.entityPersister.getEntityName(), this.lockOptions, (EventSource)SessionImpl.this);
                SessionImpl.this.fireLoad(event, LoadEventListener.GET);
                return (T)event.getResult();
            }
            LoadEvent event = new LoadEvent(id, this.entityPersister.getEntityName(), false, (EventSource)SessionImpl.this);
            boolean success = false;
            try {
                SessionImpl.this.fireLoad(event, LoadEventListener.GET);
                success = true;
            }
            catch (ObjectNotFoundException objectNotFoundException) {
            }
            finally {
                SessionImpl.this.afterOperation(success);
            }
            return (T)event.getResult();
        }
    }

    private class LockRequestImpl
    implements Session.LockRequest {
        private final LockOptions lockOptions = new LockOptions();

        private LockRequestImpl(LockOptions lo) {
            LockOptions.copy(lo, this.lockOptions);
        }

        @Override
        public LockMode getLockMode() {
            return this.lockOptions.getLockMode();
        }

        @Override
        public Session.LockRequest setLockMode(LockMode lockMode) {
            this.lockOptions.setLockMode(lockMode);
            return this;
        }

        @Override
        public int getTimeOut() {
            return this.lockOptions.getTimeOut();
        }

        @Override
        public Session.LockRequest setTimeOut(int timeout) {
            this.lockOptions.setTimeOut(timeout);
            return this;
        }

        @Override
        public boolean getScope() {
            return this.lockOptions.getScope();
        }

        @Override
        public Session.LockRequest setScope(boolean scope) {
            this.lockOptions.setScope(scope);
            return this;
        }

        @Override
        public void lock(String entityName, Object object) throws HibernateException {
            SessionImpl.this.fireLock(entityName, object, this.lockOptions);
        }

        @Override
        public void lock(Object object) throws HibernateException {
            SessionImpl.this.fireLock(object, this.lockOptions);
        }
    }

    private class CoordinatingEntityNameResolver
    implements EntityNameResolver {
        private CoordinatingEntityNameResolver() {
        }

        @Override
        public String resolveEntityName(Object entity) {
            EntityNameResolver resolver;
            String entityName = SessionImpl.this.interceptor.getEntityName(entity);
            if (entityName != null) {
                return entityName;
            }
            Iterator<EntityNameResolver> iterator = SessionImpl.this.factory.iterateEntityNameResolvers().iterator();
            while (iterator.hasNext() && (entityName = (resolver = iterator.next()).resolveEntityName(entity)) == null) {
            }
            if (entityName != null) {
                return entityName;
            }
            return entity.getClass().getName();
        }
    }

    private static class SharedSessionBuilderImpl
    extends SessionFactoryImpl.SessionBuilderImpl
    implements SharedSessionBuilder {
        private final SessionImpl session;
        private boolean shareTransactionContext;

        private SharedSessionBuilderImpl(SessionImpl session) {
            super(session.factory);
            this.session = session;
            super.owner(session.sessionOwner);
            super.tenantIdentifier(session.getTenantIdentifier());
        }

        @Override
        public SessionBuilder tenantIdentifier(String tenantIdentifier) {
            throw new SessionException("Cannot redefine tenant identifier on child session");
        }

        @Override
        protected TransactionCoordinator getTransactionCoordinator() {
            return this.shareTransactionContext ? this.session.transactionCoordinator : super.getTransactionCoordinator();
        }

        @Override
        protected JdbcCoordinatorImpl getJdbcCoordinator() {
            return this.shareTransactionContext ? this.session.jdbcCoordinator : super.getJdbcCoordinator();
        }

        @Override
        protected Transaction getTransaction() {
            return this.shareTransactionContext ? this.session.currentHibernateTransaction : super.getTransaction();
        }

        @Override
        protected ActionQueue.TransactionCompletionProcesses getTransactionCompletionProcesses() {
            return this.shareTransactionContext ? this.session.getActionQueue().getTransactionCompletionProcesses() : super.getTransactionCompletionProcesses();
        }

        @Override
        public SharedSessionBuilder interceptor() {
            return this.interceptor(this.session.interceptor);
        }

        @Override
        public SharedSessionBuilder connection() {
            this.shareTransactionContext = true;
            return this;
        }

        @Override
        public SharedSessionBuilder connectionReleaseMode() {
            return this.connectionReleaseMode(this.session.connectionReleaseMode);
        }

        @Override
        public SharedSessionBuilder autoJoinTransactions() {
            return this.autoJoinTransactions(this.session.autoJoinTransactions);
        }

        @Override
        public SharedSessionBuilder autoClose() {
            return this.autoClose(this.session.autoCloseSessionEnabled);
        }

        @Override
        public SharedSessionBuilder flushBeforeCompletion() {
            return this.flushBeforeCompletion(this.session.flushBeforeCompletionEnabled);
        }

        @Override
        @Deprecated
        public SharedSessionBuilder transactionContext() {
            return this.connection();
        }

        @Override
        public SharedSessionBuilder interceptor(Interceptor interceptor) {
            return (SharedSessionBuilder)super.interceptor(interceptor);
        }

        @Override
        public SharedSessionBuilder noInterceptor() {
            return (SharedSessionBuilder)super.noInterceptor();
        }

        @Override
        public SharedSessionBuilder statementInspector(StatementInspector statementInspector) {
            return (SharedSessionBuilder)super.statementInspector(statementInspector);
        }

        @Override
        public SharedSessionBuilder connection(Connection connection) {
            return (SharedSessionBuilder)super.connection(connection);
        }

        @Override
        public SharedSessionBuilder connectionReleaseMode(ConnectionReleaseMode connectionReleaseMode) {
            return (SharedSessionBuilder)super.connectionReleaseMode(connectionReleaseMode);
        }

        @Override
        public SharedSessionBuilder autoJoinTransactions(boolean autoJoinTransactions) {
            return (SharedSessionBuilder)super.autoJoinTransactions(autoJoinTransactions);
        }

        @Override
        public SharedSessionBuilder autoClose(boolean autoClose) {
            return (SharedSessionBuilder)super.autoClose(autoClose);
        }

        @Override
        public SharedSessionBuilder flushBeforeCompletion(boolean flushBeforeCompletion) {
            return (SharedSessionBuilder)super.flushBeforeCompletion(flushBeforeCompletion);
        }

        @Override
        public SharedSessionBuilder eventListeners(SessionEventListener ... listeners) {
            super.eventListeners(listeners);
            return this;
        }

        @Override
        public SessionBuilder clearEventListeners() {
            super.clearEventListeners();
            return this;
        }
    }

    private static class LobHelperImpl
    implements LobHelper {
        private final SessionImpl session;

        private LobHelperImpl(SessionImpl session) {
            this.session = session;
        }

        @Override
        public Blob createBlob(byte[] bytes) {
            return this.lobCreator().createBlob(bytes);
        }

        private LobCreator lobCreator() {
            return NonContextualLobCreator.INSTANCE;
        }

        @Override
        public Blob createBlob(InputStream stream, long length) {
            return this.lobCreator().createBlob(stream, length);
        }

        @Override
        public Clob createClob(String string) {
            return this.lobCreator().createClob(string);
        }

        @Override
        public Clob createClob(Reader reader, long length) {
            return this.lobCreator().createClob(reader, length);
        }

        @Override
        public NClob createNClob(String string) {
            return this.lobCreator().createNClob(string);
        }

        @Override
        public NClob createNClob(Reader reader, long length) {
            return this.lobCreator().createNClob(reader, length);
        }
    }
}

