/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.extract.spi;

import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Schema;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.extract.internal.DatabaseInformationImpl;
import org.hibernate.tool.schema.extract.internal.ExtractionContextImpl;
import org.hibernate.tool.schema.extract.internal.InformationExtractorJdbcDatabaseMetaDataImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorH2DatabaseImpl;
import org.hibernate.tool.schema.extract.spi.DatabaseInformation;
import org.hibernate.tool.schema.extract.spi.ExtractionContext;
import org.hibernate.tool.schema.extract.spi.InformationExtractor;
import org.hibernate.tool.schema.extract.spi.SequenceInformation;

public class DatabaseInformationBuilder {
    private final DatabaseInformationImpl databaseInformation = new DatabaseInformationImpl();
    private final ExtractionContext extractionContext;
    private final InformationExtractor metaDataExtractor;

    public DatabaseInformationBuilder(ServiceRegistry serviceRegistry, JdbcEnvironment jdbcEnvironment, final Connection jdbcConnection) {
        this(serviceRegistry, jdbcEnvironment, new JdbcConnectionAccess(){

            @Override
            public Connection obtainConnection() throws SQLException {
                return jdbcConnection;
            }

            @Override
            public void releaseConnection(Connection connection) throws SQLException {
            }

            @Override
            public boolean supportsAggressiveRelease() {
                return false;
            }
        });
    }

    public DatabaseInformationBuilder(ServiceRegistry serviceRegistry, JdbcEnvironment jdbcEnvironment, JdbcConnectionAccess jdbcConnectionAccess) {
        this.extractionContext = new ExtractionContextImpl(serviceRegistry, jdbcEnvironment, jdbcConnectionAccess, this.databaseInformation, null, null);
        this.metaDataExtractor = new InformationExtractorJdbcDatabaseMetaDataImpl(this.extractionContext);
    }

    public DatabaseInformationBuilder prepareAll() {
        return this;
    }

    public DatabaseInformationBuilder prepareCatalogAndSchema(Schema.Name schemaName) {
        return this;
    }

    public DatabaseInformationBuilder prepareCatalog(Identifier catalog) {
        return this;
    }

    public DatabaseInformationBuilder prepareSchema(Identifier schema) {
        return this;
    }

    private DatabaseInformationBuilder prepare(String catalog, String schema) {
        return this;
    }

    private Iterable<SequenceInformation> extractSequences() {
        if (!this.extractionContext.getJdbcEnvironment().getDialect().getClass().isAssignableFrom(H2Dialect.class)) {
            return null;
        }
        SequenceInformationExtractorH2DatabaseImpl seqExtractor = new SequenceInformationExtractorH2DatabaseImpl();
        try {
            return seqExtractor.extractMetadata(this.extractionContext);
        }
        catch (SQLException e) {
            throw this.extractionContext.getJdbcEnvironment().getSqlExceptionHelper().convert(e, "Unable to access sequence information");
        }
    }

    public DatabaseInformation build() {
        return this.databaseInformation;
    }
}

