/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.log;

import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="HHH")
@ValidIdRange(min=90000001, max=90001000)
public interface DeprecationLogger {
    public static final DeprecationLogger DEPRECATION_LOGGER = (DeprecationLogger)Logger.getMessageLogger(DeprecationLogger.class, (String)"org.hibernate.orm.deprecation");

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Found usage of deprecated setting for specifying Scanner [hibernate.ejb.resource_scanner]; use [hibernate.archive.scanner] instead", id=90000001)
    public void logDeprecatedScannerSetting();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Support for an entity defining multiple entity-modes is deprecated", id=90000002)
    public void logDeprecationOfMultipleEntityModeSupport();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Use of DOM4J entity-mode is considered deprecated", id=90000003)
    public void logDeprecationOfDomEntityModeSupport();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="embed-xml attributes were intended to be used for DOM4J entity mode. Since that entity mode has been removed, embed-xml attributes are no longer supported and should be removed from mappings.", id=90000004)
    public void logDeprecationOfEmbedXmlSupport();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Defining an entity [%s] with no physical id attribute is no longer supported; please map the identifier to a physical entity attribute", id=90000005)
    public void logDeprecationOfNonNamedIdAttribute(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Attempted to specify unsupported NamingStrategy via setting [%s]; NamingStrategy has been removed in favor of the split ImplicitNamingStrategy and PhysicalNamingStrategy; use [%s] or [%s], respectively, instead.", id=90000006)
    public void logDeprecatedNamingStrategySetting(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Attempted to specify unsupported NamingStrategy via command-line argument [--naming]. NamingStrategy has been removed in favor of the split ImplicitNamingStrategy and PhysicalNamingStrategy; use [--implicit-naming] or [--physical-naming], respectively, instead.", id=90000007)
    public void logDeprecatedNamingStrategyArgument();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Attempted to specify unsupported NamingStrategy via Ant task argument. NamingStrategy has been removed in favor of the split ImplicitNamingStrategy and PhysicalNamingStrategy.", id=90000008)
    public void logDeprecatedNamingStrategyAntArgument();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The outer-join attribute on <many-to-many> has been deprecated. Instead of outer-join=\"false\", use lazy=\"extra\" with <map>, <set>, <bag>, <idbag>, or <list>, which will only initialize entities (not as a proxy) as needed.", id=90000009)
    public void deprecatedManyToManyOuterJoin();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The fetch attribute on <many-to-many> has been deprecated. Instead of fetch=\"select\", use lazy=\"extra\" with <map>, <set>, <bag>, <idbag>, or <list>, which will only initialize entities (not as a proxy) as needed.", id=90000010)
    public void deprecatedManyToManyFetch();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="org.hibernate.hql.spi.TemporaryTableBulkIdStrategy (temporary) has been deprecated in favor of the more specific org.hibernate.hql.spi.id.local.LocalTemporaryTableBulkIdStrategy (local_temporary).", id=90000011)
    public void logDeprecationOfTemporaryTableBulkIdStrategy();
}

