/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.hibernate.AssertionFailure;
import org.hibernate.Cache;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.EmptyInterceptor;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionEventListener;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.Transaction;
import org.hibernate.TypeHelper;
import org.hibernate.UnknownEntityTypeException;
import org.hibernate.boot.cfgxml.spi.CfgXmlAccessService;
import org.hibernate.boot.cfgxml.spi.LoadedConfig;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.internal.CacheDataDescriptionImpl;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.QueryCache;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.UpdateTimestampsCache;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.RegionAccessStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.context.internal.JTASessionContext;
import org.hibernate.context.internal.ManagedSessionContext;
import org.hibernate.context.internal.ThreadLocalSessionContext;
import org.hibernate.context.spi.CurrentSessionContext;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunctionRegistry;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.internal.JdbcCoordinatorImpl;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jndi.spi.JndiService;
import org.hibernate.engine.profile.Association;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.query.spi.QueryPlanCache;
import org.hibernate.engine.query.spi.ReturnMetadata;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.CacheImplementor;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.SessionBuilderImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionOwner;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.NamedQueryRepository;
import org.hibernate.internal.SessionFactoryObserverChain;
import org.hibernate.internal.SessionFactoryRegistry;
import org.hibernate.internal.SessionImpl;
import org.hibernate.internal.StatelessSessionImpl;
import org.hibernate.internal.TypeLocatorImpl;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.config.ConfigurationException;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.persister.spi.PersisterCreationContext;
import org.hibernate.persister.spi.PersisterFactory;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.resource.transaction.TransactionCoordinator;
import org.hibernate.secure.spi.GrantedPermission;
import org.hibernate.secure.spi.JaccPermissionDeclarations;
import org.hibernate.secure.spi.JaccService;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.hibernate.service.spi.SessionFactoryServiceRegistryFactory;
import org.hibernate.stat.Statistics;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.tool.hbm2ddl.ImportSqlCommandExtractor;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.hbm2ddl.SchemaValidator;
import org.hibernate.tuple.entity.EntityTuplizer;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeResolver;
import org.jboss.logging.Logger;

public final class SessionFactoryImpl
implements SessionFactoryImplementor {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(SessionFactoryImpl.class);
    private static final IdentifierGenerator UUID_GENERATOR = UUIDGenerator.buildSessionFactoryUniqueIdentifierGenerator();
    private final String name;
    private final String uuid;
    private final transient Map<String, EntityPersister> entityPersisters;
    private final transient Map<String, ClassMetadata> classMetadata;
    private final transient Map<Class, String> entityProxyInterfaceMap;
    private final transient Map<String, CollectionPersister> collectionPersisters;
    private final transient Map<String, CollectionMetadata> collectionMetadata;
    private final transient Map<String, Set<String>> collectionRolesByEntityParticipant;
    private final transient Map<String, IdentifierGenerator> identifierGenerators;
    private final transient NamedQueryRepository namedQueryRepository;
    private final transient Map<String, FilterDefinition> filters;
    private final transient Map<String, FetchProfile> fetchProfiles;
    private final transient Map<String, String> imports;
    private final transient SessionFactoryServiceRegistry serviceRegistry;
    private final transient JdbcServices jdbcServices;
    private final transient Dialect dialect;
    private final transient Settings settings;
    private final transient Properties properties;
    private transient SchemaExport schemaExport;
    private final transient CurrentSessionContext currentSessionContext;
    private final transient SQLFunctionRegistry sqlFunctionRegistry;
    private final transient SessionFactoryObserverChain observer = new SessionFactoryObserverChain();
    private final transient ConcurrentMap<EntityNameResolver, Object> entityNameResolvers = new ConcurrentHashMap<EntityNameResolver, Object>();
    private final transient QueryPlanCache queryPlanCache;
    private final transient CacheImplementor cacheAccess;
    private transient boolean isClosed;
    private final transient TypeResolver typeResolver;
    private final transient TypeHelper typeHelper;
    private final transient SessionFactoryOptions sessionFactoryOptions;
    private final transient Map<String, RegionAccessStrategy> cacheAccessStrategiesMap = new HashMap<String, RegionAccessStrategy>();
    private static final Object ENTITY_NAME_RESOLVER_MAP_VALUE = new Object();

    public SessionFactoryImpl(final MetadataImplementor metadata, SessionFactoryOptions options) {
        Map<String, HibernateException> errors;
        LOG.debug("Building session factory");
        this.sessionFactoryOptions = options;
        this.settings = new Settings(options, metadata);
        this.serviceRegistry = options.getServiceRegistry().getService(SessionFactoryServiceRegistryFactory.class).buildServiceRegistry(this, options);
        CfgXmlAccessService cfgXmlAccessService = this.serviceRegistry.getService(CfgXmlAccessService.class);
        String sfName = this.settings.getSessionFactoryName();
        if (cfgXmlAccessService.getAggregatedConfig() != null) {
            if (sfName == null) {
                sfName = cfgXmlAccessService.getAggregatedConfig().getSessionFactoryName();
            }
            this.applyCfgXmlValues(cfgXmlAccessService.getAggregatedConfig(), this.serviceRegistry);
        }
        this.name = sfName;
        try {
            this.uuid = (String)((Object)UUID_GENERATOR.generate(null, null));
        }
        catch (Exception e) {
            throw new AssertionFailure("Could not generate UUID");
        }
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)this.serviceRegistry.getService(ConfigurationService.class).getSettings());
        this.jdbcServices = this.serviceRegistry.getService(JdbcServices.class);
        this.dialect = this.jdbcServices.getDialect();
        this.cacheAccess = this.serviceRegistry.getService(CacheImplementor.class);
        this.sqlFunctionRegistry = new SQLFunctionRegistry(this.getDialect(), options.getCustomSqlFunctionMap());
        for (SessionFactoryObserver sessionFactoryObserver : options.getSessionFactoryObservers()) {
            this.observer.addObserver(sessionFactoryObserver);
        }
        this.typeResolver = metadata.getTypeResolver().scope(this);
        this.typeHelper = new TypeLocatorImpl(this.typeResolver);
        this.filters = new HashMap<String, FilterDefinition>();
        this.filters.putAll(metadata.getFilterDefinitions());
        LOG.debugf("Session factory constructed with filter configurations : %s", this.filters);
        LOG.debugf("Instantiating session factory with properties: %s", this.properties);
        this.queryPlanCache = new QueryPlanCache(this);
        class IntegratorObserver
        implements SessionFactoryObserver {
            private ArrayList<Integrator> integrators = new ArrayList();

            IntegratorObserver() {
            }

            @Override
            public void sessionFactoryCreated(SessionFactory factory) {
            }

            @Override
            public void sessionFactoryClosed(SessionFactory factory) {
                for (Integrator integrator : this.integrators) {
                    integrator.disintegrate(SessionFactoryImpl.this, SessionFactoryImpl.this.serviceRegistry);
                }
                this.integrators.clear();
            }
        }
        IntegratorObserver integratorObserver = new IntegratorObserver();
        this.observer.addObserver(integratorObserver);
        for (Integrator integrator : this.serviceRegistry.getService(IntegratorService.class).getIntegrators()) {
            integrator.integrate(metadata, this, this.serviceRegistry);
            integratorObserver.integrators.add(integrator);
        }
        this.identifierGenerators = new HashMap<String, IdentifierGenerator>();
        for (PersistentClass model : metadata.getEntityBindings()) {
            if (model.isInherited()) continue;
            IdentifierGenerator generator = model.getIdentifier().createIdentifierGenerator(metadata.getIdentifierGeneratorFactory(), this.getDialect(), this.settings.getDefaultCatalogName(), this.settings.getDefaultSchemaName(), (RootClass)model);
            this.identifierGenerators.put(model.getEntityName(), generator);
        }
        this.imports = new HashMap<String, String>(metadata.getImports());
        PersisterCreationContext persisterCreationContext = new PersisterCreationContext(){

            @Override
            public SessionFactoryImplementor getSessionFactory() {
                return SessionFactoryImpl.this;
            }

            @Override
            public MetadataImplementor getMetadata() {
                return metadata;
            }
        };
        RegionFactory regionFactory = this.cacheAccess.getRegionFactory();
        String cacheRegionPrefix = this.settings.getCacheRegionPrefix() == null ? "" : this.settings.getCacheRegionPrefix() + ".";
        PersisterFactory persisterFactory = this.serviceRegistry.getService(PersisterFactory.class);
        this.entityPersisters = new HashMap<String, EntityPersister>();
        HashMap<String, ClassMetadata> inFlightClassMetadataMap = new HashMap<String, ClassMetadata>();
        this.entityProxyInterfaceMap = CollectionHelper.concurrentMap(metadata.getEntityBindings().size());
        for (PersistentClass model : metadata.getEntityBindings()) {
            Iterator<Object> cacheRegionName = cacheRegionPrefix + model.getRootClass().getCacheRegionName();
            EntityRegionAccessStrategy entityRegionAccessStrategy = this.determineEntityRegionAccessStrategy(regionFactory, this.cacheAccessStrategiesMap, model, (String)((Object)cacheRegionName));
            NaturalIdRegionAccessStrategy naturalIdAccessStrategy = this.determineNaturalIdRegionAccessStrategy(regionFactory, cacheRegionPrefix, this.cacheAccessStrategiesMap, model);
            EntityPersister cp = persisterFactory.createEntityPersister(model, entityRegionAccessStrategy, naturalIdAccessStrategy, persisterCreationContext);
            this.entityPersisters.put(model.getEntityName(), cp);
            inFlightClassMetadataMap.put(model.getEntityName(), cp.getClassMetadata());
            if (cp.getConcreteProxyClass() == null || !cp.getConcreteProxyClass().isInterface() || Map.class.isAssignableFrom(cp.getConcreteProxyClass()) || cp.getMappedClass() == cp.getConcreteProxyClass()) continue;
            if (cp.getMappedClass().equals(cp.getConcreteProxyClass())) {
                LOG.debugf("Entity [%s] mapped same interface [%s] as class and proxy", cp.getEntityName(), cp.getMappedClass());
                continue;
            }
            String old = this.entityProxyInterfaceMap.put(cp.getConcreteProxyClass(), cp.getEntityName());
            if (old == null) continue;
            throw new HibernateException(String.format(Locale.ENGLISH, "Multiple entities [%s, %s] named the same interface [%s] as their proxy which is not supported", old, cp.getEntityName(), cp.getConcreteProxyClass().getName()));
        }
        this.classMetadata = Collections.unmodifiableMap(inFlightClassMetadataMap);
        this.collectionPersisters = new HashMap<String, CollectionPersister>();
        HashMap<String, HashSet<String>> inFlightEntityToCollectionRoleMap = new HashMap<String, HashSet<String>>();
        HashMap<String, CollectionMetadata> tmpCollectionMetadata = new HashMap<String, CollectionMetadata>();
        for (Collection collection : metadata.getCollectionBindings()) {
            Type elementType;
            CollectionRegionAccessStrategy accessStrategy;
            String cacheRegionName = cacheRegionPrefix + collection.getCacheRegionName();
            AccessType accessType = AccessType.fromExternalName(collection.getCacheConcurrencyStrategy());
            if (accessType != null && this.settings.isSecondLevelCacheEnabled()) {
                LOG.tracev("Building shared cache region for collection data [{0}]", collection.getRole());
                CollectionRegion collectionRegion = regionFactory.buildCollectionRegion(cacheRegionName, this.properties, CacheDataDescriptionImpl.decode(collection));
                accessStrategy = collectionRegion.buildAccessStrategy(accessType);
                this.cacheAccessStrategiesMap.put(cacheRegionName, accessStrategy);
                this.cacheAccess.addCacheRegion(cacheRegionName, collectionRegion);
            } else {
                accessStrategy = null;
            }
            CollectionPersister persister = persisterFactory.createCollectionPersister(collection, accessStrategy, persisterCreationContext);
            this.collectionPersisters.put(collection.getRole(), persister);
            tmpCollectionMetadata.put(collection.getRole(), persister.getCollectionMetadata());
            Type indexType = persister.getIndexType();
            if (indexType != null && indexType.isAssociationType() && !indexType.isAnyType()) {
                String entityName = ((AssociationType)indexType).getAssociatedEntityName(this);
                HashSet<String> roles = (HashSet<String>)inFlightEntityToCollectionRoleMap.get(entityName);
                if (roles == null) {
                    roles = new HashSet<String>();
                    inFlightEntityToCollectionRoleMap.put(entityName, roles);
                }
                roles.add(persister.getRole());
            }
            if (!(elementType = persister.getElementType()).isAssociationType() || elementType.isAnyType()) continue;
            String entityName = ((AssociationType)elementType).getAssociatedEntityName(this);
            HashSet<String> roles = (HashSet<String>)inFlightEntityToCollectionRoleMap.get(entityName);
            if (roles == null) {
                roles = new HashSet<String>();
                inFlightEntityToCollectionRoleMap.put(entityName, roles);
            }
            roles.add(persister.getRole());
        }
        this.collectionMetadata = Collections.unmodifiableMap(tmpCollectionMetadata);
        for (Map.Entry entry : inFlightEntityToCollectionRoleMap.entrySet()) {
            entry.setValue(Collections.unmodifiableSet((Set)entry.getValue()));
        }
        this.collectionRolesByEntityParticipant = Collections.unmodifiableMap(inFlightEntityToCollectionRoleMap);
        this.namedQueryRepository = metadata.buildNamedQueryRepository(this);
        for (EntityPersister entityPersister : this.entityPersisters.values()) {
            entityPersister.generateEntityDefinition();
        }
        for (EntityPersister entityPersister : this.entityPersisters.values()) {
            entityPersister.postInstantiate();
            this.registerEntityNameResolvers(entityPersister);
        }
        for (CollectionPersister collectionPersister : this.collectionPersisters.values()) {
            collectionPersister.postInstantiate();
        }
        LOG.debug("Instantiated session factory");
        this.settings.getMultiTableBulkIdStrategy().prepare(this.jdbcServices, this.buildLocalConnectionAccess(), metadata, this.sessionFactoryOptions);
        if (this.settings.isAutoCreateSchema()) {
            new SchemaExport((ServiceRegistry)this.serviceRegistry, metadata).setImportSqlCommandExtractor(this.serviceRegistry.getService(ImportSqlCommandExtractor.class)).create(false, true);
        }
        if (this.settings.isAutoUpdateSchema()) {
            new SchemaUpdate(this.serviceRegistry, metadata).execute(false, true);
        }
        if (this.settings.isAutoValidateSchema()) {
            new SchemaValidator(this.serviceRegistry, metadata).validate();
        }
        if (this.settings.isAutoDropSchema()) {
            this.schemaExport = new SchemaExport((ServiceRegistry)this.serviceRegistry, metadata).setImportSqlCommandExtractor(this.serviceRegistry.getService(ImportSqlCommandExtractor.class));
        }
        this.currentSessionContext = this.buildCurrentSessionContext();
        if (this.settings.isNamedQueryStartupCheckingEnabled() && !(errors = this.checkNamedQueries()).isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder("Errors in named queries: ");
            String sep = "";
            for (Map.Entry<String, HibernateException> entry : errors.entrySet()) {
                LOG.namedQueryError(entry.getKey(), entry.getValue());
                stringBuilder.append(sep).append(entry.getKey());
                sep = ", ";
            }
            throw new HibernateException(stringBuilder.toString());
        }
        this.fetchProfiles = new HashMap<String, FetchProfile>();
        for (org.hibernate.mapping.FetchProfile fetchProfile : metadata.getFetchProfiles()) {
            FetchProfile fetchProfile2 = new FetchProfile(fetchProfile.getName());
            for (FetchProfile.Fetch mappingFetch : fetchProfile.getFetches()) {
                EntityPersister owner;
                String entityName = this.getImportedClassName(mappingFetch.getEntity());
                EntityPersister entityPersister = owner = entityName == null ? null : this.entityPersisters.get(entityName);
                if (owner == null) {
                    throw new HibernateException("Unable to resolve entity reference [" + mappingFetch.getEntity() + "] in fetch profile [" + fetchProfile2.getName() + "]");
                }
                Type associationType = owner.getPropertyType(mappingFetch.getAssociation());
                if (associationType == null || !associationType.isAssociationType()) {
                    throw new HibernateException("Fetch profile [" + fetchProfile2.getName() + "] specified an invalid association");
                }
                Fetch.Style fetchStyle = Fetch.Style.parse(mappingFetch.getStyle());
                fetchProfile2.addFetch(new Association(owner, mappingFetch.getAssociation()), fetchStyle);
                ((Loadable)owner).registerAffectingFetchProfile(fetchProfile2.getName());
            }
            this.fetchProfiles.put(fetchProfile2.getName(), fetchProfile2);
        }
        this.observer.sessionFactoryCreated(this);
        SessionFactoryRegistry.INSTANCE.addSessionFactory(this.uuid, this.name, this.settings.isSessionFactoryNameAlsoJndiName(), this, this.serviceRegistry.getService(JndiService.class));
    }

    private void applyCfgXmlValues(LoadedConfig aggregatedConfig, SessionFactoryServiceRegistry serviceRegistry) {
        JaccPermissionDeclarations permissions;
        JaccService jaccService = serviceRegistry.getService(JaccService.class);
        if (jaccService.getContextId() != null && (permissions = aggregatedConfig.getJaccPermissions(jaccService.getContextId())) != null) {
            for (GrantedPermission grantedPermission : permissions.getPermissionDeclarations()) {
                jaccService.addPermission(grantedPermission);
            }
        }
        if (aggregatedConfig.getEventListenerMap() != null) {
            ClassLoaderService cls = serviceRegistry.getService(ClassLoaderService.class);
            EventListenerRegistry eventListenerRegistry = serviceRegistry.getService(EventListenerRegistry.class);
            for (Map.Entry<EventType, Set<String>> entry : aggregatedConfig.getEventListenerMap().entrySet()) {
                EventListenerGroup group = eventListenerRegistry.getEventListenerGroup(entry.getKey());
                for (String listenerClassName : entry.getValue()) {
                    try {
                        group.appendListener(cls.classForName(listenerClassName).newInstance());
                    }
                    catch (Exception e) {
                        throw new ConfigurationException("Unable to instantiate event listener class : " + listenerClassName, e);
                    }
                }
            }
        }
    }

    private NaturalIdRegionAccessStrategy determineNaturalIdRegionAccessStrategy(RegionFactory regionFactory, String cacheRegionPrefix, Map cacheAccessStrategiesMap, PersistentClass model) {
        String naturalIdCacheRegionName;
        NaturalIdRegionAccessStrategy naturalIdAccessStrategy = null;
        if (model.hasNaturalId() && model.getNaturalIdCacheRegionName() != null && (naturalIdAccessStrategy = (NaturalIdRegionAccessStrategy)cacheAccessStrategiesMap.get(naturalIdCacheRegionName = cacheRegionPrefix + model.getNaturalIdCacheRegionName())) == null && this.settings.isSecondLevelCacheEnabled()) {
            CacheDataDescriptionImpl cacheDataDescription = CacheDataDescriptionImpl.decode(model);
            NaturalIdRegion naturalIdRegion = null;
            try {
                naturalIdRegion = regionFactory.buildNaturalIdRegion(naturalIdCacheRegionName, this.properties, cacheDataDescription);
            }
            catch (UnsupportedOperationException e) {
                LOG.warnf("Shared cache region factory [%s] does not support natural id caching; shared NaturalId caching will be disabled for not be enabled for %s", regionFactory.getClass().getName(), model.getEntityName());
            }
            if (naturalIdRegion != null) {
                naturalIdAccessStrategy = naturalIdRegion.buildAccessStrategy(regionFactory.getDefaultAccessType());
                cacheAccessStrategiesMap.put(naturalIdCacheRegionName, naturalIdAccessStrategy);
                this.cacheAccess.addCacheRegion(naturalIdCacheRegionName, naturalIdRegion);
            }
        }
        return naturalIdAccessStrategy;
    }

    private EntityRegionAccessStrategy determineEntityRegionAccessStrategy(RegionFactory regionFactory, Map cacheAccessStrategiesMap, PersistentClass model, String cacheRegionName) {
        AccessType accessType;
        EntityRegionAccessStrategy accessStrategy = (EntityRegionAccessStrategy)cacheAccessStrategiesMap.get(cacheRegionName);
        if (accessStrategy == null && this.settings.isSecondLevelCacheEnabled() && (accessType = AccessType.fromExternalName(model.getCacheConcurrencyStrategy())) != null) {
            LOG.tracef("Building shared cache region for entity data [%s]", model.getEntityName());
            EntityRegion entityRegion = regionFactory.buildEntityRegion(cacheRegionName, this.properties, CacheDataDescriptionImpl.decode(model));
            accessStrategy = entityRegion.buildAccessStrategy(accessType);
            cacheAccessStrategiesMap.put(cacheRegionName, accessStrategy);
            this.cacheAccess.addCacheRegion(cacheRegionName, entityRegion);
        }
        return accessStrategy;
    }

    private JdbcConnectionAccess buildLocalConnectionAccess() {
        return new JdbcConnectionAccess(){

            @Override
            public Connection obtainConnection() throws SQLException {
                return SessionFactoryImpl.this.settings.getMultiTenancyStrategy() == MultiTenancyStrategy.NONE ? SessionFactoryImpl.this.serviceRegistry.getService(ConnectionProvider.class).getConnection() : SessionFactoryImpl.this.serviceRegistry.getService(MultiTenantConnectionProvider.class).getAnyConnection();
            }

            @Override
            public void releaseConnection(Connection connection) throws SQLException {
                if (SessionFactoryImpl.this.settings.getMultiTenancyStrategy() == MultiTenancyStrategy.NONE) {
                    SessionFactoryImpl.this.serviceRegistry.getService(ConnectionProvider.class).closeConnection(connection);
                } else {
                    SessionFactoryImpl.this.serviceRegistry.getService(MultiTenantConnectionProvider.class).releaseAnyConnection(connection);
                }
            }

            @Override
            public boolean supportsAggressiveRelease() {
                return false;
            }
        };
    }

    private static Properties createPropertiesFromMap(Map map) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)map);
        return properties;
    }

    @Override
    public Session openSession() throws HibernateException {
        return this.withOptions().openSession();
    }

    @Override
    public Session openTemporarySession() throws HibernateException {
        return this.withOptions().autoClose(false).flushBeforeCompletion(false).connectionReleaseMode(ConnectionReleaseMode.AFTER_STATEMENT).openSession();
    }

    @Override
    public Session getCurrentSession() throws HibernateException {
        if (this.currentSessionContext == null) {
            throw new HibernateException("No CurrentSessionContext configured!");
        }
        return this.currentSessionContext.currentSession();
    }

    @Override
    public SessionBuilderImplementor withOptions() {
        return new SessionBuilderImpl(this);
    }

    @Override
    public StatelessSessionBuilder withStatelessOptions() {
        return new StatelessSessionBuilderImpl(this);
    }

    @Override
    public StatelessSession openStatelessSession() {
        return this.withStatelessOptions().openStatelessSession();
    }

    @Override
    public StatelessSession openStatelessSession(Connection connection) {
        return this.withStatelessOptions().connection(connection).openStatelessSession();
    }

    @Override
    public void addObserver(SessionFactoryObserver observer) {
        this.observer.addObserver(observer);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return null;
    }

    @Override
    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    private void registerEntityNameResolvers(EntityPersister persister) {
        if (persister.getEntityMetamodel() == null || persister.getEntityMetamodel().getTuplizer() == null) {
            return;
        }
        this.registerEntityNameResolvers(persister.getEntityMetamodel().getTuplizer());
    }

    private void registerEntityNameResolvers(EntityTuplizer tuplizer) {
        EntityNameResolver[] resolvers = tuplizer.getEntityNameResolvers();
        if (resolvers == null) {
            return;
        }
        for (EntityNameResolver resolver : resolvers) {
            this.registerEntityNameResolver(resolver);
        }
    }

    public void registerEntityNameResolver(EntityNameResolver resolver) {
        this.entityNameResolvers.put(resolver, ENTITY_NAME_RESOLVER_MAP_VALUE);
    }

    @Override
    public Iterable<EntityNameResolver> iterateEntityNameResolvers() {
        return this.entityNameResolvers.keySet();
    }

    @Override
    public QueryPlanCache getQueryPlanCache() {
        return this.queryPlanCache;
    }

    private Map<String, HibernateException> checkNamedQueries() throws HibernateException {
        return this.namedQueryRepository.checkNamedQueries(this.queryPlanCache);
    }

    @Override
    public Map<String, EntityPersister> getEntityPersisters() {
        return this.entityPersisters;
    }

    @Override
    public EntityPersister getEntityPersister(String entityName) throws MappingException {
        EntityPersister result = this.entityPersisters.get(entityName);
        if (result == null) {
            throw new MappingException("Unknown entity: " + entityName);
        }
        return result;
    }

    @Override
    public EntityPersister locateEntityPersister(Class byClass) {
        String mappedEntityName;
        EntityPersister entityPersister = this.entityPersisters.get(byClass.getName());
        if (entityPersister == null && (mappedEntityName = this.entityProxyInterfaceMap.get(byClass)) != null) {
            entityPersister = this.entityPersisters.get(mappedEntityName);
        }
        if (entityPersister == null) {
            throw new UnknownEntityTypeException("Unable to locate persister: " + byClass.getName());
        }
        return entityPersister;
    }

    @Override
    public EntityPersister locateEntityPersister(String byName) {
        EntityPersister entityPersister = this.entityPersisters.get(byName);
        if (entityPersister == null) {
            throw new UnknownEntityTypeException("Unable to locate persister: " + byName);
        }
        return entityPersister;
    }

    @Override
    public SessionFactoryImplementor.DeserializationResolver getDeserializationResolver() {
        return new SessionFactoryImplementor.DeserializationResolver(){

            public SessionFactoryImplementor resolve() {
                return (SessionFactoryImplementor)SessionFactoryRegistry.INSTANCE.findSessionFactory(SessionFactoryImpl.this.uuid, SessionFactoryImpl.this.name);
            }
        };
    }

    @Override
    public Map<String, CollectionPersister> getCollectionPersisters() {
        return this.collectionPersisters;
    }

    @Override
    public CollectionPersister getCollectionPersister(String role) throws MappingException {
        CollectionPersister result = this.collectionPersisters.get(role);
        if (result == null) {
            throw new MappingException("Unknown collection role: " + role);
        }
        return result;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public SessionFactoryOptions getSessionFactoryOptions() {
        return this.sessionFactoryOptions;
    }

    @Override
    public JdbcServices getJdbcServices() {
        return this.jdbcServices;
    }

    @Override
    public Dialect getDialect() {
        if (this.serviceRegistry == null) {
            throw new IllegalStateException("Cannot determine dialect because serviceRegistry is null.");
        }
        return this.dialect;
    }

    @Override
    public Interceptor getInterceptor() {
        return this.sessionFactoryOptions.getInterceptor();
    }

    @Override
    public SQLExceptionConverter getSQLExceptionConverter() {
        return this.getSQLExceptionHelper().getSqlExceptionConverter();
    }

    @Override
    public SqlExceptionHelper getSQLExceptionHelper() {
        return this.getJdbcServices().getSqlExceptionHelper();
    }

    @Override
    public Set<String> getCollectionRolesByEntityParticipant(String entityName) {
        return this.collectionRolesByEntityParticipant.get(entityName);
    }

    @Override
    public Reference getReference() {
        LOG.debug("Returning a Reference to the SessionFactory");
        return new Reference(SessionFactoryImpl.class.getName(), new StringRefAddr("uuid", this.uuid), SessionFactoryRegistry.ObjectFactoryImpl.class.getName(), null);
    }

    @Override
    public NamedQueryRepository getNamedQueryRepository() {
        return this.namedQueryRepository;
    }

    @Override
    public void registerNamedQueryDefinition(String name, NamedQueryDefinition definition) {
        this.namedQueryRepository.registerNamedQueryDefinition(name, definition);
    }

    @Override
    public NamedQueryDefinition getNamedQuery(String queryName) {
        return this.namedQueryRepository.getNamedQueryDefinition(queryName);
    }

    @Override
    public void registerNamedSQLQueryDefinition(String name, NamedSQLQueryDefinition definition) {
        this.namedQueryRepository.registerNamedSQLQueryDefinition(name, definition);
    }

    @Override
    public NamedSQLQueryDefinition getNamedSQLQuery(String queryName) {
        return this.namedQueryRepository.getNamedSQLQueryDefinition(queryName);
    }

    @Override
    public ResultSetMappingDefinition getResultSetMapping(String mappingName) {
        return this.namedQueryRepository.getResultSetMappingDefinition(mappingName);
    }

    @Override
    public Type getIdentifierType(String className) throws MappingException {
        return this.getEntityPersister(className).getIdentifierType();
    }

    @Override
    public String getIdentifierPropertyName(String className) throws MappingException {
        return this.getEntityPersister(className).getIdentifierPropertyName();
    }

    @Override
    public Type[] getReturnTypes(String queryString) throws HibernateException {
        ReturnMetadata metadata = this.queryPlanCache.getHQLQueryPlan(queryString, false, Collections.EMPTY_MAP).getReturnMetadata();
        return metadata == null ? null : metadata.getReturnTypes();
    }

    @Override
    public String[] getReturnAliases(String queryString) throws HibernateException {
        ReturnMetadata metadata = this.queryPlanCache.getHQLQueryPlan(queryString, false, Collections.EMPTY_MAP).getReturnMetadata();
        return metadata == null ? null : metadata.getReturnAliases();
    }

    @Override
    public ClassMetadata getClassMetadata(Class persistentClass) throws HibernateException {
        return this.getClassMetadata(persistentClass.getName());
    }

    @Override
    public CollectionMetadata getCollectionMetadata(String roleName) throws HibernateException {
        return this.collectionMetadata.get(roleName);
    }

    @Override
    public ClassMetadata getClassMetadata(String entityName) throws HibernateException {
        return this.classMetadata.get(entityName);
    }

    @Override
    public String[] getImplementors(String className) throws MappingException {
        Class clazz;
        try {
            clazz = this.serviceRegistry.getService(ClassLoaderService.class).classForName(className);
        }
        catch (ClassLoadingException cnfe) {
            return new String[]{className};
        }
        ArrayList<String> results = new ArrayList<String>();
        for (EntityPersister checkPersister : this.entityPersisters.values()) {
            boolean assignableSuperclass;
            if (!Queryable.class.isInstance(checkPersister)) continue;
            Queryable checkQueryable = (Queryable)Queryable.class.cast(checkPersister);
            String checkQueryableEntityName = checkQueryable.getEntityName();
            boolean isMappedClass = className.equals(checkQueryableEntityName);
            if (checkQueryable.isExplicitPolymorphism()) {
                if (!isMappedClass) continue;
                return new String[]{className};
            }
            if (isMappedClass) {
                results.add(checkQueryableEntityName);
                continue;
            }
            Class mappedClass = checkQueryable.getMappedClass();
            if (mappedClass == null || !clazz.isAssignableFrom(mappedClass)) continue;
            if (checkQueryable.isInherited()) {
                Class mappedSuperclass = this.getEntityPersister(checkQueryable.getMappedSuperclass()).getMappedClass();
                assignableSuperclass = clazz.isAssignableFrom(mappedSuperclass);
            } else {
                assignableSuperclass = false;
            }
            if (assignableSuperclass) continue;
            results.add(checkQueryableEntityName);
        }
        return results.toArray(new String[results.size()]);
    }

    @Override
    public String getImportedClassName(String className) {
        String result = this.imports.get(className);
        if (result == null) {
            try {
                this.serviceRegistry.getService(ClassLoaderService.class).classForName(className);
                this.imports.put(className, className);
                return className;
            }
            catch (ClassLoadingException cnfe) {
                return null;
            }
        }
        return result;
    }

    @Override
    public Map<String, ClassMetadata> getAllClassMetadata() throws HibernateException {
        return this.classMetadata;
    }

    @Override
    public Map getAllCollectionMetadata() throws HibernateException {
        return this.collectionMetadata;
    }

    @Override
    public Type getReferencedPropertyType(String className, String propertyName) throws MappingException {
        return this.getEntityPersister(className).getPropertyType(propertyName);
    }

    @Override
    public void close() throws HibernateException {
        if (this.isClosed) {
            LOG.trace("Already closed");
            return;
        }
        LOG.closing();
        this.isClosed = true;
        this.settings.getMultiTableBulkIdStrategy().release(this.jdbcServices, this.buildLocalConnectionAccess());
        for (EntityPersister entityPersister : this.entityPersisters.values()) {
            if (!entityPersister.hasCache()) continue;
            entityPersister.getCacheAccessStrategy().getRegion().destroy();
        }
        for (CollectionPersister collectionPersister : this.collectionPersisters.values()) {
            if (!collectionPersister.hasCache()) continue;
            collectionPersister.getCacheAccessStrategy().getRegion().destroy();
        }
        this.cacheAccess.close();
        this.queryPlanCache.cleanup();
        if (this.settings.isAutoDropSchema()) {
            this.schemaExport.drop(false, true);
        }
        SessionFactoryRegistry.INSTANCE.removeSessionFactory(this.uuid, this.name, this.settings.isSessionFactoryNameAlsoJndiName(), this.serviceRegistry.getService(JndiService.class));
        this.observer.sessionFactoryClosed(this);
        this.serviceRegistry.destroy();
    }

    @Override
    public Cache getCache() {
        return this.cacheAccess;
    }

    public void evictEntity(String entityName, Serializable id) throws HibernateException {
        this.getCache().evictEntity(entityName, id);
    }

    public void evictEntity(String entityName) throws HibernateException {
        this.getCache().evictEntityRegion(entityName);
    }

    public void evict(Class persistentClass, Serializable id) throws HibernateException {
        this.getCache().evictEntity(persistentClass, id);
    }

    public void evict(Class persistentClass) throws HibernateException {
        this.getCache().evictEntityRegion(persistentClass);
    }

    public void evictCollection(String roleName, Serializable id) throws HibernateException {
        this.getCache().evictCollection(roleName, id);
    }

    public void evictCollection(String roleName) throws HibernateException {
        this.getCache().evictCollectionRegion(roleName);
    }

    public void evictQueries() throws HibernateException {
        this.cacheAccess.evictQueries();
    }

    public void evictQueries(String regionName) throws HibernateException {
        this.getCache().evictQueryRegion(regionName);
    }

    @Override
    public UpdateTimestampsCache getUpdateTimestampsCache() {
        return this.cacheAccess.getUpdateTimestampsCache();
    }

    @Override
    public QueryCache getQueryCache() {
        return this.cacheAccess.getQueryCache();
    }

    @Override
    public QueryCache getQueryCache(String regionName) throws HibernateException {
        return this.cacheAccess.getQueryCache(regionName);
    }

    @Override
    public Region getSecondLevelCacheRegion(String regionName) {
        return this.cacheAccess.getSecondLevelCacheRegion(regionName);
    }

    @Override
    public RegionAccessStrategy getSecondLevelCacheRegionAccessStrategy(String regionName) {
        return this.cacheAccessStrategiesMap.get(regionName);
    }

    @Override
    public Region getNaturalIdCacheRegion(String regionName) {
        return this.cacheAccess.getNaturalIdCacheRegion(regionName);
    }

    @Override
    public RegionAccessStrategy getNaturalIdCacheRegionAccessStrategy(String regionName) {
        return this.cacheAccessStrategiesMap.get(regionName);
    }

    @Override
    public Map getAllSecondLevelCacheRegions() {
        return this.cacheAccess.getAllSecondLevelCacheRegions();
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public Statistics getStatistics() {
        return this.getStatisticsImplementor();
    }

    @Override
    public StatisticsImplementor getStatisticsImplementor() {
        return this.serviceRegistry.getService(StatisticsImplementor.class);
    }

    @Override
    public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
        FilterDefinition def = this.filters.get(filterName);
        if (def == null) {
            throw new HibernateException("No such filter configured [" + filterName + "]");
        }
        return def;
    }

    @Override
    public boolean containsFetchProfileDefinition(String name) {
        return this.fetchProfiles.containsKey(name);
    }

    @Override
    public Set getDefinedFilterNames() {
        return this.filters.keySet();
    }

    @Override
    public IdentifierGenerator getIdentifierGenerator(String rootEntityName) {
        return this.identifierGenerators.get(rootEntityName);
    }

    private boolean canAccessTransactionManager() {
        try {
            return this.serviceRegistry.getService(JtaPlatform.class).retrieveTransactionManager() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private CurrentSessionContext buildCurrentSessionContext() {
        String impl = this.properties.getProperty("hibernate.current_session_context_class");
        if (impl == null) {
            if (this.canAccessTransactionManager()) {
                impl = "jta";
            } else {
                return null;
            }
        }
        if ("jta".equals(impl)) {
            return new JTASessionContext(this);
        }
        if ("thread".equals(impl)) {
            return new ThreadLocalSessionContext(this);
        }
        if ("managed".equals(impl)) {
            return new ManagedSessionContext(this);
        }
        try {
            Class implClass = this.serviceRegistry.getService(ClassLoaderService.class).classForName(impl);
            return (CurrentSessionContext)implClass.getConstructor(SessionFactoryImplementor.class).newInstance(this);
        }
        catch (Throwable t) {
            LOG.unableToConstructCurrentSessionContext(impl, t);
            return null;
        }
    }

    @Override
    public ServiceRegistryImplementor getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.sessionFactoryOptions.getEntityNotFoundDelegate();
    }

    @Override
    public SQLFunctionRegistry getSqlFunctionRegistry() {
        return this.sqlFunctionRegistry;
    }

    @Override
    public FetchProfile getFetchProfile(String name) {
        return this.fetchProfiles.get(name);
    }

    @Override
    public TypeHelper getTypeHelper() {
        return this.typeHelper;
    }

    @Override
    public CustomEntityDirtinessStrategy getCustomEntityDirtinessStrategy() {
        return this.getSessionFactoryOptions().getCustomEntityDirtinessStrategy();
    }

    @Override
    public CurrentTenantIdentifierResolver getCurrentTenantIdentifierResolver() {
        return this.getSessionFactoryOptions().getCurrentTenantIdentifierResolver();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        LOG.debugf("Serializing: %s", this.uuid);
        out.defaultWriteObject();
        LOG.trace("Serialized");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        LOG.trace("Deserializing");
        in.defaultReadObject();
        LOG.debugf("Deserialized: %s", this.uuid);
    }

    private Object readResolve() throws InvalidObjectException {
        LOG.trace("Resolving serialized SessionFactory");
        return SessionFactoryImpl.locateSessionFactoryOnDeserialization(this.uuid, this.name);
    }

    private static SessionFactory locateSessionFactoryOnDeserialization(String uuid, String name) throws InvalidObjectException {
        SessionFactory namedResult;
        SessionFactory uuidResult = SessionFactoryRegistry.INSTANCE.getSessionFactory(uuid);
        if (uuidResult != null) {
            LOG.debugf("Resolved SessionFactory by UUID [%s]", uuid);
            return uuidResult;
        }
        if (name != null && (namedResult = SessionFactoryRegistry.INSTANCE.getNamedSessionFactory(name)) != null) {
            LOG.debugf("Resolved SessionFactory by name [%s]", name);
            return namedResult;
        }
        throw new InvalidObjectException("Could not find a SessionFactory [uuid=" + uuid + ",name=" + name + "]");
    }

    void serialize(ObjectOutputStream oos) throws IOException {
        oos.writeUTF(this.uuid);
        oos.writeBoolean(this.name != null);
        if (this.name != null) {
            oos.writeUTF(this.name);
        }
    }

    static SessionFactoryImpl deserialize(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        LOG.trace("Deserializing SessionFactory from Session");
        String uuid = ois.readUTF();
        boolean isNamed = ois.readBoolean();
        String name = isNamed ? ois.readUTF() : null;
        return (SessionFactoryImpl)SessionFactoryImpl.locateSessionFactoryOnDeserialization(uuid, name);
    }

    public static class StatelessSessionBuilderImpl
    implements StatelessSessionBuilder {
        private final SessionFactoryImpl sessionFactory;
        private Connection connection;
        private String tenantIdentifier;

        public StatelessSessionBuilderImpl(SessionFactoryImpl sessionFactory) {
            this.sessionFactory = sessionFactory;
            if (sessionFactory.getCurrentTenantIdentifierResolver() != null) {
                this.tenantIdentifier = sessionFactory.getCurrentTenantIdentifierResolver().resolveCurrentTenantIdentifier();
            }
        }

        @Override
        public StatelessSession openStatelessSession() {
            return new StatelessSessionImpl(this.connection, this.tenantIdentifier, this.sessionFactory, this.sessionFactory.settings.getRegionFactory().nextTimestamp());
        }

        @Override
        public StatelessSessionBuilder connection(Connection connection) {
            this.connection = connection;
            return this;
        }

        @Override
        public StatelessSessionBuilder tenantIdentifier(String tenantIdentifier) {
            this.tenantIdentifier = tenantIdentifier;
            return this;
        }
    }

    static class SessionBuilderImpl
    implements SessionBuilderImplementor {
        private static final Logger log = CoreLogging.logger(SessionBuilderImpl.class);
        private final SessionFactoryImpl sessionFactory;
        private SessionOwner sessionOwner;
        private Interceptor interceptor;
        private StatementInspector statementInspector;
        private Connection connection;
        private ConnectionReleaseMode connectionReleaseMode;
        private boolean autoClose;
        private boolean autoJoinTransactions = true;
        private boolean flushBeforeCompletion;
        private String tenantIdentifier;
        private List<SessionEventListener> listeners;

        SessionBuilderImpl(SessionFactoryImpl sessionFactory) {
            this.sessionFactory = sessionFactory;
            this.sessionOwner = null;
            Settings settings = sessionFactory.settings;
            this.interceptor = sessionFactory.getInterceptor();
            this.statementInspector = sessionFactory.getSessionFactoryOptions().getStatementInspector();
            this.connectionReleaseMode = settings.getConnectionReleaseMode();
            this.autoClose = settings.isAutoCloseSessionEnabled();
            this.flushBeforeCompletion = settings.isFlushBeforeCompletionEnabled();
            if (sessionFactory.getCurrentTenantIdentifierResolver() != null) {
                this.tenantIdentifier = sessionFactory.getCurrentTenantIdentifierResolver().resolveCurrentTenantIdentifier();
            }
            this.listeners = settings.getBaselineSessionEventsListenerBuilder().buildBaselineList();
        }

        protected TransactionCoordinator getTransactionCoordinator() {
            return null;
        }

        protected JdbcCoordinatorImpl getJdbcCoordinator() {
            return null;
        }

        protected Transaction getTransaction() {
            return null;
        }

        protected ActionQueue.TransactionCompletionProcesses getTransactionCompletionProcesses() {
            return null;
        }

        @Override
        public Session openSession() {
            log.tracef("Opening Hibernate Session.  tenant=%s, owner=%s", (Object)this.tenantIdentifier, (Object)this.sessionOwner);
            SessionImpl session = new SessionImpl(this.connection, this.sessionFactory, this.sessionOwner, this.getTransactionCoordinator(), this.getJdbcCoordinator(), this.getTransaction(), this.getTransactionCompletionProcesses(), this.autoJoinTransactions, this.sessionFactory.settings.getRegionFactory().nextTimestamp(), this.interceptor, this.statementInspector, this.flushBeforeCompletion, this.autoClose, this.connectionReleaseMode, this.tenantIdentifier);
            for (SessionEventListener listener : this.listeners) {
                session.getEventListenerManager().addListener(listener);
            }
            return session;
        }

        @Override
        public SessionBuilder owner(SessionOwner sessionOwner) {
            this.sessionOwner = sessionOwner;
            return this;
        }

        @Override
        public SessionBuilder interceptor(Interceptor interceptor) {
            this.interceptor = interceptor;
            return this;
        }

        @Override
        public SessionBuilder noInterceptor() {
            this.interceptor = EmptyInterceptor.INSTANCE;
            return this;
        }

        @Override
        public SessionBuilder statementInspector(StatementInspector statementInspector) {
            this.statementInspector = statementInspector;
            return this;
        }

        @Override
        public SessionBuilder connection(Connection connection) {
            this.connection = connection;
            return this;
        }

        @Override
        public SessionBuilder connectionReleaseMode(ConnectionReleaseMode connectionReleaseMode) {
            this.connectionReleaseMode = connectionReleaseMode;
            return this;
        }

        @Override
        public SessionBuilder autoJoinTransactions(boolean autoJoinTransactions) {
            this.autoJoinTransactions = autoJoinTransactions;
            return this;
        }

        @Override
        public SessionBuilder autoClose(boolean autoClose) {
            this.autoClose = autoClose;
            return this;
        }

        @Override
        public SessionBuilder flushBeforeCompletion(boolean flushBeforeCompletion) {
            this.flushBeforeCompletion = flushBeforeCompletion;
            return this;
        }

        @Override
        public SessionBuilder tenantIdentifier(String tenantIdentifier) {
            this.tenantIdentifier = tenantIdentifier;
            return this;
        }

        @Override
        public SessionBuilder eventListeners(SessionEventListener ... listeners) {
            Collections.addAll(this.listeners, listeners);
            return this;
        }

        @Override
        public SessionBuilder clearEventListeners() {
            this.listeners.clear();
            return this;
        }
    }
}

