/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.util.Comparator;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.type.Type;
import org.hibernate.type.VersionType;

public class CacheDataDescriptionImpl
implements CacheDataDescription {
    private final boolean mutable;
    private final boolean versioned;
    private final Comparator versionComparator;
    private final Type keyType;

    public CacheDataDescriptionImpl(boolean mutable, boolean versioned, Comparator versionComparator, Type keyType) {
        this.mutable = mutable;
        this.versioned = versioned;
        this.versionComparator = versionComparator;
        this.keyType = keyType;
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    @Override
    public boolean isVersioned() {
        return this.versioned;
    }

    @Override
    public Comparator getVersionComparator() {
        return this.versionComparator;
    }

    @Override
    public Type getKeyType() {
        return this.keyType;
    }

    public static CacheDataDescriptionImpl decode(PersistentClass model) {
        return new CacheDataDescriptionImpl(model.isMutable(), model.isVersioned(), model.isVersioned() ? ((VersionType)model.getVersion().getType()).getComparator() : null, model.getIdentifierProperty().getType());
    }

    public static CacheDataDescriptionImpl decode(Collection model) {
        return new CacheDataDescriptionImpl(model.isMutable(), model.getOwner().isVersioned(), model.getOwner().isVersioned() ? ((VersionType)model.getOwner().getVersion().getType()).getComparator() : null, model.getKey().getType());
    }
}

