/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.spi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javax.tools.JavaFileObject;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.enhance.internal.CompositeEnhancer;
import org.hibernate.bytecode.enhance.internal.EntityEnhancer;
import org.hibernate.bytecode.enhance.internal.FieldWriter;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementException;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedComposite;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;

public class Enhancer {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(Enhancer.class);
    protected final EnhancementContext enhancementContext;
    protected final ClassPool classPool;
    protected final CtClass managedEntityCtClass;
    protected final CtClass attributeInterceptorCtClass;
    protected final CtClass attributeInterceptableCtClass;
    protected final CtClass entityEntryCtClass;

    public Enhancer(EnhancementContext enhancementContext) {
        try {
            this.enhancementContext = enhancementContext;
            this.classPool = this.buildClassPool(enhancementContext);
            this.managedEntityCtClass = this.loadCtClassFromClass(this.classPool, ManagedEntity.class);
            this.attributeInterceptableCtClass = this.loadCtClassFromClass(this.classPool, PersistentAttributeInterceptable.class);
            this.attributeInterceptorCtClass = this.loadCtClassFromClass(this.classPool, PersistentAttributeInterceptor.class);
            this.entityEntryCtClass = this.loadCtClassFromClass(this.classPool, EntityEntry.class);
        }
        catch (IOException e) {
            throw new EnhancementException("Could not prepare Javassist ClassPool", e);
        }
    }

    public byte[] enhance(String className, byte[] originalBytes) throws EnhancementException {
        try {
            CtClass managedCtClass = this.classPool.makeClassIfNew((InputStream)new ByteArrayInputStream(originalBytes));
            this.enhance(managedCtClass);
            return this.getByteCode(managedCtClass);
        }
        catch (IOException e) {
            log.unableToBuildEnhancementMetamodel(className);
            return originalBytes;
        }
    }

    private ClassPool buildClassPool(EnhancementContext enhancementContext) {
        ClassPool classPool = new ClassPool(false);
        ClassLoader loadingClassLoader = enhancementContext.getLoadingClassLoader();
        if (loadingClassLoader != null) {
            classPool.appendClassPath((ClassPath)new LoaderClassPath(loadingClassLoader));
        }
        return classPool;
    }

    private CtClass loadCtClassFromClass(ClassPool cp, Class<?> aClass) throws IOException {
        return cp.makeClass(aClass.getClassLoader().getResourceAsStream(this.getFilenameForClass(aClass)));
    }

    private String getFilenameForClass(Class<?> aClass) {
        return aClass.getName().replace('.', File.separatorChar) + JavaFileObject.Kind.CLASS.extension;
    }

    private void enhance(CtClass managedCtClass) {
        if (managedCtClass.isInterface()) {
            log.debugf("Skipping enhancement of [%s]: it's an interface", managedCtClass);
            return;
        }
        for (String interfaceName : managedCtClass.getClassFile2().getInterfaces()) {
            if (!ManagedEntity.class.getName().equals(interfaceName) && !ManagedComposite.class.getName().equals(interfaceName)) continue;
            log.debugf("Skipping enhancement of [%s]: already enhanced", managedCtClass.getName());
            return;
        }
        if (this.enhancementContext.isEntityClass(managedCtClass)) {
            log.debugf("Enhancing [%s] as Entity", managedCtClass.getName());
            new EntityEnhancer(this.enhancementContext).enhance(managedCtClass);
        } else if (this.enhancementContext.isCompositeClass(managedCtClass)) {
            log.debugf("Enhancing [%s] as Composite", managedCtClass.getName());
            new CompositeEnhancer(this.enhancementContext).enhance(managedCtClass);
        } else {
            log.debug("Skipping enhancement: not entity or composite");
        }
    }

    private byte[] getByteCode(CtClass managedCtClass) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        try {
            managedCtClass.toBytecode(out);
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            log.unableToTransformClass(e.getMessage());
            throw new HibernateException("Unable to transform class: " + e.getMessage());
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void addInterceptorHandling(CtClass managedCtClass) {
        if (!this.enhancementContext.hasLazyLoadableAttributes(managedCtClass)) {
            return;
        }
        log.debugf("Weaving in PersistentAttributeInterceptable implementation on [%s]", managedCtClass.getName());
        managedCtClass.addInterface(this.attributeInterceptableCtClass);
        FieldWriter.addFieldWithGetterAndSetter(managedCtClass, this.attributeInterceptorCtClass, "$$_hibernate_attributeInterceptor", "$$_hibernate_getInterceptor", "$$_hibernate_setInterceptor");
    }

    @Deprecated
    public byte[] enhanceComposite(String className, byte[] originalBytes) throws EnhancementException {
        return this.enhance(className, originalBytes);
    }
}

