/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal;

import java.util.IdentityHashMap;
import java.util.LinkedList;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.stackmap.MapMaker;
import javax.persistence.Embedded;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.hibernate.bytecode.enhance.internal.AttributeTypeDescriptor;
import org.hibernate.bytecode.enhance.internal.MethodWriter;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementException;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.engine.spi.CompositeOwner;
import org.hibernate.engine.spi.CompositeTracker;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;

public class PersistentAttributesEnhancer
extends Enhancer {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(PersistentAttributesEnhancer.class);

    public PersistentAttributesEnhancer(EnhancementContext context) {
        super(context);
    }

    public void enhance(CtClass managedCtClass) {
        IdentityHashMap<String, PersistentAttributeAccessMethods> attrDescriptorMap = new IdentityHashMap<String, PersistentAttributeAccessMethods>();
        for (CtField persistentField : this.collectPersistentFields(managedCtClass)) {
            attrDescriptorMap.put(persistentField.getName(), this.enhancePersistentAttribute(managedCtClass, persistentField));
        }
        this.enhanceAttributesAccess(managedCtClass, attrDescriptorMap);
    }

    private CtField[] collectPersistentFields(CtClass managedCtClass) {
        LinkedList<CtField> persistentFieldList = new LinkedList<CtField>();
        for (CtField ctField : managedCtClass.getDeclaredFields()) {
            if (Modifier.isStatic((int)ctField.getModifiers()) || ctField.getName().startsWith("$$_hibernate_") || !this.enhancementContext.isPersistentField(ctField)) continue;
            persistentFieldList.add(ctField);
        }
        return this.enhancementContext.order(persistentFieldList.toArray(new CtField[persistentFieldList.size()]));
    }

    private PersistentAttributeAccessMethods enhancePersistentAttribute(CtClass managedCtClass, CtField persistentField) {
        try {
            AttributeTypeDescriptor typeDescriptor = AttributeTypeDescriptor.resolve(persistentField);
            return new PersistentAttributeAccessMethods(this.generateFieldReader(managedCtClass, persistentField, typeDescriptor), this.generateFieldWriter(managedCtClass, persistentField, typeDescriptor));
        }
        catch (Exception e) {
            String msg = String.format("Unable to enhance persistent attribute [%s:%s]", managedCtClass.getName(), persistentField.getName());
            throw new EnhancementException(msg, e);
        }
    }

    private CtMethod generateFieldReader(CtClass managedCtClass, CtField persistentField, AttributeTypeDescriptor typeDescriptor) {
        String fieldName = persistentField.getName();
        String readerName = "$$_hibernate_read_" + fieldName;
        if (!this.enhancementContext.isLazyLoadable(persistentField)) {
            return MethodWriter.addGetter(managedCtClass, fieldName, readerName);
        }
        try {
            return MethodWriter.write(managedCtClass, "public %s %s() {%n  %s%n  return this.%s;%n}", persistentField.getType().getName(), readerName, typeDescriptor.buildReadInterceptionBodyFragment(fieldName), fieldName);
        }
        catch (CannotCompileException cce) {
            String msg = String.format("Could not enhance entity class [%s] to add field reader method [%s]", managedCtClass.getName(), readerName);
            throw new EnhancementException(msg, cce);
        }
        catch (NotFoundException nfe) {
            String msg = String.format("Could not enhance entity class [%s] to add field reader method [%s]", managedCtClass.getName(), readerName);
            throw new EnhancementException(msg, nfe);
        }
    }

    private CtMethod generateFieldWriter(CtClass managedCtClass, CtField persistentField, AttributeTypeDescriptor typeDescriptor) {
        String fieldName = persistentField.getName();
        String writerName = "$$_hibernate_write_" + fieldName;
        try {
            CtMethod writer = !this.enhancementContext.isLazyLoadable(persistentField) ? MethodWriter.addSetter(managedCtClass, fieldName, writerName) : MethodWriter.write(managedCtClass, "public void %s(%s %s) {%n  %s%n}", writerName, persistentField.getType().getName(), fieldName, typeDescriptor.buildWriteInterceptionBodyFragment(fieldName));
            if (this.enhancementContext.isCompositeClass(managedCtClass)) {
                writer.insertBefore(String.format("if (%s != null) { %<s.callOwner(\".%s\"); }%n", "$$_hibernate_compositeOwners", fieldName));
            } else if (this.enhancementContext.doDirtyCheckingInline(managedCtClass)) {
                writer.insertBefore(typeDescriptor.buildInLineDirtyCheckingBodyFragment(this.enhancementContext, persistentField));
            }
            this.handleCompositeField(managedCtClass, persistentField, writer);
            if (this.enhancementContext.doBiDirectionalAssociationManagement(persistentField)) {
                this.handleBiDirectionalAssociation(managedCtClass, persistentField, writer);
            }
            return writer;
        }
        catch (CannotCompileException cce) {
            String msg = String.format("Could not enhance entity class [%s] to add field writer method [%s]", managedCtClass.getName(), writerName);
            throw new EnhancementException(msg, cce);
        }
        catch (NotFoundException nfe) {
            String msg = String.format("Could not enhance entity class [%s] to add field writer method [%s]", managedCtClass.getName(), writerName);
            throw new EnhancementException(msg, nfe);
        }
    }

    private void handleBiDirectionalAssociation(CtClass managedCtClass, CtField persistentField, CtMethod fieldWriter) throws NotFoundException, CannotCompileException {
        if (!this.isPossibleBiDirectionalAssociation(persistentField)) {
            return;
        }
        CtClass targetEntity = this.getTargetEntityClass(persistentField);
        if (targetEntity == null) {
            log.debugf("Could not find type of bi-directional association for field [%s#%s]", managedCtClass.getName(), persistentField.getName());
            return;
        }
        String mappedBy = this.getMappedBy(persistentField, targetEntity);
        if (mappedBy.isEmpty()) {
            log.warnf("Could not find bi-directional association for field [%s#%s]", managedCtClass.getName(), persistentField.getName());
            return;
        }
        String mappedByGetterName = "$$_hibernate_read_" + mappedBy;
        String mappedBySetterName = "$$_hibernate_write_" + mappedBy;
        MethodWriter.addGetter(targetEntity, mappedBy, mappedByGetterName);
        MethodWriter.addSetter(targetEntity, mappedBy, mappedBySetterName);
        if (persistentField.hasAnnotation(OneToOne.class)) {
            fieldWriter.insertBefore(String.format("if ($0.%s != null && $1 != null) $0.%<s.%s(null);%n", persistentField.getName(), mappedBySetterName));
            fieldWriter.insertAfter(String.format("if ($1 != null && $1.%s() != $0) $1.%s($0);%n", mappedByGetterName, mappedBySetterName));
        }
        if (persistentField.hasAnnotation(OneToMany.class)) {
            fieldWriter.insertBefore(String.format("if ($0.%s != null) { Object[] array = $0.%<s.toArray(); for (int i = 0; i < array.length; i++) { %s target = (%<s) array[i]; if ($1 == null || !$1.contains(target)) target.%s(null); } }%n", persistentField.getName(), targetEntity.getName(), mappedBySetterName));
            fieldWriter.insertAfter(String.format("if ($1 != null) { Object[] array = $1.toArray(); for (int i = 0; i < array.length; i++) { %s target = (%<s) array[i]; if (target.%s() != $0) target.%s((%s)$0); } }%n", targetEntity.getName(), mappedByGetterName, mappedBySetterName, managedCtClass.getName()));
        }
        if (persistentField.hasAnnotation(ManyToOne.class)) {
            fieldWriter.insertBefore(String.format("if ($0.%1$s != null && $0.%1$s.%2$s() != null) $0.%1$s.%2$s().remove($0);%n", persistentField.getName(), mappedByGetterName));
            fieldWriter.insertAfter(String.format("if ($1 != null) { java.util.Collection c = $1.%s(); if (c != null && !c.contains($0)) c.add($0); }%n", mappedByGetterName));
        }
        if (persistentField.hasAnnotation(ManyToMany.class)) {
            fieldWriter.insertBefore(String.format("if ($0.%s != null) { Object[] array = $0.%<s.toArray(); for (int i = 0; i < array.length; i++) { %s target = (%<s) array[i]; if ($1 == null || !$1.contains(target)) target.%s().remove($0); } }%n", persistentField.getName(), targetEntity.getName(), mappedByGetterName));
            fieldWriter.insertAfter(String.format("if ($1 != null) { Object[] array = $1.toArray(); for (int i = 0; i < array.length; i++) { %s target = (%<s) array[i]; java.util.Collection c = target.%s(); if ( c != $0 && c != null) c.add($0); } }%n", targetEntity.getName(), mappedByGetterName));
        }
    }

    private boolean isPossibleBiDirectionalAssociation(CtField persistentField) {
        return persistentField.hasAnnotation(OneToOne.class) || persistentField.hasAnnotation(OneToMany.class) || persistentField.hasAnnotation(ManyToOne.class) || persistentField.hasAnnotation(ManyToMany.class);
    }

    private String getMappedBy(CtField persistentField, CtClass targetEntity) {
        String local = this.getMappedByFromAnnotation(persistentField);
        return local.isEmpty() ? this.getMappedByFromTargetEntity(persistentField, targetEntity) : local;
    }

    private String getMappedByFromAnnotation(CtField persistentField) {
        try {
            if (persistentField.hasAnnotation(OneToOne.class)) {
                return ((OneToOne)persistentField.getAnnotation(OneToOne.class)).mappedBy();
            }
            if (persistentField.hasAnnotation(OneToMany.class)) {
                return ((OneToMany)persistentField.getAnnotation(OneToMany.class)).mappedBy();
            }
            if (persistentField.hasAnnotation(ManyToMany.class)) {
                return ((ManyToMany)persistentField.getAnnotation(ManyToMany.class)).mappedBy();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return "";
    }

    private String getMappedByFromTargetEntity(CtField persistentField, CtClass targetEntity) {
        for (CtField f : targetEntity.getDeclaredFields()) {
            if (!this.enhancementContext.isPersistentField(f) || !this.getMappedByFromAnnotation(f).equals(persistentField.getName())) continue;
            log.debugf("mappedBy association for field [%s:%s] is [%s:%s]", new Object[]{persistentField.getDeclaringClass().getName(), persistentField.getName(), targetEntity.getName(), f.getName()});
            return f.getName();
        }
        return "";
    }

    private CtClass getTargetEntityClass(CtField persistentField) throws NotFoundException {
        try {
            Class targetClass = null;
            if (persistentField.hasAnnotation(OneToOne.class)) {
                targetClass = ((OneToOne)persistentField.getAnnotation(OneToOne.class)).targetEntity();
            }
            if (persistentField.hasAnnotation(OneToMany.class)) {
                targetClass = ((OneToMany)persistentField.getAnnotation(OneToMany.class)).targetEntity();
            }
            if (persistentField.hasAnnotation(ManyToOne.class)) {
                targetClass = ((ManyToOne)persistentField.getAnnotation(ManyToOne.class)).targetEntity();
            }
            if (persistentField.hasAnnotation(ManyToMany.class)) {
                targetClass = ((ManyToMany)persistentField.getAnnotation(ManyToMany.class)).targetEntity();
            }
            if (targetClass != null && targetClass != Void.TYPE) {
                return this.classPool.get(targetClass.getName());
            }
        }
        catch (ClassNotFoundException targetClass) {
            // empty catch block
        }
        if (persistentField.hasAnnotation(OneToOne.class) || persistentField.hasAnnotation(ManyToOne.class)) {
            return persistentField.getType();
        }
        if (persistentField.hasAnnotation(OneToMany.class) || persistentField.hasAnnotation(ManyToMany.class)) {
            try {
                SignatureAttribute.TypeArgument target = ((SignatureAttribute.ClassType)SignatureAttribute.toFieldSignature((String)persistentField.getGenericSignature())).getTypeArguments()[0];
                return persistentField.getDeclaringClass().getClassPool().get(target.toString());
            }
            catch (BadBytecode badBytecode) {
                // empty catch block
            }
        }
        return null;
    }

    private void handleCompositeField(CtClass managedCtClass, CtField persistentField, CtMethod fieldWriter) throws NotFoundException, CannotCompileException {
        if (!persistentField.hasAnnotation(Embedded.class)) {
            return;
        }
        managedCtClass.addInterface(this.classPool.get(CompositeOwner.class.getName()));
        if (this.enhancementContext.isCompositeClass(managedCtClass)) {
            MethodWriter.write(managedCtClass, "public void %1$s(String name) {%n  if (%2$s != null) { %2$s.callOwner(\".\" + name) ; }%n}", "$$_hibernate_trackChange", "$$_hibernate_compositeOwners");
        }
        fieldWriter.insertBefore(String.format("if (%1$s != null) { ((%2$s) %1$s).%3$s(\"%1$s\"); }%n", persistentField.getName(), CompositeTracker.class.getName(), "$$_hibernate_clearOwner"));
        fieldWriter.insertAfter(String.format("((%2$s) %1$s).%4$s(\"%1$s\", (%3$s) this);%n%5$s(\"%1$s\");", persistentField.getName(), CompositeTracker.class.getName(), CompositeOwner.class.getName(), "$$_hibernate_setOwner", "$$_hibernate_trackChange"));
    }

    protected void enhanceAttributesAccess(CtClass managedCtClass, IdentityHashMap<String, PersistentAttributeAccessMethods> attributeDescriptorMap) {
        ConstPool constPool = managedCtClass.getClassFile().getConstPool();
        for (Object oMethod : managedCtClass.getClassFile().getMethods()) {
            MethodInfo methodInfo = (MethodInfo)oMethod;
            String methodName = methodInfo.getName();
            if (methodName.startsWith("$$_hibernate_") || methodInfo.getCodeAttribute() == null) continue;
            try {
                CodeIterator itr = methodInfo.getCodeAttribute().iterator();
                while (itr.hasNext()) {
                    int methodIndex;
                    String fieldName;
                    PersistentAttributeAccessMethods attributeMethods;
                    int index = itr.next();
                    int op = itr.byteAt(index);
                    if (op != 181 && op != 180 || (attributeMethods = attributeDescriptorMap.get(fieldName = constPool.getFieldrefName(itr.u16bitAt(index + 1)))) == null) continue;
                    log.debugf("Transforming access to field [%s] from method [%s]", fieldName, methodName);
                    if (op == 180) {
                        methodIndex = MethodWriter.addMethod(constPool, attributeMethods.getReader());
                        itr.writeByte(183, index);
                        itr.write16bit(methodIndex, index + 1);
                        continue;
                    }
                    methodIndex = MethodWriter.addMethod(constPool, attributeMethods.getWriter());
                    itr.writeByte(183, index);
                    itr.write16bit(methodIndex, index + 1);
                }
                methodInfo.getCodeAttribute().setAttribute(MapMaker.make((ClassPool)this.classPool, (MethodInfo)methodInfo));
            }
            catch (BadBytecode bb) {
                String msg = String.format("Unable to perform field access transformation in method [%s]", methodName);
                throw new EnhancementException(msg, bb);
            }
        }
    }

    private static class PersistentAttributeAccessMethods {
        private final CtMethod reader;
        private final CtMethod writer;

        private PersistentAttributeAccessMethods(CtMethod reader, CtMethod writer) {
            this.reader = reader;
            this.writer = writer;
        }

        private CtMethod getReader() {
            return this.reader;
        }

        private CtMethod getWriter() {
            return this.writer;
        }
    }
}

