/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.NotFoundException;
import org.hibernate.bytecode.enhance.internal.FieldWriter;
import org.hibernate.bytecode.enhance.internal.MethodWriter;
import org.hibernate.bytecode.enhance.internal.PersistentAttributesEnhancer;
import org.hibernate.bytecode.enhance.internal.tracker.CompositeOwnerTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.engine.spi.CompositeOwner;
import org.hibernate.engine.spi.CompositeTracker;

public class CompositeEnhancer
extends Enhancer {
    public CompositeEnhancer(EnhancementContext context) {
        super(context);
    }

    public void enhance(CtClass managedCtClass) {
        this.addInterceptorHandling(managedCtClass);
        if (this.enhancementContext.doDirtyCheckingInline(managedCtClass)) {
            this.addInLineDirtyHandling(managedCtClass);
        }
        new PersistentAttributesEnhancer(this.enhancementContext).enhance(managedCtClass);
    }

    private void addInLineDirtyHandling(CtClass managedCtClass) {
        try {
            managedCtClass.addInterface(this.classPool.get(CompositeTracker.class.getName()));
            CtClass compositeCtType = this.classPool.get(CompositeOwnerTracker.class.getName());
            FieldWriter.addField(managedCtClass, compositeCtType, "$$_hibernate_compositeOwners");
            this.createCompositeTrackerMethod(managedCtClass);
        }
        catch (NotFoundException nfe) {
            nfe.printStackTrace();
        }
    }

    private void createCompositeTrackerMethod(CtClass managedCtClass) {
        try {
            MethodWriter.write(managedCtClass, "public void %1$s(String name, %3$s tracker) {%n  if (%2$s == null) { %2$s = new %4$s(); }%n  %2$s.add(name, tracker);%n}", "$$_hibernate_setOwner", "$$_hibernate_compositeOwners", CompositeOwner.class.getName(), CompositeOwnerTracker.class.getName());
            MethodWriter.write(managedCtClass, "public void %1$s(String name) {%n  if (%2$s != null) { %2$s.removeOwner(name); }%n}", "$$_hibernate_clearOwner", "$$_hibernate_compositeOwners");
        }
        catch (CannotCompileException cce) {
            cce.printStackTrace();
        }
    }
}

