/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.query.spi.ParameterMetadata;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryConstructorReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryJoinReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryRootReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryScalarReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.internal.AbstractQueryImpl;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.type.Type;

public class SQLQueryImpl
extends AbstractQueryImpl
implements SQLQuery {
    private List<NativeSQLQueryReturn> queryReturns;
    private List<ReturnBuilder> queryReturnBuilders;
    private boolean autoDiscoverTypes;
    private Collection<String> querySpaces;
    private final boolean callable;
    private final LockOptions lockOptions = new LockOptions();

    SQLQueryImpl(NamedSQLQueryDefinition queryDef, SessionImplementor session, ParameterMetadata parameterMetadata) {
        super(queryDef.getQueryString(), queryDef.getFlushMode(), session, parameterMetadata);
        if (queryDef.getResultSetRef() != null) {
            ResultSetMappingDefinition definition = session.getFactory().getResultSetMapping(queryDef.getResultSetRef());
            if (definition == null) {
                throw new MappingException("Unable to find resultset-ref definition: " + queryDef.getResultSetRef());
            }
            this.queryReturns = Arrays.asList(definition.getQueryReturns());
        } else {
            this.queryReturns = queryDef.getQueryReturns() != null && queryDef.getQueryReturns().length > 0 ? Arrays.asList(queryDef.getQueryReturns()) : new ArrayList<NativeSQLQueryReturn>();
        }
        this.querySpaces = queryDef.getQuerySpaces();
        this.callable = queryDef.isCallable();
    }

    SQLQueryImpl(String sql, SessionImplementor session, ParameterMetadata parameterMetadata) {
        this(sql, false, session, parameterMetadata);
    }

    SQLQueryImpl(String sql, boolean callable, SessionImplementor session, ParameterMetadata parameterMetadata) {
        super(sql, null, session, parameterMetadata);
        this.queryReturns = new ArrayList<NativeSQLQueryReturn>();
        this.querySpaces = null;
        this.callable = callable;
    }

    @Override
    public List<NativeSQLQueryReturn> getQueryReturns() {
        this.prepareQueryReturnsIfNecessary();
        return this.queryReturns;
    }

    @Override
    public Collection<String> getSynchronizedQuerySpaces() {
        return this.querySpaces;
    }

    @Override
    public boolean isCallable() {
        return this.callable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List list() throws HibernateException {
        this.verifyParameters();
        this.before();
        Map<String, TypedValue> namedParams = this.getNamedParams();
        NativeSQLQuerySpecification spec = this.generateQuerySpecification(namedParams);
        try {
            List list = this.getSession().list(spec, this.getQueryParameters(namedParams));
            return list;
        }
        finally {
            this.after();
        }
    }

    private NativeSQLQuerySpecification generateQuerySpecification(Map namedParams) {
        return new NativeSQLQuerySpecification(this.expandParameterLists(namedParams), this.queryReturns.toArray(new NativeSQLQueryReturn[this.queryReturns.size()]), this.querySpaces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScrollableResults scroll(ScrollMode scrollMode) throws HibernateException {
        this.verifyParameters();
        this.before();
        Map<String, TypedValue> namedParams = this.getNamedParams();
        NativeSQLQuerySpecification spec = this.generateQuerySpecification(namedParams);
        QueryParameters qp = this.getQueryParameters(namedParams);
        qp.setScrollMode(scrollMode);
        try {
            ScrollableResults scrollableResults = this.getSession().scroll(spec, qp);
            return scrollableResults;
        }
        finally {
            this.after();
        }
    }

    @Override
    public ScrollableResults scroll() throws HibernateException {
        return this.scroll(this.session.getFactory().getDialect().defaultScrollMode());
    }

    @Override
    public Iterator iterate() throws HibernateException {
        throw new UnsupportedOperationException("SQL queries do not currently support iteration");
    }

    @Override
    public QueryParameters getQueryParameters(Map namedParams) {
        QueryParameters qp = super.getQueryParameters(namedParams);
        qp.setCallable(this.callable);
        qp.setAutoDiscoverScalarTypes(this.autoDiscoverTypes);
        return qp;
    }

    @Override
    protected void verifyParameters() {
        boolean noReturns;
        this.prepareQueryReturnsIfNecessary();
        this.verifyParameters(this.callable);
        boolean bl = noReturns = this.queryReturns == null || this.queryReturns.isEmpty();
        if (noReturns) {
            this.autoDiscoverTypes = noReturns;
        } else {
            for (NativeSQLQueryReturn queryReturn : this.queryReturns) {
                if (queryReturn instanceof NativeSQLQueryScalarReturn) {
                    NativeSQLQueryScalarReturn scalar = (NativeSQLQueryScalarReturn)queryReturn;
                    if (scalar.getType() != null) continue;
                    this.autoDiscoverTypes = true;
                    break;
                }
                if (!NativeSQLQueryConstructorReturn.class.isInstance(queryReturn)) continue;
                this.autoDiscoverTypes = true;
                break;
            }
        }
    }

    private void prepareQueryReturnsIfNecessary() {
        if (this.queryReturnBuilders != null) {
            if (!this.queryReturnBuilders.isEmpty()) {
                if (this.queryReturns != null) {
                    this.queryReturns.clear();
                    this.queryReturns = null;
                }
                this.queryReturns = new ArrayList<NativeSQLQueryReturn>();
                for (ReturnBuilder builder : this.queryReturnBuilders) {
                    this.queryReturns.add(builder.buildReturn());
                }
                this.queryReturnBuilders.clear();
            }
            this.queryReturnBuilders = null;
        }
    }

    @Override
    public String[] getReturnAliases() throws HibernateException {
        throw new UnsupportedOperationException("SQL queries do not currently support returning aliases");
    }

    @Override
    public Type[] getReturnTypes() throws HibernateException {
        throw new UnsupportedOperationException("not yet implemented for SQL queries");
    }

    @Override
    public Query setLockMode(String alias, LockMode lockMode) {
        throw new UnsupportedOperationException("cannot set the lock mode for a native SQL query");
    }

    @Override
    public Query setLockOptions(LockOptions lockOptions) {
        throw new UnsupportedOperationException("cannot set lock options for a native SQL query");
    }

    @Override
    public LockOptions getLockOptions() {
        return this.lockOptions;
    }

    @Override
    public SQLQuery addScalar(final String columnAlias, final Type type) {
        if (this.queryReturnBuilders == null) {
            this.queryReturnBuilders = new ArrayList<ReturnBuilder>();
        }
        this.queryReturnBuilders.add(new ReturnBuilder(){

            @Override
            public NativeSQLQueryReturn buildReturn() {
                return new NativeSQLQueryScalarReturn(columnAlias, type);
            }
        });
        return this;
    }

    @Override
    public SQLQuery addScalar(String columnAlias) {
        return this.addScalar(columnAlias, null);
    }

    @Override
    public SQLQuery.RootReturn addRoot(String tableAlias, String entityName) {
        RootReturnBuilder builder = new RootReturnBuilder(tableAlias, entityName);
        if (this.queryReturnBuilders == null) {
            this.queryReturnBuilders = new ArrayList<ReturnBuilder>();
        }
        this.queryReturnBuilders.add(builder);
        return builder;
    }

    @Override
    public SQLQuery.RootReturn addRoot(String tableAlias, Class entityType) {
        return this.addRoot(tableAlias, entityType.getName());
    }

    @Override
    public SQLQuery addEntity(String entityName) {
        return this.addEntity(StringHelper.unqualify(entityName), entityName);
    }

    @Override
    public SQLQuery addEntity(String alias, String entityName) {
        this.addRoot(alias, entityName);
        return this;
    }

    @Override
    public SQLQuery addEntity(String alias, String entityName, LockMode lockMode) {
        this.addRoot(alias, entityName).setLockMode(lockMode);
        return this;
    }

    @Override
    public SQLQuery addEntity(Class entityType) {
        return this.addEntity(entityType.getName());
    }

    @Override
    public SQLQuery addEntity(String alias, Class entityClass) {
        return this.addEntity(alias, entityClass.getName());
    }

    @Override
    public SQLQuery addEntity(String alias, Class entityClass, LockMode lockMode) {
        return this.addEntity(alias, entityClass.getName(), lockMode);
    }

    @Override
    public SQLQuery.FetchReturn addFetch(String tableAlias, String ownerTableAlias, String joinPropertyName) {
        FetchReturnBuilder builder = new FetchReturnBuilder(tableAlias, ownerTableAlias, joinPropertyName);
        if (this.queryReturnBuilders == null) {
            this.queryReturnBuilders = new ArrayList<ReturnBuilder>();
        }
        this.queryReturnBuilders.add(builder);
        return builder;
    }

    @Override
    public SQLQuery addJoin(String tableAlias, String ownerTableAlias, String joinPropertyName) {
        this.addFetch(tableAlias, ownerTableAlias, joinPropertyName);
        return this;
    }

    @Override
    public SQLQuery addJoin(String alias, String path) {
        this.createFetchJoin(alias, path);
        return this;
    }

    private SQLQuery.FetchReturn createFetchJoin(String tableAlias, String path) {
        int loc = path.indexOf(46);
        if (loc < 0) {
            throw new QueryException("not a property path: " + path);
        }
        String ownerTableAlias = path.substring(0, loc);
        String joinedPropertyName = path.substring(loc + 1);
        return this.addFetch(tableAlias, ownerTableAlias, joinedPropertyName);
    }

    @Override
    public SQLQuery addJoin(String alias, String path, LockMode lockMode) {
        this.createFetchJoin(alias, path).setLockMode(lockMode);
        return this;
    }

    @Override
    public SQLQuery setResultSetMapping(String name) {
        ResultSetMappingDefinition mapping = this.session.getFactory().getResultSetMapping(name);
        if (mapping == null) {
            throw new MappingException("Unknown SqlResultSetMapping [" + name + "]");
        }
        NativeSQLQueryReturn[] returns = mapping.getQueryReturns();
        this.queryReturns.addAll(Arrays.asList(returns));
        return this;
    }

    @Override
    public SQLQuery addSynchronizedQuerySpace(String querySpace) {
        if (this.querySpaces == null) {
            this.querySpaces = new ArrayList<String>();
        }
        this.querySpaces.add(querySpace);
        return this;
    }

    @Override
    public SQLQuery addSynchronizedEntityName(String entityName) {
        return this.addQuerySpaces(this.getSession().getFactory().getEntityPersister(entityName).getQuerySpaces());
    }

    @Override
    public SQLQuery addSynchronizedEntityClass(Class entityClass) {
        return this.addQuerySpaces(this.getSession().getFactory().getEntityPersister(entityClass.getName()).getQuerySpaces());
    }

    private SQLQuery addQuerySpaces(Serializable[] spaces) {
        if (spaces != null) {
            if (this.querySpaces == null) {
                this.querySpaces = new ArrayList<String>();
            }
            this.querySpaces.addAll(Arrays.asList((String[])spaces));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws HibernateException {
        Map<String, TypedValue> namedParams = this.getNamedParams();
        this.before();
        try {
            int n = this.getSession().executeNativeUpdate(this.generateQuerySpecification(namedParams), this.getQueryParameters(namedParams));
            return n;
        }
        finally {
            this.after();
        }
    }

    private static interface ReturnBuilder {
        public NativeSQLQueryReturn buildReturn();
    }

    private class FetchReturnBuilder
    implements SQLQuery.FetchReturn,
    ReturnBuilder {
        private final String alias;
        private String ownerTableAlias;
        private final String joinedPropertyName;
        private LockMode lockMode = LockMode.READ;
        private Map<String, String[]> propertyMappings;

        private FetchReturnBuilder(String alias, String ownerTableAlias, String joinedPropertyName) {
            this.alias = alias;
            this.ownerTableAlias = ownerTableAlias;
            this.joinedPropertyName = joinedPropertyName;
        }

        @Override
        public SQLQuery.FetchReturn setLockMode(LockMode lockMode) {
            this.lockMode = lockMode;
            return this;
        }

        @Override
        public SQLQuery.FetchReturn addProperty(String propertyName, String columnAlias) {
            this.addProperty(propertyName).addColumnAlias(columnAlias);
            return this;
        }

        @Override
        public SQLQuery.ReturnProperty addProperty(final String propertyName) {
            if (this.propertyMappings == null) {
                this.propertyMappings = new HashMap<String, String[]>();
            }
            return new SQLQuery.ReturnProperty(){

                @Override
                public SQLQuery.ReturnProperty addColumnAlias(String columnAlias) {
                    String[] columnAliases = (String[])FetchReturnBuilder.this.propertyMappings.get(propertyName);
                    if (columnAliases == null) {
                        columnAliases = new String[]{columnAlias};
                    } else {
                        String[] newColumnAliases = new String[columnAliases.length + 1];
                        System.arraycopy(columnAliases, 0, newColumnAliases, 0, columnAliases.length);
                        newColumnAliases[columnAliases.length] = columnAlias;
                        columnAliases = newColumnAliases;
                    }
                    FetchReturnBuilder.this.propertyMappings.put(propertyName, columnAliases);
                    return this;
                }
            };
        }

        @Override
        public NativeSQLQueryReturn buildReturn() {
            return new NativeSQLQueryJoinReturn(this.alias, this.ownerTableAlias, this.joinedPropertyName, this.propertyMappings, this.lockMode);
        }
    }

    private class RootReturnBuilder
    implements SQLQuery.RootReturn,
    ReturnBuilder {
        private final String alias;
        private final String entityName;
        private LockMode lockMode = LockMode.READ;
        private Map<String, String[]> propertyMappings;

        private RootReturnBuilder(String alias, String entityName) {
            this.alias = alias;
            this.entityName = entityName;
        }

        @Override
        public SQLQuery.RootReturn setLockMode(LockMode lockMode) {
            this.lockMode = lockMode;
            return this;
        }

        @Override
        public SQLQuery.RootReturn setDiscriminatorAlias(String alias) {
            this.addProperty("class", alias);
            return this;
        }

        @Override
        public SQLQuery.RootReturn addProperty(String propertyName, String columnAlias) {
            this.addProperty(propertyName).addColumnAlias(columnAlias);
            return this;
        }

        @Override
        public SQLQuery.ReturnProperty addProperty(final String propertyName) {
            if (this.propertyMappings == null) {
                this.propertyMappings = new HashMap<String, String[]>();
            }
            return new SQLQuery.ReturnProperty(){

                @Override
                public SQLQuery.ReturnProperty addColumnAlias(String columnAlias) {
                    String[] columnAliases = (String[])RootReturnBuilder.this.propertyMappings.get(propertyName);
                    if (columnAliases == null) {
                        columnAliases = new String[]{columnAlias};
                    } else {
                        String[] newColumnAliases = new String[columnAliases.length + 1];
                        System.arraycopy(columnAliases, 0, newColumnAliases, 0, columnAliases.length);
                        newColumnAliases[columnAliases.length] = columnAlias;
                        columnAliases = newColumnAliases;
                    }
                    RootReturnBuilder.this.propertyMappings.put(propertyName, columnAliases);
                    return this;
                }
            };
        }

        @Override
        public NativeSQLQueryReturn buildReturn() {
            return new NativeSQLQueryRootReturn(this.alias, this.entityName, this.propertyMappings, this.lockMode);
        }
    }
}

