/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.exec.process.spi;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.engine.internal.TwoPhaseLoad;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.plan.exec.process.internal.HydratedEntityRegistration;
import org.hibernate.loader.plan.exec.process.internal.ResultSetProcessingContextImpl;
import org.hibernate.loader.plan.exec.process.spi.CollectionReferenceInitializer;
import org.hibernate.loader.plan.exec.process.spi.EntityReferenceInitializer;
import org.hibernate.loader.plan.exec.process.spi.ReaderCollector;
import org.hibernate.loader.plan.exec.process.spi.RowReader;
import org.hibernate.loader.plan.spi.BidirectionalEntityReference;
import org.hibernate.loader.plan.spi.CompositeFetch;
import org.hibernate.loader.plan.spi.EntityFetch;
import org.hibernate.loader.plan.spi.EntityIdentifierDescription;
import org.hibernate.loader.plan.spi.EntityReference;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.plan.spi.FetchSource;
import org.hibernate.loader.spi.AfterLoadAction;
import org.hibernate.persister.entity.Loadable;
import org.jboss.logging.Logger;

public abstract class AbstractRowReader
implements RowReader {
    private static final Logger log = CoreLogging.logger(AbstractRowReader.class);
    private final List<EntityReferenceInitializer> entityReferenceInitializers;
    private final List<CollectionReferenceInitializer> arrayReferenceInitializers;
    private final List<CollectionReferenceInitializer> collectionReferenceInitializers;

    public AbstractRowReader(ReaderCollector readerCollector) {
        this.entityReferenceInitializers = readerCollector.getEntityReferenceInitializers() != null ? new ArrayList<EntityReferenceInitializer>(readerCollector.getEntityReferenceInitializers()) : Collections.emptyList();
        this.arrayReferenceInitializers = readerCollector.getArrayReferenceInitializers() != null ? new ArrayList<CollectionReferenceInitializer>(readerCollector.getArrayReferenceInitializers()) : Collections.emptyList();
        this.collectionReferenceInitializers = readerCollector.getNonArrayCollectionReferenceInitializers() != null ? new ArrayList<CollectionReferenceInitializer>(readerCollector.getNonArrayCollectionReferenceInitializers()) : Collections.emptyList();
    }

    protected abstract Object readLogicalRow(ResultSet var1, ResultSetProcessingContextImpl var2) throws SQLException;

    @Override
    public Object readRow(ResultSet resultSet, ResultSetProcessingContextImpl context) throws SQLException {
        boolean hasEntityReferenceInitializers = CollectionHelper.isNotEmpty(this.entityReferenceInitializers);
        if (hasEntityReferenceInitializers) {
            for (EntityReferenceInitializer entityReferenceInitializer : this.entityReferenceInitializers) {
                entityReferenceInitializer.hydrateIdentifier(resultSet, context);
            }
            HashMap<EntityReference, EntityReferenceInitializer> initializerByEntityReference = new HashMap<EntityReference, EntityReferenceInitializer>(this.entityReferenceInitializers.size());
            for (EntityReferenceInitializer entityReferenceInitializerFromMap : this.entityReferenceInitializers) {
                initializerByEntityReference.put(entityReferenceInitializerFromMap.getEntityReference(), entityReferenceInitializerFromMap);
            }
            for (EntityReferenceInitializer entityReferenceInitializer : this.entityReferenceInitializers) {
                this.resolveEntityKey(resultSet, context, entityReferenceInitializer, initializerByEntityReference);
            }
            for (EntityReferenceInitializer entityReferenceInitializer : this.entityReferenceInitializers) {
                entityReferenceInitializer.hydrateEntityState(resultSet, context);
            }
        }
        Object logicalRow = this.readLogicalRow(resultSet, context);
        if (hasEntityReferenceInitializers) {
            for (EntityReferenceInitializer entityReferenceInitializer : this.entityReferenceInitializers) {
                entityReferenceInitializer.finishUpRow(resultSet, context);
            }
        }
        if (this.collectionReferenceInitializers != null) {
            for (CollectionReferenceInitializer collectionReferenceInitializer : this.collectionReferenceInitializers) {
                collectionReferenceInitializer.finishUpRow(resultSet, context);
            }
        }
        if (this.arrayReferenceInitializers != null) {
            for (CollectionReferenceInitializer arrayReferenceInitializer : this.arrayReferenceInitializers) {
                arrayReferenceInitializer.finishUpRow(resultSet, context);
            }
        }
        return logicalRow;
    }

    private void resolveEntityKey(ResultSet resultSet, ResultSetProcessingContextImpl context, EntityReferenceInitializer entityReferenceInitializer, Map<EntityReference, EntityReferenceInitializer> initializerByEntityReference) throws SQLException {
        EntityReference entityReference = entityReferenceInitializer.getEntityReference();
        EntityIdentifierDescription identifierDescription = entityReference.getIdentifierDescription();
        if (identifierDescription.hasFetches() || identifierDescription.hasBidirectionalEntityReferences()) {
            this.resolveEntityKey(resultSet, context, (FetchSource)((Object)identifierDescription), initializerByEntityReference);
        }
        entityReferenceInitializer.resolveEntityKey(resultSet, context);
    }

    private void resolveEntityKey(ResultSet resultSet, ResultSetProcessingContextImpl context, FetchSource fetchSource, Map<EntityReference, EntityReferenceInitializer> initializerByEntityReference) throws SQLException {
        for (BidirectionalEntityReference bidirectionalEntityReference : fetchSource.getBidirectionalEntityReferences()) {
            EntityReferenceInitializer targetEntityReferenceInitializer = initializerByEntityReference.get(bidirectionalEntityReference.getTargetEntityReference());
            this.resolveEntityKey(resultSet, context, targetEntityReferenceInitializer, initializerByEntityReference);
            targetEntityReferenceInitializer.hydrateEntityState(resultSet, context);
        }
        for (Fetch fetch : fetchSource.getFetches()) {
            if (EntityFetch.class.isInstance(fetch)) {
                EntityFetch entityFetch = (EntityFetch)fetch;
                EntityReferenceInitializer entityReferenceInitializer = initializerByEntityReference.get(entityFetch);
                if (entityReferenceInitializer == null) continue;
                this.resolveEntityKey(resultSet, context, entityReferenceInitializer, initializerByEntityReference);
                entityReferenceInitializer.hydrateEntityState(resultSet, context);
                continue;
            }
            if (!CompositeFetch.class.isInstance(fetch)) continue;
            this.resolveEntityKey(resultSet, context, (CompositeFetch)fetch, initializerByEntityReference);
        }
    }

    @Override
    public void finishUp(ResultSetProcessingContextImpl context, List<AfterLoadAction> afterLoadActionList) {
        PostLoadEvent postLoadEvent;
        PreLoadEvent preLoadEvent;
        List<HydratedEntityRegistration> hydratedEntityRegistrations = context.getHydratedEntityRegistrationList();
        this.finishLoadingArrays(context);
        if (context.getSession().isEventSource()) {
            preLoadEvent = new PreLoadEvent((EventSource)context.getSession());
            postLoadEvent = new PostLoadEvent((EventSource)context.getSession());
        } else {
            preLoadEvent = null;
            postLoadEvent = null;
        }
        this.performTwoPhaseLoad(preLoadEvent, context, hydratedEntityRegistrations);
        this.finishLoadingCollections(context);
        this.postLoad(postLoadEvent, context, hydratedEntityRegistrations, afterLoadActionList);
    }

    private void finishLoadingArrays(ResultSetProcessingContextImpl context) {
        for (CollectionReferenceInitializer arrayReferenceInitializer : this.arrayReferenceInitializers) {
            arrayReferenceInitializer.endLoading(context);
        }
    }

    private void performTwoPhaseLoad(PreLoadEvent preLoadEvent, ResultSetProcessingContextImpl context, List<HydratedEntityRegistration> hydratedEntityRegistrations) {
        int numberOfHydratedObjects = hydratedEntityRegistrations == null ? 0 : hydratedEntityRegistrations.size();
        log.tracev("Total objects hydrated: {0}", (Object)numberOfHydratedObjects);
        if (hydratedEntityRegistrations == null) {
            return;
        }
        for (HydratedEntityRegistration registration : hydratedEntityRegistrations) {
            TwoPhaseLoad.initializeEntity(registration.getInstance(), context.isReadOnly(), context.getSession(), preLoadEvent);
        }
    }

    private void finishLoadingCollections(ResultSetProcessingContextImpl context) {
        for (CollectionReferenceInitializer collectionReferenceInitializer : this.collectionReferenceInitializers) {
            collectionReferenceInitializer.endLoading(context);
        }
    }

    private void postLoad(PostLoadEvent postLoadEvent, ResultSetProcessingContextImpl context, List<HydratedEntityRegistration> hydratedEntityRegistrations, List<AfterLoadAction> afterLoadActionList) {
        if (hydratedEntityRegistrations == null) {
            return;
        }
        for (HydratedEntityRegistration registration : hydratedEntityRegistrations) {
            TwoPhaseLoad.postLoad(registration.getInstance(), context.getSession(), postLoadEvent);
            if (afterLoadActionList == null) continue;
            for (AfterLoadAction afterLoadAction : afterLoadActionList) {
                afterLoadAction.afterLoad(context.getSession(), registration.getInstance(), (Loadable)registration.getEntityReference().getEntityPersister());
            }
        }
    }
}

