/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.internal;

import java.util.Map;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.engine.transaction.internal.jdbc.JdbcTransactionFactory;
import org.hibernate.engine.transaction.spi.TransactionFactory;
import org.hibernate.engine.transaction.spi.TransactionImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.logging.Logger;

public class TransactionFactoryInitiator<T extends TransactionImplementor>
implements StandardServiceInitiator<TransactionFactory> {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)TransactionFactoryInitiator.class.getName());
    public static final TransactionFactoryInitiator INSTANCE = new TransactionFactoryInitiator();

    @Override
    public Class<TransactionFactory> getServiceInitiated() {
        return TransactionFactory.class;
    }

    @Override
    public TransactionFactory initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        Object strategy = configurationValues.get("hibernate.transaction.factory_class");
        if (strategy == null) {
            LOG.usingDefaultTransactionStrategy();
            return new JdbcTransactionFactory();
        }
        return registry.getService(StrategySelector.class).resolveStrategy(TransactionFactory.class, strategy);
    }
}

