/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.walking.spi;

import java.util.HashSet;
import java.util.Set;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.PropertyPath;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.walking.spi.AssociationAttributeDefinition;
import org.hibernate.persister.walking.spi.AssociationKey;
import org.hibernate.persister.walking.spi.AssociationVisitationStrategy;
import org.hibernate.persister.walking.spi.AttributeDefinition;
import org.hibernate.persister.walking.spi.AttributeSource;
import org.hibernate.persister.walking.spi.CollectionDefinition;
import org.hibernate.persister.walking.spi.CollectionElementDefinition;
import org.hibernate.persister.walking.spi.CollectionIndexDefinition;
import org.hibernate.persister.walking.spi.CompositeCollectionElementDefinition;
import org.hibernate.persister.walking.spi.CompositionDefinition;
import org.hibernate.persister.walking.spi.EncapsulatedEntityIdentifierDefinition;
import org.hibernate.persister.walking.spi.EntityDefinition;
import org.hibernate.persister.walking.spi.EntityIdentifierDefinition;
import org.hibernate.persister.walking.spi.NonEncapsulatedEntityIdentifierDefinition;
import org.hibernate.persister.walking.spi.WalkingException;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class MetadataDrivenModelGraphVisitor {
    private static final Logger log = Logger.getLogger(MetadataDrivenModelGraphVisitor.class);
    private final AssociationVisitationStrategy strategy;
    private final SessionFactoryImplementor factory;
    private PropertyPath currentPropertyPath = new PropertyPath();
    private final Set<AssociationKey> visitedAssociationKeys = new HashSet<AssociationKey>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitEntity(AssociationVisitationStrategy strategy, EntityPersister persister) {
        strategy.start();
        try {
            new MetadataDrivenModelGraphVisitor(strategy, persister.getFactory()).visitEntityDefinition(persister);
        }
        finally {
            strategy.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitCollection(AssociationVisitationStrategy strategy, CollectionPersister persister) {
        strategy.start();
        try {
            new MetadataDrivenModelGraphVisitor(strategy, persister.getFactory()).visitCollectionDefinition(persister);
        }
        finally {
            strategy.finish();
        }
    }

    public MetadataDrivenModelGraphVisitor(AssociationVisitationStrategy strategy, SessionFactoryImplementor factory) {
        this.strategy = strategy;
        this.factory = factory;
    }

    private void visitEntityDefinition(EntityDefinition entityDefinition) {
        this.strategy.startingEntity(entityDefinition);
        this.visitAttributes(entityDefinition);
        this.visitIdentifierDefinition(entityDefinition.getEntityKeyDefinition());
        this.strategy.finishingEntity(entityDefinition);
    }

    private void visitIdentifierDefinition(EntityIdentifierDefinition entityIdentifierDefinition) {
        this.strategy.startingEntityIdentifier(entityIdentifierDefinition);
        if (entityIdentifierDefinition.isEncapsulated()) {
            this.visitAttributeDefinition(((EncapsulatedEntityIdentifierDefinition)entityIdentifierDefinition).getAttributeDefinition());
        } else {
            for (AttributeDefinition attributeDefinition : ((NonEncapsulatedEntityIdentifierDefinition)entityIdentifierDefinition).getAttributes()) {
                this.visitAttributeDefinition(attributeDefinition);
            }
        }
        this.strategy.finishingEntityIdentifier(entityIdentifierDefinition);
    }

    private void visitAttributes(AttributeSource attributeSource) {
        for (AttributeDefinition attributeDefinition : attributeSource.getAttributes()) {
            this.visitAttributeDefinition(attributeDefinition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitAttributeDefinition(AttributeDefinition attributeDefinition) {
        boolean continueWalk;
        PropertyPath subPath = this.currentPropertyPath.append(attributeDefinition.getName());
        log.debug((Object)("Visiting attribute path : " + subPath.getFullPath()));
        if (attributeDefinition.getType().isAssociationType() && this.isDuplicateAssociationKey(((AssociationAttributeDefinition)attributeDefinition).getAssociationKey())) {
            log.debug((Object)("Property path deemed to be circular : " + subPath.getFullPath()));
            continueWalk = false;
        } else {
            continueWalk = this.strategy.startingAttribute(attributeDefinition);
        }
        if (continueWalk) {
            PropertyPath old = this.currentPropertyPath;
            this.currentPropertyPath = subPath;
            try {
                if (attributeDefinition.getType().isAssociationType()) {
                    this.visitAssociation((AssociationAttributeDefinition)attributeDefinition);
                } else if (attributeDefinition.getType().isComponentType()) {
                    this.visitCompositeDefinition((CompositionDefinition)attributeDefinition);
                }
            }
            finally {
                this.currentPropertyPath = old;
            }
        }
        this.strategy.finishingAttribute(attributeDefinition);
    }

    private void visitAssociation(AssociationAttributeDefinition attribute) {
        this.addAssociationKey(attribute.getAssociationKey());
        if (attribute.isCollection()) {
            this.visitCollectionDefinition(attribute.toCollectionDefinition());
        } else {
            this.visitEntityDefinition(attribute.toEntityDefinition());
        }
    }

    private void visitCompositeDefinition(CompositionDefinition compositionDefinition) {
        this.strategy.startingComposite(compositionDefinition);
        this.visitAttributes(compositionDefinition);
        this.strategy.finishingComposite(compositionDefinition);
    }

    private void visitCollectionDefinition(CollectionDefinition collectionDefinition) {
        this.strategy.startingCollection(collectionDefinition);
        this.visitCollectionIndex(collectionDefinition);
        this.visitCollectionElements(collectionDefinition);
        this.strategy.finishingCollection(collectionDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitCollectionIndex(CollectionDefinition collectionDefinition) {
        CollectionIndexDefinition collectionIndexDefinition = collectionDefinition.getIndexDefinition();
        if (collectionIndexDefinition == null) {
            return;
        }
        this.strategy.startingCollectionIndex(collectionIndexDefinition);
        log.debug((Object)("Visiting index for collection :  " + this.currentPropertyPath.getFullPath()));
        this.currentPropertyPath = this.currentPropertyPath.append("<index>");
        try {
            Type collectionIndexType = collectionIndexDefinition.getType();
            if (collectionIndexType.isComponentType()) {
                this.visitCompositeDefinition(collectionIndexDefinition.toCompositeDefinition());
            } else if (collectionIndexType.isAssociationType()) {
                this.visitEntityDefinition(collectionIndexDefinition.toEntityDefinition());
            }
        }
        finally {
            this.currentPropertyPath = this.currentPropertyPath.getParent();
        }
        this.strategy.finishingCollectionIndex(collectionIndexDefinition);
    }

    private void visitCollectionElements(CollectionDefinition collectionDefinition) {
        CollectionElementDefinition elementDefinition = collectionDefinition.getElementDefinition();
        this.strategy.startingCollectionElements(elementDefinition);
        if (elementDefinition.getType().isComponentType()) {
            this.visitCompositeCollectionElementDefinition(elementDefinition.toCompositeElementDefinition());
        } else if (elementDefinition.getType().isEntityType()) {
            this.visitEntityDefinition(elementDefinition.toEntityDefinition());
        }
        this.strategy.finishingCollectionElements(elementDefinition);
    }

    private void visitCompositeCollectionElementDefinition(CompositeCollectionElementDefinition compositionElementDefinition) {
        this.strategy.startingCompositeCollectionElement(compositionElementDefinition);
        this.visitAttributes(compositionElementDefinition);
        this.strategy.finishingCompositeCollectionElement(compositionElementDefinition);
    }

    protected void addAssociationKey(AssociationKey associationKey) {
        if (!this.visitedAssociationKeys.add(associationKey)) {
            throw new WalkingException(String.format("Association has already been visited: %s", associationKey));
        }
    }

    protected boolean isDuplicateAssociationKey(AssociationKey associationKey) {
        return this.visitedAssociationKeys.contains(associationKey);
    }
}

