/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi;

import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.PropertyPath;
import org.hibernate.loader.plan.spi.AbstractFetchOwner;
import org.hibernate.loader.plan.spi.CollectionReference;
import org.hibernate.loader.plan.spi.CopyContext;
import org.hibernate.loader.plan.spi.EntityFetchOwnerDelegate;
import org.hibernate.loader.plan.spi.EntityReference;
import org.hibernate.loader.plan.spi.FetchOwnerDelegate;
import org.hibernate.loader.plan.spi.FetchableCollectionElement;
import org.hibernate.loader.plan.spi.IdentifierDescription;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.AssociationType;

public class EntityElementGraph
extends AbstractFetchOwner
implements FetchableCollectionElement,
EntityReference {
    private final CollectionReference collectionReference;
    private final CollectionPersister collectionPersister;
    private final AssociationType elementType;
    private final EntityPersister elementPersister;
    private final PropertyPath propertyPath;
    private final FetchOwnerDelegate fetchOwnerDelegate;
    private IdentifierDescription identifierDescription;

    public EntityElementGraph(SessionFactoryImplementor sessionFactory, CollectionReference collectionReference, PropertyPath collectionPath) {
        super(sessionFactory);
        this.collectionReference = collectionReference;
        this.collectionPersister = collectionReference.getCollectionPersister();
        this.elementType = (AssociationType)this.collectionPersister.getElementType();
        this.elementPersister = (EntityPersister)((Object)this.elementType.getAssociatedJoinable(this.sessionFactory()));
        this.propertyPath = collectionPath;
        this.fetchOwnerDelegate = new EntityFetchOwnerDelegate(this.elementPersister);
    }

    public EntityElementGraph(EntityElementGraph original, CopyContext copyContext) {
        super(original, copyContext);
        this.collectionReference = original.collectionReference;
        this.collectionPersister = original.collectionReference.getCollectionPersister();
        this.elementType = original.elementType;
        this.elementPersister = original.elementPersister;
        this.propertyPath = original.propertyPath;
        this.fetchOwnerDelegate = original.fetchOwnerDelegate;
    }

    @Override
    public LockMode getLockMode() {
        return null;
    }

    @Override
    public EntityReference getEntityReference() {
        return this;
    }

    @Override
    public EntityPersister getEntityPersister() {
        return this.elementPersister;
    }

    @Override
    public IdentifierDescription getIdentifierDescription() {
        return this.identifierDescription;
    }

    @Override
    public void validateFetchPlan(FetchStrategy fetchStrategy) {
    }

    @Override
    public EntityPersister retrieveFetchSourcePersister() {
        return this.elementPersister;
    }

    @Override
    public PropertyPath getPropertyPath() {
        return this.propertyPath;
    }

    @Override
    public void injectIdentifierDescription(IdentifierDescription identifierDescription) {
        this.identifierDescription = identifierDescription;
    }

    @Override
    public EntityElementGraph makeCopy(CopyContext copyContext) {
        return new EntityElementGraph(this, copyContext);
    }

    @Override
    public CollectionReference getCollectionReference() {
        return this.collectionReference;
    }

    public String toString() {
        return "EntityElementGraph(collection=" + this.collectionPersister.getRole() + ", type=" + this.elementPersister.getEntityName() + ")";
    }

    @Override
    protected FetchOwnerDelegate getFetchOwnerDelegate() {
        return this.fetchOwnerDelegate;
    }
}

