/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.loader.spi.NamedParameterContext;

public class ResultSetProcessorHelper {
    public static EntityKey getOptionalObjectKey(QueryParameters queryParameters, SessionImplementor session) {
        Object optionalObject = queryParameters.getOptionalObject();
        Serializable optionalId = queryParameters.getOptionalId();
        String optionalEntityName = queryParameters.getOptionalEntityName();
        if (optionalObject != null && optionalEntityName != null) {
            return session.generateEntityKey(optionalId, session.getEntityPersister(optionalEntityName, optionalObject));
        }
        return null;
    }

    public static Map<String, int[]> buildNamedParameterLocMap(QueryParameters queryParameters, NamedParameterContext namedParameterContext) {
        if (queryParameters.getNamedParameters() == null || queryParameters.getNamedParameters().isEmpty()) {
            return null;
        }
        HashMap<String, int[]> namedParameterLocMap = new HashMap<String, int[]>();
        for (String name : queryParameters.getNamedParameters().keySet()) {
            namedParameterLocMap.put(name, namedParameterContext.getNamedParameterLocations(name));
        }
        return namedParameterLocMap;
    }
}

