/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import java.util.Map;
import org.hibernate.Filter;
import org.hibernate.MappingException;
import org.hibernate.loader.internal.AbstractJoinableAssociationImpl;
import org.hibernate.loader.plan.spi.CollectionFetch;
import org.hibernate.loader.plan.spi.EntityReference;
import org.hibernate.loader.spi.JoinableAssociation;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.type.AssociationType;

public class CollectionJoinableAssociationImpl
extends AbstractJoinableAssociationImpl {
    private final AssociationType joinableType;
    private final Joinable joinable;

    public CollectionJoinableAssociationImpl(CollectionFetch collectionFetch, EntityReference currentEntityReference, String withClause, boolean hasRestriction, Map<String, Filter> enabledFilters) throws MappingException {
        super(collectionFetch, currentEntityReference, collectionFetch, withClause, hasRestriction, enabledFilters);
        this.joinableType = collectionFetch.getCollectionPersister().getCollectionType();
        this.joinable = (Joinable)((Object)collectionFetch.getCollectionPersister());
    }

    @Override
    public AssociationType getAssociationType() {
        return this.joinableType;
    }

    @Override
    public Joinable getJoinable() {
        return this.joinable;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public boolean isManyToManyWith(JoinableAssociation other) {
        QueryableCollection persister = (QueryableCollection)this.joinable;
        if (persister.isManyToMany()) {
            return persister.getElementType() == other.getAssociationType();
        }
        return false;
    }

    protected boolean isOneToOne() {
        return false;
    }
}

