/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * Copyright (c) 2010, Red Hat Inc. or third-party contributors as
 * indicated by the @author tags or express copyright attribution
 * statements applied by the authors.  All third-party contributions are
 * distributed under license by Red Hat Inc.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, write to:
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301  USA
 */
package org.hibernate.engine.jdbc.dialect.internal;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;

import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.spi.AbstractDatabaseMetaDataDialectResolver;

/**
 * Intended as support for custom resolvers.
 *
 * @author Steve Ebersole
 *
 * @deprecated Purpose has shifted to new {@link org.hibernate.engine.jdbc.dialect.spi.DatabaseInfoDialectResolver}
 * contract.  See <a href="https://hibernate.onjira.com/browse/HHH-7965">HHH-7965</a> for details.
 */
@Deprecated
public class BasicDialectResolver extends AbstractDatabaseMetaDataDialectResolver {
	/**
	 * Constant indicating no version info was given
	 */
	public static final int VERSION_INSENSITIVE_VERSION = -9999;

	private final String matchingName;
	private final int matchingVersion;
	private final Class dialectClass;

	/**
	 * Constructs a BasicDialectResolver
	 *
	 * @param matchingName The name of the driver to match on
	 * @param dialectClass The Dialect class to use on match
	 */
	public BasicDialectResolver(String matchingName, Class dialectClass) {
		this( matchingName, VERSION_INSENSITIVE_VERSION, dialectClass );
	}

	/**
	 * Constructs a BasicDialectResolver
	 *
	 * @param matchingName The name of the driver to match on
	 * @param matchingVersion The version of the driver to match on
	 * @param dialectClass The Dialect class to use on match
	 */
	public BasicDialectResolver(String matchingName, int matchingVersion, Class dialectClass) {
		this.matchingName = matchingName;
		this.matchingVersion = matchingVersion;
		this.dialectClass = dialectClass;
	}

	@Override
	protected final Dialect resolveDialectInternal(DatabaseMetaData metaData) throws SQLException {
		final String databaseName = metaData.getDatabaseProductName();
		final int databaseMajorVersion = metaData.getDatabaseMajorVersion();

		if ( matchingName.equalsIgnoreCase( databaseName )
				&& ( matchingVersion == VERSION_INSENSITIVE_VERSION || matchingVersion == databaseMajorVersion ) ) {
			try {
				return (Dialect) dialectClass.newInstance();
			}
			catch ( HibernateException e ) {
				// conceivable that the dialect ctor could throw HibernateExceptions, so don't re-wrap
				throw e;
			}
			catch ( Throwable t ) {
				throw new HibernateException(
						"Could not instantiate specified Dialect class [" + dialectClass.getName() + "]",
						t
				);
			}
		}

		return null;
	}
}
