/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.entity;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.EntityMode;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.bytecode.instrumentation.internal.FieldInterceptionHelper;
import org.hibernate.bytecode.instrumentation.spi.FieldInterceptor;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.cfg.Environment;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Subclass;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.property.Setter;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.PojoInstantiator;
import org.hibernate.tuple.entity.AbstractEntityTuplizer;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.CompositeType;
import org.jboss.logging.Logger;

public class PojoEntityTuplizer
extends AbstractEntityTuplizer {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)PojoEntityTuplizer.class.getName());
    private final Class mappedClass;
    private final Class proxyInterface;
    private final boolean lifecycleImplementor;
    private final Set lazyPropertyNames = new HashSet();
    private final ReflectionOptimizer optimizer;

    public PojoEntityTuplizer(EntityMetamodel entityMetamodel, PersistentClass mappedEntity) {
        super(entityMetamodel, mappedEntity);
        this.mappedClass = mappedEntity.getMappedClass();
        this.proxyInterface = mappedEntity.getProxyInterface();
        this.lifecycleImplementor = Lifecycle.class.isAssignableFrom(this.mappedClass);
        Iterator iter = mappedEntity.getPropertyClosureIterator();
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            if (!property.isLazy()) continue;
            this.lazyPropertyNames.add(property.getName());
        }
        String[] getterNames = new String[this.propertySpan];
        String[] setterNames = new String[this.propertySpan];
        Class[] propTypes = new Class[this.propertySpan];
        for (int i = 0; i < this.propertySpan; ++i) {
            getterNames[i] = this.getters[i].getMethodName();
            setterNames[i] = this.setters[i].getMethodName();
            propTypes[i] = this.getters[i].getReturnType();
        }
        this.optimizer = this.hasCustomAccessors || !Environment.useReflectionOptimizer() ? null : Environment.getBytecodeProvider().getReflectionOptimizer(this.mappedClass, getterNames, setterNames, propTypes);
    }

    public PojoEntityTuplizer(EntityMetamodel entityMetamodel, EntityBinding mappedEntity) {
        super(entityMetamodel, mappedEntity);
        this.mappedClass = mappedEntity.getEntity().getClassReference();
        this.proxyInterface = mappedEntity.getProxyInterfaceType().getValue();
        this.lifecycleImplementor = Lifecycle.class.isAssignableFrom(this.mappedClass);
        for (AttributeBinding property : mappedEntity.getAttributeBindingClosure()) {
            if (!property.isLazy()) continue;
            this.lazyPropertyNames.add(property.getAttribute().getName());
        }
        String[] getterNames = new String[this.propertySpan];
        String[] setterNames = new String[this.propertySpan];
        Class[] propTypes = new Class[this.propertySpan];
        for (int i = 0; i < this.propertySpan; ++i) {
            getterNames[i] = this.getters[i].getMethodName();
            setterNames[i] = this.setters[i].getMethodName();
            propTypes[i] = this.getters[i].getReturnType();
        }
        this.optimizer = this.hasCustomAccessors || !Environment.useReflectionOptimizer() ? null : Environment.getBytecodeProvider().getReflectionOptimizer(this.mappedClass, getterNames, setterNames, propTypes);
    }

    @Override
    protected ProxyFactory buildProxyFactory(PersistentClass persistentClass, Getter idGetter, Setter idSetter) {
        HashSet<Class> proxyInterfaces = new HashSet<Class>();
        proxyInterfaces.add(HibernateProxy.class);
        Class mappedClass = persistentClass.getMappedClass();
        Class proxyInterface = persistentClass.getProxyInterface();
        if (proxyInterface != null && !mappedClass.equals(proxyInterface)) {
            if (!proxyInterface.isInterface()) {
                throw new MappingException("proxy must be either an interface, or the class itself: " + this.getEntityName());
            }
            proxyInterfaces.add(proxyInterface);
        }
        if (mappedClass.isInterface()) {
            proxyInterfaces.add(mappedClass);
        }
        Iterator subclasses = persistentClass.getSubclassIterator();
        while (subclasses.hasNext()) {
            Subclass subclass = (Subclass)subclasses.next();
            Class subclassProxy = subclass.getProxyInterface();
            Class subclassClass = subclass.getMappedClass();
            if (subclassProxy == null || subclassClass.equals(subclassProxy)) continue;
            if (!subclassProxy.isInterface()) {
                throw new MappingException("proxy must be either an interface, or the class itself: " + subclass.getEntityName());
            }
            proxyInterfaces.add(subclassProxy);
        }
        Iterator properties = persistentClass.getPropertyIterator();
        Class clazz = persistentClass.getMappedClass();
        while (properties.hasNext()) {
            Property property = (Property)properties.next();
            Method method = property.getGetter(clazz).getMethod();
            if (method != null && Modifier.isFinal(method.getModifiers())) {
                LOG.gettersOfLazyClassesCannotBeFinal(persistentClass.getEntityName(), property.getName());
            }
            if ((method = property.getSetter(clazz).getMethod()) == null || !Modifier.isFinal(method.getModifiers())) continue;
            LOG.settersOfLazyClassesCannotBeFinal(persistentClass.getEntityName(), property.getName());
        }
        Method idGetterMethod = idGetter == null ? null : idGetter.getMethod();
        Method idSetterMethod = idSetter == null ? null : idSetter.getMethod();
        Method proxyGetIdentifierMethod = idGetterMethod == null || proxyInterface == null ? null : ReflectHelper.getMethod(proxyInterface, idGetterMethod);
        Method proxySetIdentifierMethod = idSetterMethod == null || proxyInterface == null ? null : ReflectHelper.getMethod(proxyInterface, idSetterMethod);
        ProxyFactory pf = this.buildProxyFactoryInternal(persistentClass, idGetter, idSetter);
        try {
            pf.postInstantiate(this.getEntityName(), mappedClass, proxyInterfaces, proxyGetIdentifierMethod, proxySetIdentifierMethod, persistentClass.hasEmbeddedIdentifier() ? (CompositeType)persistentClass.getIdentifier().getType() : null);
        }
        catch (HibernateException he) {
            LOG.unableToCreateProxyFactory(this.getEntityName(), he);
            pf = null;
        }
        return pf;
    }

    protected ProxyFactory buildProxyFactoryInternal(PersistentClass persistentClass, Getter idGetter, Setter idSetter) {
        return Environment.getBytecodeProvider().getProxyFactoryFactory().buildProxyFactory();
    }

    @Override
    protected Instantiator buildInstantiator(PersistentClass persistentClass) {
        if (this.optimizer == null) {
            return new PojoInstantiator(persistentClass, null);
        }
        return new PojoInstantiator(persistentClass, this.optimizer.getInstantiationOptimizer());
    }

    @Override
    protected ProxyFactory buildProxyFactory(EntityBinding entityBinding, Getter idGetter, Setter idSetter) {
        HashSet proxyInterfaces = new HashSet();
        proxyInterfaces.add(HibernateProxy.class);
        Class<?> mappedClass = entityBinding.getEntity().getClassReference();
        Class<?> proxyInterface = entityBinding.getProxyInterfaceType().getValue();
        if (proxyInterface != null && !mappedClass.equals(proxyInterface)) {
            if (!proxyInterface.isInterface()) {
                throw new MappingException("proxy must be either an interface, or the class itself: " + this.getEntityName());
            }
            proxyInterfaces.add(proxyInterface);
        }
        if (mappedClass.isInterface()) {
            proxyInterfaces.add(mappedClass);
        }
        for (EntityBinding subEntityBinding : entityBinding.getPostOrderSubEntityBindingClosure()) {
            Class<?> subclassProxy = subEntityBinding.getProxyInterfaceType().getValue();
            Class<?> subclassClass = subEntityBinding.getClassReference();
            if (subclassProxy == null || subclassClass.equals(subclassProxy)) continue;
            if (!subclassProxy.isInterface()) {
                throw new MappingException("proxy must be either an interface, or the class itself: " + subEntityBinding.getEntity().getName());
            }
            proxyInterfaces.add(subclassProxy);
        }
        for (AttributeBinding property : entityBinding.attributeBindings()) {
            Method method = this.getGetter(property).getMethod();
            if (method != null && Modifier.isFinal(method.getModifiers())) {
                LOG.gettersOfLazyClassesCannotBeFinal(entityBinding.getEntity().getName(), property.getAttribute().getName());
            }
            if ((method = this.getSetter(property).getMethod()) == null || !Modifier.isFinal(method.getModifiers())) continue;
            LOG.settersOfLazyClassesCannotBeFinal(entityBinding.getEntity().getName(), property.getAttribute().getName());
        }
        Method idGetterMethod = idGetter == null ? null : idGetter.getMethod();
        Method idSetterMethod = idSetter == null ? null : idSetter.getMethod();
        Method proxyGetIdentifierMethod = idGetterMethod == null || proxyInterface == null ? null : ReflectHelper.getMethod(proxyInterface, idGetterMethod);
        Method proxySetIdentifierMethod = idSetterMethod == null || proxyInterface == null ? null : ReflectHelper.getMethod(proxyInterface, idSetterMethod);
        ProxyFactory pf = this.buildProxyFactoryInternal(entityBinding, idGetter, idSetter);
        try {
            pf.postInstantiate(this.getEntityName(), mappedClass, proxyInterfaces, proxyGetIdentifierMethod, proxySetIdentifierMethod, entityBinding.getHierarchyDetails().getEntityIdentifier().isEmbedded() ? (CompositeType)entityBinding.getHierarchyDetails().getEntityIdentifier().getValueBinding().getHibernateTypeDescriptor().getResolvedTypeMapping() : null);
        }
        catch (HibernateException he) {
            LOG.unableToCreateProxyFactory(this.getEntityName(), he);
            pf = null;
        }
        return pf;
    }

    protected ProxyFactory buildProxyFactoryInternal(EntityBinding entityBinding, Getter idGetter, Setter idSetter) {
        return Environment.getBytecodeProvider().getProxyFactoryFactory().buildProxyFactory();
    }

    @Override
    protected Instantiator buildInstantiator(EntityBinding entityBinding) {
        if (this.optimizer == null) {
            return new PojoInstantiator(entityBinding, null);
        }
        return new PojoInstantiator(entityBinding, this.optimizer.getInstantiationOptimizer());
    }

    @Override
    public void setPropertyValues(Object entity, Object[] values) throws HibernateException {
        if (!this.getEntityMetamodel().hasLazyProperties() && this.optimizer != null && this.optimizer.getAccessOptimizer() != null) {
            this.setPropertyValuesWithOptimizer(entity, values);
        } else {
            super.setPropertyValues(entity, values);
        }
    }

    @Override
    public Object[] getPropertyValues(Object entity) throws HibernateException {
        if (this.shouldGetAllProperties(entity) && this.optimizer != null && this.optimizer.getAccessOptimizer() != null) {
            return this.getPropertyValuesWithOptimizer(entity);
        }
        return super.getPropertyValues(entity);
    }

    @Override
    public Object[] getPropertyValuesToInsert(Object entity, Map mergeMap, SessionImplementor session) throws HibernateException {
        if (this.shouldGetAllProperties(entity) && this.optimizer != null && this.optimizer.getAccessOptimizer() != null) {
            return this.getPropertyValuesWithOptimizer(entity);
        }
        return super.getPropertyValuesToInsert(entity, mergeMap, session);
    }

    protected void setPropertyValuesWithOptimizer(Object object, Object[] values) {
        this.optimizer.getAccessOptimizer().setPropertyValues(object, values);
    }

    protected Object[] getPropertyValuesWithOptimizer(Object object) {
        return this.optimizer.getAccessOptimizer().getPropertyValues(object);
    }

    @Override
    public EntityMode getEntityMode() {
        return EntityMode.POJO;
    }

    @Override
    public Class getMappedClass() {
        return this.mappedClass;
    }

    @Override
    public boolean isLifecycleImplementor() {
        return this.lifecycleImplementor;
    }

    @Override
    protected Getter buildPropertyGetter(Property mappedProperty, PersistentClass mappedEntity) {
        return mappedProperty.getGetter(mappedEntity.getMappedClass());
    }

    @Override
    protected Setter buildPropertySetter(Property mappedProperty, PersistentClass mappedEntity) {
        return mappedProperty.getSetter(mappedEntity.getMappedClass());
    }

    @Override
    protected Getter buildPropertyGetter(AttributeBinding mappedProperty) {
        return this.getGetter(mappedProperty);
    }

    @Override
    protected Setter buildPropertySetter(AttributeBinding mappedProperty) {
        return this.getSetter(mappedProperty);
    }

    private Getter getGetter(AttributeBinding mappedProperty) throws PropertyNotFoundException, MappingException {
        return this.getPropertyAccessor(mappedProperty).getGetter(mappedProperty.getContainer().getClassReference(), mappedProperty.getAttribute().getName());
    }

    private Setter getSetter(AttributeBinding mappedProperty) throws PropertyNotFoundException, MappingException {
        return this.getPropertyAccessor(mappedProperty).getSetter(mappedProperty.getContainer().getClassReference(), mappedProperty.getAttribute().getName());
    }

    private PropertyAccessor getPropertyAccessor(AttributeBinding mappedProperty) throws MappingException {
        return PropertyAccessorFactory.getPropertyAccessor(mappedProperty.getContainer().getClassReference(), mappedProperty.getPropertyAccessorName());
    }

    @Override
    public Class getConcreteProxyClass() {
        return this.proxyInterface;
    }

    @Override
    public void afterInitialize(Object entity, boolean lazyPropertiesAreUnfetched, SessionImplementor session) {
        if (this.isInstrumented()) {
            Set lazyProps = lazyPropertiesAreUnfetched && this.getEntityMetamodel().hasLazyProperties() ? this.lazyPropertyNames : null;
            FieldInterceptionHelper.injectFieldInterceptor(entity, this.getEntityName(), lazyProps, session);
        }
    }

    @Override
    public boolean hasUninitializedLazyProperties(Object entity) {
        if (this.getEntityMetamodel().hasLazyProperties()) {
            FieldInterceptor callback = FieldInterceptionHelper.extractFieldInterceptor(entity);
            return callback != null && !callback.isInitialized();
        }
        return false;
    }

    @Override
    public boolean isInstrumented() {
        return FieldInterceptionHelper.isInstrumented(this.getMappedClass());
    }

    @Override
    public String determineConcreteSubclassEntityName(Object entityInstance, SessionFactoryImplementor factory) {
        Class<?> concreteEntityClass = entityInstance.getClass();
        if (concreteEntityClass == this.getMappedClass()) {
            return this.getEntityName();
        }
        String entityName = this.getEntityMetamodel().findEntityNameByEntityClass(concreteEntityClass);
        if (entityName == null) {
            throw new HibernateException("Unable to resolve entity name from Class [" + concreteEntityClass.getName() + "]" + " expected instance/subclass of [" + this.getEntityName() + "]");
        }
        return entityName;
    }

    @Override
    public EntityNameResolver[] getEntityNameResolvers() {
        return null;
    }
}

