/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import java.util.List;
import java.util.Map;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbHibernateMapping;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.metamodel.source.LocalBindingContext;
import org.hibernate.metamodel.source.binder.ExplicitHibernateTypeSource;
import org.hibernate.metamodel.source.binder.MetaAttributeSource;
import org.hibernate.metamodel.source.binder.RelationalValueSource;
import org.hibernate.metamodel.source.binder.SingularAttributeNature;
import org.hibernate.metamodel.source.binder.SingularAttributeSource;
import org.hibernate.metamodel.source.hbm.Helper;

class SingularIdentifierAttributeSourceImpl
implements SingularAttributeSource {
    private final JaxbHibernateMapping.JaxbClass.JaxbId idElement;
    private final ExplicitHibernateTypeSource typeSource;
    private final List<RelationalValueSource> valueSources;

    public SingularIdentifierAttributeSourceImpl(final JaxbHibernateMapping.JaxbClass.JaxbId idElement, LocalBindingContext bindingContext) {
        this.idElement = idElement;
        this.typeSource = new ExplicitHibernateTypeSource(){
            private final String name;
            private final Map<String, String> parameters;
            {
                this.name = idElement.getTypeAttribute() != null ? idElement.getTypeAttribute() : (idElement.getType() != null ? idElement.getType().getName() : null);
                this.parameters = idElement.getType() != null ? Helper.extractParameters(idElement.getType().getParam()) : null;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public Map<String, String> getParameters() {
                return this.parameters;
            }
        };
        this.valueSources = Helper.buildValueSources(new Helper.ValueSourcesAdapter(){

            @Override
            public String getColumnAttribute() {
                return idElement.getColumnAttribute();
            }

            @Override
            public String getFormulaAttribute() {
                return null;
            }

            @Override
            public List getColumnOrFormulaElements() {
                return idElement.getColumn();
            }

            @Override
            public String getContainingTableName() {
                return null;
            }

            @Override
            public boolean isIncludedInInsertByDefault() {
                return true;
            }

            @Override
            public boolean isIncludedInUpdateByDefault() {
                return false;
            }
        }, bindingContext);
    }

    @Override
    public String getName() {
        return this.idElement.getName() == null ? "id" : this.idElement.getName();
    }

    @Override
    public ExplicitHibernateTypeSource getTypeInformation() {
        return this.typeSource;
    }

    @Override
    public String getPropertyAccessorName() {
        return this.idElement.getAccess();
    }

    @Override
    public boolean isInsertable() {
        return true;
    }

    @Override
    public boolean isUpdatable() {
        return false;
    }

    @Override
    public PropertyGeneration getGeneration() {
        return PropertyGeneration.INSERT;
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public boolean isIncludedInOptimisticLocking() {
        return false;
    }

    @Override
    public SingularAttributeNature getNature() {
        return SingularAttributeNature.BASIC;
    }

    @Override
    public boolean isVirtualAttribute() {
        return false;
    }

    @Override
    public boolean areValuesIncludedInInsertByDefault() {
        return true;
    }

    @Override
    public boolean areValuesIncludedInUpdateByDefault() {
        return true;
    }

    @Override
    public boolean areValuesNullableByDefault() {
        return false;
    }

    @Override
    public List<RelationalValueSource> relationalValueSources() {
        return this.valueSources;
    }

    @Override
    public boolean isSingular() {
        return true;
    }

    @Override
    public Iterable<MetaAttributeSource> metaAttributes() {
        return Helper.buildMetaAttributeSources(this.idElement.getMeta());
    }
}

