/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import org.hibernate.HibernateLogger;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.TimestampType;
import org.jboss.logging.Logger;

public class DbTimestampType
extends TimestampType {
    public static final DbTimestampType INSTANCE = new DbTimestampType();
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)DbTimestampType.class.getName());

    @Override
    public String getName() {
        return "dbtimestamp";
    }

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{this.getName()};
    }

    @Override
    public Date seed(SessionImplementor session) {
        if (session == null) {
            LOG.trace("Incoming session was null; using current jvm time");
            return super.seed(session);
        }
        if (!session.getFactory().getDialect().supportsCurrentTimestampSelection()) {
            LOG.debugf("Falling back to vm-based timestamp, as dialect does not support current timestamp selection", new Object[0]);
            return super.seed(session);
        }
        return this.getCurrentTimestamp(session);
    }

    private Date getCurrentTimestamp(SessionImplementor session) {
        Dialect dialect = session.getFactory().getDialect();
        String timestampSelectString = dialect.getCurrentTimestampSelectString();
        if (dialect.isCurrentTimestampSelectStringCallable()) {
            return this.useCallableStatement(timestampSelectString, session);
        }
        return this.usePreparedStatement(timestampSelectString, session);
    }

    private Timestamp usePreparedStatement(String timestampSelectString, SessionImplementor session) {
        Statement ps = null;
        try {
            ps = session.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(timestampSelectString, false);
            ResultSet rs = ps.executeQuery();
            rs.next();
            Timestamp ts = rs.getTimestamp(1);
            LOG.trace("Current timestamp retreived from db : " + ts + " (nanos=" + ts.getNanos() + ", time=" + ts.getTime() + ")");
            Timestamp timestamp = ts;
            return timestamp;
        }
        catch (SQLException e) {
            throw session.getFactory().getSQLExceptionHelper().convert(e, "could not select current db timestamp", timestampSelectString);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sqle) {
                    LOG.unableToCleanUpPreparedStatement(sqle);
                }
            }
        }
    }

    private Timestamp useCallableStatement(String callString, SessionImplementor session) {
        Statement cs = null;
        try {
            cs = (CallableStatement)session.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(callString, true);
            cs.registerOutParameter(1, 93);
            cs.execute();
            Timestamp ts = cs.getTimestamp(1);
            LOG.trace("Current timestamp retreived from db : " + ts + " (nanos=" + ts.getNanos() + ", time=" + ts.getTime() + ")");
            Timestamp timestamp = ts;
            return timestamp;
        }
        catch (SQLException e) {
            throw session.getFactory().getSQLExceptionHelper().convert(e, "could not call current db timestamp function", callString);
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (SQLException sqle) {
                    LOG.unableToCleanUpCallableStatement(sqle);
                }
            }
        }
    }
}

