/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.lang.reflect.Constructor;
import org.hibernate.EntityMode;
import org.hibernate.engine.IdentifierValue;
import org.hibernate.engine.UnsavedValueFactory;
import org.hibernate.engine.VersionValue;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.tuple.IdentifierProperty;
import org.hibernate.tuple.StandardProperty;
import org.hibernate.tuple.VersionProperty;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.type.VersionType;

public class PropertyFactory {
    public static IdentifierProperty buildIdentifierProperty(PersistentClass mappedEntity, IdentifierGenerator generator) {
        String mappedUnsavedValue = mappedEntity.getIdentifier().getNullValue();
        Type type = mappedEntity.getIdentifier().getType();
        Property property = mappedEntity.getIdentifierProperty();
        IdentifierValue unsavedValue = UnsavedValueFactory.getUnsavedIdentifierValue(mappedUnsavedValue, PropertyFactory.getGetter(property), type, PropertyFactory.getConstructor(mappedEntity));
        if (property == null) {
            return new IdentifierProperty(type, mappedEntity.hasEmbeddedIdentifier(), mappedEntity.hasIdentifierMapper(), unsavedValue, generator);
        }
        return new IdentifierProperty(property.getName(), property.getNodeName(), type, mappedEntity.hasEmbeddedIdentifier(), unsavedValue, generator);
    }

    public static VersionProperty buildVersionProperty(Property property, boolean lazyAvailable) {
        String mappedUnsavedValue = ((KeyValue)property.getValue()).getNullValue();
        VersionValue unsavedValue = UnsavedValueFactory.getUnsavedVersionValue(mappedUnsavedValue, PropertyFactory.getGetter(property), (VersionType)property.getType(), PropertyFactory.getConstructor(property.getPersistentClass()));
        boolean lazy = lazyAvailable && property.isLazy();
        return new VersionProperty(property.getName(), property.getNodeName(), property.getValue().getType(), lazy, property.isInsertable(), property.isUpdateable(), property.getGeneration() == PropertyGeneration.INSERT || property.getGeneration() == PropertyGeneration.ALWAYS, property.getGeneration() == PropertyGeneration.ALWAYS, property.isOptional(), property.isUpdateable() && !lazy, property.isOptimisticLocked(), property.getCascadeStyle(), unsavedValue);
    }

    public static StandardProperty buildStandardProperty(Property property, boolean lazyAvailable) {
        Type type = property.getValue().getType();
        boolean alwaysDirtyCheck = type.isAssociationType() && ((AssociationType)type).isAlwaysDirtyChecked();
        return new StandardProperty(property.getName(), property.getNodeName(), type, lazyAvailable && property.isLazy(), property.isInsertable(), property.isUpdateable(), property.getGeneration() == PropertyGeneration.INSERT || property.getGeneration() == PropertyGeneration.ALWAYS, property.getGeneration() == PropertyGeneration.ALWAYS, property.isOptional(), alwaysDirtyCheck || property.isUpdateable(), property.isOptimisticLocked(), property.getCascadeStyle(), property.getValue().getFetchMode());
    }

    private static Constructor getConstructor(PersistentClass persistentClass) {
        if (persistentClass == null || !persistentClass.hasPojoRepresentation()) {
            return null;
        }
        try {
            return ReflectHelper.getDefaultConstructor(persistentClass.getMappedClass());
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Getter getGetter(Property mappingProperty) {
        if (mappingProperty == null || !mappingProperty.getPersistentClass().hasPojoRepresentation()) {
            return null;
        }
        PropertyAccessor pa = PropertyAccessorFactory.getPropertyAccessor(mappingProperty, EntityMode.POJO);
        return pa.getGetter(mappingProperty.getPersistentClass().getMappedClass(), mappingProperty.getName());
    }
}

