/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.HibernateLogger;
import org.hibernate.JDBCException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.internal.ServiceRegistryImpl;
import org.hibernate.tool.hbm2ddl.ConnectionHelper;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.ManagedProviderConnectionHelper;
import org.hibernate.tool.hbm2ddl.SuppliedConnectionProviderConnectionHelper;
import org.jboss.logging.Logger;

public class SchemaUpdate {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)SchemaUpdate.class.getName());
    private ConnectionHelper connectionHelper;
    private Configuration configuration;
    private Dialect dialect;
    private List exceptions;
    private boolean haltOnError = false;
    private boolean format = true;
    private String outputFile = null;
    private String delimiter;
    private Formatter formatter;
    private SqlStatementLogger sqlStatementLogger;

    public SchemaUpdate(Configuration cfg) throws HibernateException {
        this(cfg, cfg.getProperties());
    }

    public SchemaUpdate(Configuration cfg, Properties connectionProperties) throws HibernateException {
        this.configuration = cfg;
        this.dialect = Dialect.getDialect(connectionProperties);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.dialect.getDefaultProperties());
        props.putAll((Map<?, ?>)connectionProperties);
        this.connectionHelper = new ManagedProviderConnectionHelper(props);
        this.exceptions = new ArrayList();
        this.formatter = (ConfigurationHelper.getBoolean("hibernate.format_sql", props) ? FormatStyle.DDL : FormatStyle.NONE).getFormatter();
    }

    public SchemaUpdate(JdbcServices jdbcServices, Configuration cfg) throws HibernateException {
        this.configuration = cfg;
        this.dialect = jdbcServices.getDialect();
        this.connectionHelper = new SuppliedConnectionProviderConnectionHelper(jdbcServices.getConnectionProvider());
        this.exceptions = new ArrayList();
        this.sqlStatementLogger = jdbcServices.getSqlStatementLogger();
        this.formatter = (this.sqlStatementLogger.isFormat() ? FormatStyle.DDL : FormatStyle.NONE).getFormatter();
    }

    private static ServiceRegistryImpl createServiceRegistry(Properties properties) {
        Environment.verifyProperties(properties);
        ConfigurationHelper.resolvePlaceHolders(properties);
        return new ServiceRegistryImpl(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            Configuration cfg = new Configuration();
            boolean script = true;
            boolean doUpdate = true;
            String propFile = null;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("--")) {
                    if (args[i].equals("--quiet")) {
                        script = false;
                        continue;
                    }
                    if (args[i].startsWith("--properties=")) {
                        propFile = args[i].substring(13);
                        continue;
                    }
                    if (args[i].startsWith("--config=")) {
                        cfg.configure(args[i].substring(9));
                        continue;
                    }
                    if (args[i].startsWith("--text")) {
                        doUpdate = false;
                        continue;
                    }
                    if (!args[i].startsWith("--naming=")) continue;
                    cfg.setNamingStrategy((NamingStrategy)ReflectHelper.classForName(args[i].substring(9)).newInstance());
                    continue;
                }
                cfg.addFile(args[i]);
            }
            if (propFile != null) {
                Properties props = new Properties();
                props.putAll((Map<?, ?>)cfg.getProperties());
                props.load(new FileInputStream(propFile));
                cfg.setProperties(props);
            }
            ServiceRegistryImpl serviceRegistry = SchemaUpdate.createServiceRegistry(cfg.getProperties());
            try {
                new SchemaUpdate(serviceRegistry.getService(JdbcServices.class), cfg).execute(script, doUpdate);
            }
            finally {
                serviceRegistry.destroy();
            }
        }
        catch (Exception e) {
            LOG.unableToRunSchemaUpdate(e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(boolean script, boolean doUpdate) {
        LOG.runningHbm2ddlSchemaUpdate();
        Connection connection = null;
        Statement stmt = null;
        Writer outputFileWriter = null;
        this.exceptions.clear();
        try {
            DatabaseMetadata meta;
            try {
                LOG.fetchingDatabaseMetadata();
                this.connectionHelper.prepare(true);
                connection = this.connectionHelper.getConnection();
                meta = new DatabaseMetadata(connection, this.dialect);
                stmt = connection.createStatement();
            }
            catch (SQLException sqle) {
                this.exceptions.add(sqle);
                LOG.unableToGetDatabaseMetadata(sqle);
                throw sqle;
            }
            LOG.updatingSchema();
            if (this.outputFile != null) {
                LOG.writingGeneratedSchemaToFile(this.outputFile);
                outputFileWriter = new FileWriter(this.outputFile);
            }
            String[] createSQL = this.configuration.generateSchemaUpdateScript(this.dialect, meta);
            for (int j = 0; j < createSQL.length; ++j) {
                String sql = createSQL[j];
                String formatted = this.formatter.format(sql);
                try {
                    if (this.delimiter != null) {
                        formatted = formatted + this.delimiter;
                    }
                    if (script) {
                        System.out.println(formatted);
                    }
                    if (this.outputFile != null) {
                        outputFileWriter.write(formatted + "\n");
                    }
                    if (!doUpdate) continue;
                    LOG.debugf(sql, new Object[0]);
                    stmt.executeUpdate(formatted);
                    continue;
                }
                catch (SQLException e) {
                    if (this.haltOnError) {
                        throw new JDBCException("Error during DDL export", e);
                    }
                    this.exceptions.add(e);
                    LOG.unsuccessful(sql);
                    LOG.error(e.getMessage());
                }
            }
            LOG.schemaUpdateComplete();
        }
        catch (Exception e) {
            this.exceptions.add(e);
            LOG.unableToCompleteSchemaUpdate(e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                this.connectionHelper.release();
            }
            catch (Exception e) {
                this.exceptions.add(e);
                LOG.unableToCloseConnection(e);
            }
            try {
                if (outputFileWriter != null) {
                    outputFileWriter.close();
                }
            }
            catch (Exception e) {
                this.exceptions.add(e);
                LOG.unableToCloseConnection(e);
            }
        }
    }

    public List getExceptions() {
        return this.exceptions;
    }

    public void setHaltOnError(boolean haltOnError) {
        this.haltOnError = haltOnError;
    }

    public void setFormat(boolean format) {
        this.formatter = (format ? FormatStyle.DDL : FormatStyle.NONE).getFormatter();
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

