/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat;

import org.hibernate.stat.CategorizedStatistics;
import org.hibernate.stat.QueryStatistics;

public class QueryStatisticsImpl
extends CategorizedStatistics
implements QueryStatistics {
    long cacheHitCount;
    long cacheMissCount;
    long cachePutCount;
    private long executionCount;
    private long executionRowCount;
    private long executionAvgTime;
    private long executionMaxTime;
    private long executionMinTime = Long.MAX_VALUE;

    QueryStatisticsImpl(String query) {
        super(query);
    }

    @Override
    public long getExecutionCount() {
        return this.executionCount;
    }

    @Override
    public long getCacheHitCount() {
        return this.cacheHitCount;
    }

    @Override
    public long getCachePutCount() {
        return this.cachePutCount;
    }

    @Override
    public long getCacheMissCount() {
        return this.cacheMissCount;
    }

    @Override
    public long getExecutionRowCount() {
        return this.executionRowCount;
    }

    @Override
    public long getExecutionAvgTime() {
        return this.executionAvgTime;
    }

    @Override
    public long getExecutionMaxTime() {
        return this.executionMaxTime;
    }

    @Override
    public long getExecutionMinTime() {
        return this.executionMinTime;
    }

    void executed(long rows, long time) {
        if (time < this.executionMinTime) {
            this.executionMinTime = time;
        }
        if (time > this.executionMaxTime) {
            this.executionMaxTime = time;
        }
        this.executionAvgTime = (this.executionAvgTime * this.executionCount + time) / (this.executionCount + 1L);
        ++this.executionCount;
        this.executionRowCount += rows;
    }

    public String toString() {
        return "QueryStatistics" + "[cacheHitCount=" + this.cacheHitCount + ",cacheMissCount=" + this.cacheMissCount + ",cachePutCount=" + this.cachePutCount + ",executionCount=" + this.executionCount + ",executionRowCount=" + this.executionRowCount + ",executionAvgTime=" + this.executionAvgTime + ",executionMaxTime=" + this.executionMaxTime + ",executionMinTime=" + this.executionMinTime + ']';
    }
}

