/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jta.platform.internal;

import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.HibernateLogger;
import org.hibernate.internal.util.jndi.JndiHelper;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.jta.platform.internal.BitronixJtaPlatform;
import org.hibernate.service.jta.platform.internal.BorlandEnterpriseServerJtaPlatform;
import org.hibernate.service.jta.platform.internal.JBossAppServerPlatform;
import org.hibernate.service.jta.platform.internal.JBossStandAloneJtaPlatform;
import org.hibernate.service.jta.platform.internal.JOTMJtaPlatform;
import org.hibernate.service.jta.platform.internal.JOnASJtaPlatform;
import org.hibernate.service.jta.platform.internal.JRun4JtaPlatform;
import org.hibernate.service.jta.platform.internal.NoJtaPlatform;
import org.hibernate.service.jta.platform.internal.OC4JJtaPlatform;
import org.hibernate.service.jta.platform.internal.OrionJtaPlatform;
import org.hibernate.service.jta.platform.internal.ResinJtaPlatform;
import org.hibernate.service.jta.platform.internal.SunOneJtaPlatform;
import org.hibernate.service.jta.platform.internal.TransactionManagerLookupBridge;
import org.hibernate.service.jta.platform.internal.WebSphereExtendedJtaPlatform;
import org.hibernate.service.jta.platform.internal.WebSphereJtaPlatform;
import org.hibernate.service.jta.platform.internal.WeblogicJtaPlatform;
import org.hibernate.service.jta.platform.spi.JtaPlatform;
import org.hibernate.service.jta.platform.spi.JtaPlatformException;
import org.hibernate.service.spi.ServiceInitiator;
import org.hibernate.service.spi.ServiceRegistry;
import org.hibernate.transaction.TransactionManagerLookup;
import org.jboss.logging.Logger;

public class JtaPlatformInitiator
implements ServiceInitiator<JtaPlatform> {
    public static final JtaPlatformInitiator INSTANCE = new JtaPlatformInitiator();
    public static final String JTA_PLATFORM = "hibernate.jta.platform";
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)JtaPlatformInitiator.class.getName());

    @Override
    public Class<JtaPlatform> getServiceInitiated() {
        return JtaPlatform.class;
    }

    @Override
    public JtaPlatform initiateService(Map configVales, ServiceRegistry registry) {
        Class jtaPlatformImplClass;
        Object platform = this.getConfiguredPlatform(configVales, registry);
        if (platform == null) {
            return new NoJtaPlatform();
        }
        if (JtaPlatform.class.isInstance(platform)) {
            return (JtaPlatform)platform;
        }
        if (Class.class.isInstance(platform)) {
            jtaPlatformImplClass = (Class)platform;
        } else {
            String platformImplName = platform.toString();
            ClassLoaderService classLoaderService = registry.getService(ClassLoaderService.class);
            try {
                jtaPlatformImplClass = classLoaderService.classForName(platformImplName);
            }
            catch (Exception e) {
                throw new HibernateException("Unable to locate specified JtaPlatform class [" + platformImplName + "]", e);
            }
        }
        try {
            return (JtaPlatform)jtaPlatformImplClass.newInstance();
        }
        catch (Exception e) {
            throw new HibernateException("Unable to create specified JtaPlatform class [" + jtaPlatformImplClass.getName() + "]", e);
        }
    }

    private Object getConfiguredPlatform(Map configVales, ServiceRegistry registry) {
        String transactionManagerLookupImplName;
        Object platform = configVales.get(JTA_PLATFORM);
        if (platform == null && (transactionManagerLookupImplName = (String)configVales.get("hibernate.transaction.manager_lookup_class")) != null) {
            LOG.deprecatedTransactionManagerStrategy(TransactionManagerLookup.class.getName(), "hibernate.transaction.manager_lookup_class", JtaPlatform.class.getName(), JTA_PLATFORM);
            platform = this.mapLegacyClasses(transactionManagerLookupImplName, configVales, registry);
            LOG.debugf("Mapped %s -> %s", transactionManagerLookupImplName, platform);
        }
        return platform;
    }

    private JtaPlatform mapLegacyClasses(String transactionManagerLookupImplName, Map configVales, ServiceRegistry registry) {
        if (transactionManagerLookupImplName == null) {
            return null;
        }
        LOG.legacyTransactionManagerStrategy(JtaPlatform.class.getName(), JTA_PLATFORM);
        if ("org.hibernate.transaction.BESTransactionManagerLookup".equals(transactionManagerLookupImplName)) {
            return new BorlandEnterpriseServerJtaPlatform();
        }
        if ("org.hibernate.transaction.BTMTransactionManagerLookup".equals(transactionManagerLookupImplName)) {
            return new BitronixJtaPlatform();
        }
        if ("org.hibernate.transaction.JBossTransactionManagerLookup".equals(transactionManagerLookupImplName)) {
            return new JBossAppServerPlatform();
        }
        if ("org.hibernate.transaction.JBossTSStandaloneTransactionManagerLookup".equals(transactionManagerLookupImplName)) {
            return new JBossStandAloneJtaPlatform();
        }
        if ("org.hibernate.transaction.JOnASTransactionManagerLookup".equals(transactionManagerLookupImplName)) {
            return new JOnASJtaPlatform();
        }
        if ("org.hibernate.transaction.JOTMTransactionManagerLookup".equals(transactionManagerLookupImplName)) {
            return new JOTMJtaPlatform();
        }
        if ("org.hibernate.transaction.JRun4TransactionManagerLookup".equals(transactionManagerLookupImplName)) {
            return new JRun4JtaPlatform();
        }
        if ("org.hibernate.transaction.OC4JTransactionManagerLookup".equals(transactionManagerLookupImplName)) {
            return new OC4JJtaPlatform();
        }
        if ("org.hibernate.transaction.OrionTransactionManagerLookup".equals(transactionManagerLookupImplName)) {
            return new OrionJtaPlatform();
        }
        if ("org.hibernate.transaction.ResinTransactionManagerLookup".equals(transactionManagerLookupImplName)) {
            return new ResinJtaPlatform();
        }
        if ("org.hibernate.transaction.SunONETransactionManagerLookup".equals(transactionManagerLookupImplName)) {
            return new SunOneJtaPlatform();
        }
        if ("org.hibernate.transaction.WeblogicTransactionManagerLookup".equals(transactionManagerLookupImplName)) {
            return new WeblogicJtaPlatform();
        }
        if ("org.hibernate.transaction.WebSphereTransactionManagerLookup".equals(transactionManagerLookupImplName)) {
            return new WebSphereJtaPlatform();
        }
        if ("org.hibernate.transaction.WebSphereExtendedJTATransactionLookup".equals(transactionManagerLookupImplName)) {
            return new WebSphereExtendedJtaPlatform();
        }
        try {
            TransactionManagerLookup lookup = (TransactionManagerLookup)registry.getService(ClassLoaderService.class).classForName(transactionManagerLookupImplName).newInstance();
            return new TransactionManagerLookupBridge(lookup, JndiHelper.extractJndiProperties(configVales));
        }
        catch (Exception e) {
            throw new JtaPlatformException("Unable to build " + TransactionManagerLookupBridge.class.getName() + " from specified " + TransactionManagerLookup.class.getName() + " implementation: " + transactionManagerLookupImplName);
        }
    }
}

