/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jmx.internal;

import java.util.Map;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.jmx.internal.DisabledJmxServiceImpl;
import org.hibernate.service.jmx.internal.JmxServiceImpl;
import org.hibernate.service.jmx.spi.JmxService;
import org.hibernate.service.spi.ServiceInitiator;
import org.hibernate.service.spi.ServiceRegistry;

public class JmxServiceInitiator
implements ServiceInitiator<JmxService> {
    public static final String JMX_ENABLED = "hibernate.jmx.enabled";
    public static final JmxServiceInitiator INSTANCE = new JmxServiceInitiator();

    @Override
    public Class<JmxService> getServiceInitiated() {
        return JmxService.class;
    }

    @Override
    public JmxService initiateService(Map configValues, ServiceRegistry registry) {
        return ConfigurationHelper.getBoolean(JMX_ENABLED, configValues, false) ? new JmxServiceImpl(configValues) : DisabledJmxServiceImpl.INSTANCE;
    }
}

