/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property;

import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Property;
import org.hibernate.property.BasicPropertyAccessor;
import org.hibernate.property.DirectPropertyAccessor;
import org.hibernate.property.Dom4jAccessor;
import org.hibernate.property.EmbeddedPropertyAccessor;
import org.hibernate.property.MapAccessor;
import org.hibernate.property.NoopAccessor;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.type.Type;

public final class PropertyAccessorFactory {
    private static final PropertyAccessor BASIC_PROPERTY_ACCESSOR = new BasicPropertyAccessor();
    private static final PropertyAccessor DIRECT_PROPERTY_ACCESSOR = new DirectPropertyAccessor();
    private static final PropertyAccessor MAP_ACCESSOR = new MapAccessor();
    private static final PropertyAccessor NOOP_ACCESSOR = new NoopAccessor();
    private static final PropertyAccessor EMBEDDED_PROPERTY_ACCESSOR = new EmbeddedPropertyAccessor();

    public static PropertyAccessor getPropertyAccessor(Property property, EntityMode mode) throws MappingException {
        if (null == mode || EntityMode.POJO.equals(mode)) {
            return PropertyAccessorFactory.getPojoPropertyAccessor(property.getPropertyAccessorName());
        }
        if (EntityMode.MAP.equals(mode)) {
            return PropertyAccessorFactory.getDynamicMapPropertyAccessor();
        }
        if (EntityMode.DOM4J.equals(mode)) {
            return PropertyAccessorFactory.getDom4jPropertyAccessor(property.getAccessorPropertyName(mode), property.getType(), null);
        }
        throw new MappingException("Unknown entity mode [" + mode + "]");
    }

    private static PropertyAccessor getPojoPropertyAccessor(String pojoAccessorStrategy) {
        if (StringHelper.isEmpty(pojoAccessorStrategy) || "property".equals(pojoAccessorStrategy)) {
            return BASIC_PROPERTY_ACCESSOR;
        }
        if ("field".equals(pojoAccessorStrategy)) {
            return DIRECT_PROPERTY_ACCESSOR;
        }
        if ("embedded".equals(pojoAccessorStrategy)) {
            return EMBEDDED_PROPERTY_ACCESSOR;
        }
        if ("noop".equals(pojoAccessorStrategy)) {
            return NOOP_ACCESSOR;
        }
        return PropertyAccessorFactory.resolveCustomAccessor(pojoAccessorStrategy);
    }

    public static PropertyAccessor getDynamicMapPropertyAccessor() throws MappingException {
        return MAP_ACCESSOR;
    }

    public static PropertyAccessor getDom4jPropertyAccessor(String nodeName, Type type, SessionFactoryImplementor factory) throws MappingException {
        return new Dom4jAccessor(nodeName, type, factory);
    }

    private static PropertyAccessor resolveCustomAccessor(String accessorName) {
        Class accessorClass;
        try {
            accessorClass = ReflectHelper.classForName(accessorName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new MappingException("could not find PropertyAccessor class: " + accessorName, cnfe);
        }
        try {
            return (PropertyAccessor)accessorClass.newInstance();
        }
        catch (Exception e) {
            throw new MappingException("could not instantiate PropertyAccessor class: " + accessorName, e);
        }
    }

    private PropertyAccessorFactory() {
    }

    public static PropertyAccessor getPropertyAccessor(Class optionalClass, String type) throws MappingException {
        if (type == null) {
            type = optionalClass == null || optionalClass == Map.class ? "map" : "property";
        }
        return PropertyAccessorFactory.getPropertyAccessor(type);
    }

    public static PropertyAccessor getPropertyAccessor(String type) throws MappingException {
        if (type == null || "property".equals(type)) {
            return BASIC_PROPERTY_ACCESSOR;
        }
        if ("field".equals(type)) {
            return DIRECT_PROPERTY_ACCESSOR;
        }
        if ("map".equals(type)) {
            return MAP_ACCESSOR;
        }
        if ("embedded".equals(type)) {
            return EMBEDDED_PROPERTY_ACCESSOR;
        }
        if ("noop".equals(type)) {
            return NOOP_ACCESSOR;
        }
        return PropertyAccessorFactory.resolveCustomAccessor(type);
    }
}

