/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateLogger;
import org.hibernate.metamodel.relational.AbstractConstraint;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.Constraint;
import org.hibernate.metamodel.relational.Exportable;
import org.hibernate.metamodel.relational.TableSpecification;
import org.jboss.logging.Logger;

public class ForeignKey
extends AbstractConstraint
implements Constraint,
Exportable {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)ForeignKey.class.getName());
    private final TableSpecification targetTable;
    private List<Column> targetColumns;

    protected ForeignKey(TableSpecification sourceTable, TableSpecification targetTable, String name) {
        super(sourceTable, name);
        this.targetTable = targetTable;
    }

    protected ForeignKey(TableSpecification sourceTable, TableSpecification targetTable) {
        this(sourceTable, targetTable, null);
    }

    public TableSpecification getSourceTable() {
        return this.getTable();
    }

    public TableSpecification getTargetTable() {
        return this.targetTable;
    }

    public Iterable<Column> getSourceColumns() {
        return this.getColumns();
    }

    public Iterable<Column> getTargetColumns() {
        return this.targetColumns == null ? this.getTargetTable().getPrimaryKey().getColumns() : this.targetColumns;
    }

    @Override
    public void addColumn(Column column) {
        this.addColumnMapping(column, null);
    }

    public void addColumnMapping(Column sourceColumn, Column targetColumn) {
        if (targetColumn == null) {
            if (this.targetColumns != null) {
                LOG.attemptToMapColumnToNoTargetColumn(sourceColumn.toLoggableString(), this.getName());
            }
        } else {
            if (this.targetColumns == null) {
                if (!this.internalColumnAccess().isEmpty()) {
                    LOG.valueMappingMismatch(this.getTable().toLoggableString(), this.getName(), sourceColumn.toLoggableString());
                }
                this.targetColumns = new ArrayList<Column>();
            }
            this.targetColumns.add(targetColumn);
        }
        this.internalColumnAccess().add(sourceColumn);
    }

    @Override
    public String getExportIdentifier() {
        return this.getSourceTable().getLoggableValueQualifier() + ".FK-" + this.getName();
    }

    public void validate() {
        if (this.getSourceTable() == null) {
            // empty if block
        }
    }
}

