/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import org.hibernate.metamodel.relational.AbstractSimpleValue;
import org.hibernate.metamodel.relational.SimpleValue;
import org.hibernate.metamodel.relational.ValueContainer;

public class Column
extends AbstractSimpleValue
implements SimpleValue {
    private final String name;
    private Size size;

    protected Column(ValueContainer table, String name) {
        super(table);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Size getSize() {
        return this.size;
    }

    public void setSize(Size size) {
        this.size = size;
    }

    @Override
    public String toLoggableString() {
        return this.getValueContainer().getLoggableValueQualifier() + '.' + this.getName();
    }

    public static class Size {
        private final int precision;
        private final int scale;
        private final long length;
        private final LobMultiplier lobMultiplier;

        public Size(int precision, int scale, long length, LobMultiplier lobMultiplier) {
            this.precision = precision;
            this.scale = scale;
            this.length = length;
            this.lobMultiplier = lobMultiplier;
        }

        public static Size precision(int precision) {
            return new Size(precision, -1, -1L, null);
        }

        public static Size precision(int precision, int scale) {
            return new Size(precision, scale, -1L, null);
        }

        public static Size length(long length) {
            return new Size(-1, -1, length, null);
        }

        public static Size length(long length, LobMultiplier lobMultiplier) {
            return new Size(-1, -1, length, lobMultiplier);
        }

        public int getPrecision() {
            return this.precision;
        }

        public int getScale() {
            return this.scale;
        }

        public long getLength() {
            return this.length;
        }

        public LobMultiplier getLobMultiplier() {
            return this.lobMultiplier;
        }

        private static enum LobMultiplier {
            K,
            M,
            G;

        }
    }
}

