/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.Constraint;
import org.hibernate.metamodel.relational.TableSpecification;

public abstract class AbstractConstraint
implements Constraint {
    private final TableSpecification table;
    private final String name;
    private List<Column> columns = new ArrayList<Column>();

    protected AbstractConstraint(TableSpecification table, String name) {
        this.table = table;
        this.name = name;
    }

    @Override
    public TableSpecification getTable() {
        return this.table;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Iterable<Column> getColumns() {
        return this.columns;
    }

    protected List<Column> internalColumnAccess() {
        return this.columns;
    }

    public void addColumn(Column column) {
        if (column.getValueContainer() != this.getTable()) {
            throw new IllegalArgumentException("Unable to add column to constraint; tables did not match");
        }
        this.columns.add(column);
    }
}

