/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jmx;

import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.hibernate.HibernateLogger;
import org.hibernate.SessionFactory;
import org.hibernate.impl.SessionFactoryObjectFactory;
import org.hibernate.jmx.StatisticsServiceMBean;
import org.hibernate.stat.CollectionStatistics;
import org.hibernate.stat.EntityStatistics;
import org.hibernate.stat.QueryStatistics;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.stat.Statistics;
import org.hibernate.stat.StatisticsImpl;
import org.jboss.logging.Logger;

public class StatisticsService
implements StatisticsServiceMBean {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)StatisticsService.class.getName());
    SessionFactory sf;
    String sfJNDIName;
    Statistics stats = new StatisticsImpl();

    @Override
    public void setSessionFactoryJNDIName(String sfJNDIName) {
        this.sfJNDIName = sfJNDIName;
        try {
            Object obj = new InitialContext().lookup(sfJNDIName);
            if (obj instanceof Reference) {
                Reference ref = (Reference)obj;
                this.setSessionFactory((SessionFactory)SessionFactoryObjectFactory.getInstance((String)ref.get(0).getContent()));
            } else {
                this.setSessionFactory((SessionFactory)obj);
            }
        }
        catch (NameNotFoundException e) {
            LOG.noSessionFactoryWithJndiName(sfJNDIName, e);
            this.setSessionFactory(null);
        }
        catch (NamingException e) {
            LOG.unableToAccessSessionFactory(sfJNDIName, e);
            this.setSessionFactory(null);
        }
        catch (ClassCastException e) {
            LOG.jndiNameDoesNotHandleSessionFactoryReference(sfJNDIName, e);
            this.setSessionFactory(null);
        }
    }

    public void setSessionFactory(SessionFactory sf) {
        this.sf = sf;
        this.stats = sf == null ? new StatisticsImpl() : sf.getStatistics();
    }

    @Override
    public void clear() {
        this.stats.clear();
    }

    @Override
    public EntityStatistics getEntityStatistics(String entityName) {
        return this.stats.getEntityStatistics(entityName);
    }

    @Override
    public CollectionStatistics getCollectionStatistics(String role) {
        return this.stats.getCollectionStatistics(role);
    }

    @Override
    public SecondLevelCacheStatistics getSecondLevelCacheStatistics(String regionName) {
        return this.stats.getSecondLevelCacheStatistics(regionName);
    }

    @Override
    public QueryStatistics getQueryStatistics(String hql) {
        return this.stats.getQueryStatistics(hql);
    }

    @Override
    public long getEntityDeleteCount() {
        return this.stats.getEntityDeleteCount();
    }

    @Override
    public long getEntityInsertCount() {
        return this.stats.getEntityInsertCount();
    }

    @Override
    public long getEntityLoadCount() {
        return this.stats.getEntityLoadCount();
    }

    @Override
    public long getEntityFetchCount() {
        return this.stats.getEntityFetchCount();
    }

    @Override
    public long getEntityUpdateCount() {
        return this.stats.getEntityUpdateCount();
    }

    @Override
    public long getQueryExecutionCount() {
        return this.stats.getQueryExecutionCount();
    }

    @Override
    public long getQueryCacheHitCount() {
        return this.stats.getQueryCacheHitCount();
    }

    @Override
    public long getQueryExecutionMaxTime() {
        return this.stats.getQueryExecutionMaxTime();
    }

    @Override
    public long getQueryCacheMissCount() {
        return this.stats.getQueryCacheMissCount();
    }

    @Override
    public long getQueryCachePutCount() {
        return this.stats.getQueryCachePutCount();
    }

    @Override
    public long getFlushCount() {
        return this.stats.getFlushCount();
    }

    @Override
    public long getConnectCount() {
        return this.stats.getConnectCount();
    }

    @Override
    public long getSecondLevelCacheHitCount() {
        return this.stats.getSecondLevelCacheHitCount();
    }

    @Override
    public long getSecondLevelCacheMissCount() {
        return this.stats.getSecondLevelCacheMissCount();
    }

    @Override
    public long getSecondLevelCachePutCount() {
        return this.stats.getSecondLevelCachePutCount();
    }

    @Override
    public long getSessionCloseCount() {
        return this.stats.getSessionCloseCount();
    }

    @Override
    public long getSessionOpenCount() {
        return this.stats.getSessionOpenCount();
    }

    @Override
    public long getCollectionLoadCount() {
        return this.stats.getCollectionLoadCount();
    }

    @Override
    public long getCollectionFetchCount() {
        return this.stats.getCollectionFetchCount();
    }

    @Override
    public long getCollectionUpdateCount() {
        return this.stats.getCollectionUpdateCount();
    }

    @Override
    public long getCollectionRemoveCount() {
        return this.stats.getCollectionRemoveCount();
    }

    @Override
    public long getCollectionRecreateCount() {
        return this.stats.getCollectionRecreateCount();
    }

    @Override
    public long getStartTime() {
        return this.stats.getStartTime();
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.stats.isStatisticsEnabled();
    }

    @Override
    public void setStatisticsEnabled(boolean enable) {
        this.stats.setStatisticsEnabled(enable);
    }

    @Override
    public void logSummary() {
        this.stats.logSummary();
    }

    @Override
    public String[] getCollectionRoleNames() {
        return this.stats.getCollectionRoleNames();
    }

    @Override
    public String[] getEntityNames() {
        return this.stats.getEntityNames();
    }

    @Override
    public String[] getQueries() {
        return this.stats.getQueries();
    }

    @Override
    public String[] getSecondLevelCacheRegionNames() {
        return this.stats.getSecondLevelCacheRegionNames();
    }

    @Override
    public long getSuccessfulTransactionCount() {
        return this.stats.getSuccessfulTransactionCount();
    }

    @Override
    public long getTransactionCount() {
        return this.stats.getTransactionCount();
    }

    @Override
    public long getCloseStatementCount() {
        return this.stats.getCloseStatementCount();
    }

    @Override
    public long getPrepareStatementCount() {
        return this.stats.getPrepareStatementCount();
    }

    @Override
    public long getOptimisticFailureCount() {
        return this.stats.getOptimisticFailureCount();
    }

    @Override
    public String getQueryExecutionMaxTimeQueryString() {
        return this.stats.getQueryExecutionMaxTimeQueryString();
    }
}

