/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.jndi;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.hibernate.HibernateLogger;
import org.hibernate.internal.util.jndi.JndiException;
import org.jboss.logging.Logger;

public final class JndiHelper {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)JndiHelper.class.getName());

    private JndiHelper() {
    }

    public static Properties extractJndiProperties(Map configurationValues) {
        Properties jndiProperties = new Properties();
        for (Map.Entry entry : configurationValues.entrySet()) {
            if (!String.class.isInstance(entry.getKey())) continue;
            String propertyName = (String)entry.getKey();
            Object propertyValue = entry.getValue();
            if (!propertyName.startsWith("hibernate.jndi")) continue;
            if ("hibernate.jndi.class".equals(propertyName)) {
                if (propertyValue == null) continue;
                jndiProperties.put("java.naming.factory.initial", propertyValue);
                continue;
            }
            if ("hibernate.jndi.url".equals(propertyName)) {
                if (propertyValue == null) continue;
                jndiProperties.put("java.naming.provider.url", propertyValue);
                continue;
            }
            String passThruPropertyname = propertyName.substring("hibernate.jndi".length() + 1);
            jndiProperties.put(passThruPropertyname, propertyValue);
        }
        return jndiProperties;
    }

    public static Object locate(String jndiName, Context context) {
        try {
            return context.lookup(jndiName);
        }
        catch (NamingException e) {
            throw new JndiException("Unable to lookup JNDI name [" + jndiName + "]", e);
        }
    }

    public static void bind(String jndiName, Object value, Context context) {
        try {
            LOG.trace("Binding : " + jndiName);
            context.rebind(jndiName, value);
        }
        catch (Exception initialException) {
            Name n = JndiHelper.tokenizeName(jndiName, context);
            Context intermediateContextBase = context;
            while (n.size() > 1) {
                String intermediateContextName = n.get(0);
                Context intermediateContext = null;
                try {
                    LOG.trace("Intermediate lookup: " + intermediateContextName);
                    intermediateContext = (Context)intermediateContextBase.lookup(intermediateContextName);
                }
                catch (NameNotFoundException handledBelow) {
                }
                catch (NamingException e) {
                    throw new JndiException("Unaniticipated error doing intermediate lookup", e);
                }
                if (intermediateContext != null) {
                    LOG.trace("Found intermediate context: " + intermediateContextName);
                } else {
                    LOG.trace("Creating subcontext: " + intermediateContextName);
                    try {
                        intermediateContext = intermediateContextBase.createSubcontext(intermediateContextName);
                    }
                    catch (NamingException e) {
                        throw new JndiException("Error creating intermediate context [" + intermediateContextName + "]", e);
                    }
                }
                intermediateContextBase = intermediateContext;
                n = n.getSuffix(1);
            }
            LOG.trace("Binding : " + n);
            try {
                intermediateContextBase.rebind(n, value);
            }
            catch (NamingException e) {
                throw new JndiException("Error performing intermediate bind [" + n + "]", e);
            }
        }
        LOG.debugf("Bound name: %s", jndiName);
    }

    private static Name tokenizeName(String jndiName, Context context) {
        try {
            return context.getNameParser("").parse(jndiName);
        }
        catch (NamingException e) {
            throw new JndiException("Unable to tokenize JNDI name [" + jndiName + "]", e);
        }
    }

    public static InitialContext getInitialContext(Properties props) throws NamingException {
        Properties hash = JndiHelper.extractJndiProperties(props);
        LOG.jndiInitialContextProperties(hash);
        try {
            return ((Hashtable)hash).size() == 0 ? new InitialContext() : new InitialContext(hash);
        }
        catch (NamingException e) {
            LOG.unableToObtainInitialContext(e);
            throw e;
        }
    }

    public static void bind(Context ctx, String name, Object val) throws NamingException {
        try {
            LOG.trace("Binding : " + name);
            ctx.rebind(name, val);
        }
        catch (Exception e) {
            Name n = ctx.getNameParser("").parse(name);
            while (n.size() > 1) {
                String ctxName = n.get(0);
                Context subctx = null;
                try {
                    LOG.trace("Lookup: " + ctxName);
                    subctx = (Context)ctx.lookup(ctxName);
                }
                catch (NameNotFoundException nfe) {
                    // empty catch block
                }
                if (subctx != null) {
                    LOG.debugf("Found subcontext: %s", ctxName);
                    ctx = subctx;
                } else {
                    LOG.creatingSubcontextInfo(ctxName);
                    ctx = ctx.createSubcontext(ctxName);
                }
                n = n.getSuffix(1);
            }
            LOG.trace("Binding : " + n);
            ctx.rebind(n, val);
        }
        LOG.debugf("Bound name: %s", name);
    }
}

