/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.event.EventContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.spi.ObjectFactory;
import org.hibernate.HibernateLogger;
import org.hibernate.SessionFactory;
import org.hibernate.internal.util.jndi.JndiHelper;
import org.jboss.logging.Logger;

public class SessionFactoryObjectFactory
implements ObjectFactory {
    private static final SessionFactoryObjectFactory INSTANCE;
    private static final HibernateLogger LOG;
    private static final ConcurrentHashMap<String, SessionFactory> INSTANCES;
    private static final ConcurrentHashMap<String, SessionFactory> NAMED_INSTANCES;
    private static final NamingListener LISTENER;

    public Object getObjectInstance(Object reference, Name name, Context ctx, Hashtable env) throws Exception {
        LOG.debugf("JNDI lookup: %s", name);
        String uid = (String)((Reference)reference).get(0).getContent();
        return SessionFactoryObjectFactory.getInstance(uid);
    }

    public static void addInstance(String uid, String name, SessionFactory instance, Properties properties) {
        LOG.debugf("Registered: %s (%s)", uid, name == null ? "<unnamed>" : name);
        INSTANCES.put(uid, instance);
        if (name != null) {
            NAMED_INSTANCES.put(name, instance);
        }
        if (name == null) {
            LOG.notBindingFactoryToJndi();
        } else {
            LOG.factoryName(name);
            try {
                InitialContext ctx = JndiHelper.getInitialContext(properties);
                JndiHelper.bind(ctx, name, instance);
                LOG.factoryBoundToJndiName(name);
                ((EventContext)((Object)ctx)).addNamingListener(name, 0, LISTENER);
            }
            catch (InvalidNameException ine) {
                LOG.invalidJndiName(name, ine);
            }
            catch (NamingException ne) {
                LOG.unableToBindFactoryToJndi(ne);
            }
            catch (ClassCastException cce) {
                LOG.initialContextDidNotImplementEventContext();
            }
        }
    }

    public static void removeInstance(String uid, String name, Properties properties) {
        if (name != null) {
            LOG.unbindingFactoryFromJndiName(name);
            try {
                InitialContext ctx = JndiHelper.getInitialContext(properties);
                ctx.unbind(name);
                LOG.factoryUnboundFromJndiName(name);
            }
            catch (InvalidNameException ine) {
                LOG.invalidJndiName(name, ine);
            }
            catch (NamingException ne) {
                LOG.unableToUnbindFactoryFromJndi(ne);
            }
            NAMED_INSTANCES.remove(name);
        }
        INSTANCES.remove(uid);
    }

    public static Object getNamedInstance(String name) {
        LOG.debugf("Lookup: name=%s", name);
        SessionFactory result = NAMED_INSTANCES.get(name);
        if (result == null) {
            LOG.debugf("Not found: %s", name);
            LOG.debugf(NAMED_INSTANCES.toString(), new Object[0]);
        }
        return result;
    }

    public static Object getInstance(String uid) {
        LOG.debugf("Lookup: uid=%s", uid);
        SessionFactory result = INSTANCES.get(uid);
        if (result == null) {
            LOG.debugf("Not found: %s", uid);
            LOG.debugf(INSTANCES.toString(), new Object[0]);
        }
        return result;
    }

    static {
        LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)SessionFactoryObjectFactory.class.getName());
        INSTANCE = new SessionFactoryObjectFactory();
        LOG.debugf("Initializing class SessionFactoryObjectFactory", new Object[0]);
        INSTANCES = new ConcurrentHashMap();
        NAMED_INSTANCES = new ConcurrentHashMap();
        LISTENER = new NamespaceChangeListener(){

            @Override
            public void objectAdded(NamingEvent evt) {
                LOG.debugf("A factory was successfully bound to name: %s", evt.getNewBinding().getName());
            }

            @Override
            public void objectRemoved(NamingEvent evt) {
                String name = evt.getOldBinding().getName();
                LOG.factoryUnboundFromName(name);
                Object instance = NAMED_INSTANCES.remove(name);
                Iterator iter = INSTANCES.values().iterator();
                while (iter.hasNext()) {
                    if (iter.next() != instance) continue;
                    iter.remove();
                }
            }

            @Override
            public void objectRenamed(NamingEvent evt) {
                String name = evt.getOldBinding().getName();
                LOG.factoryRenamedFromName(name);
                NAMED_INSTANCES.put(evt.getNewBinding().getName(), NAMED_INSTANCES.remove(name));
            }

            @Override
            public void namingExceptionThrown(NamingExceptionEvent evt) {
                LOG.namingExceptionAccessingFactory(evt.getException());
            }
        };
    }
}

