/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionException;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.query.HQLQueryPlan;
import org.hibernate.engine.query.NativeSQLQueryPlan;
import org.hibernate.engine.query.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.transaction.spi.TransactionContext;
import org.hibernate.engine.transaction.spi.TransactionEnvironment;
import org.hibernate.impl.AbstractQueryImpl;
import org.hibernate.impl.QueryImpl;
import org.hibernate.impl.SQLQueryImpl;
import org.hibernate.impl.SessionFactoryImpl;

public abstract class AbstractSessionImpl
implements Serializable,
SessionImplementor,
TransactionContext {
    protected transient SessionFactoryImpl factory;
    private boolean closed = false;

    protected AbstractSessionImpl(SessionFactoryImpl factory) {
        this.factory = factory;
    }

    @Override
    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    @Override
    public TransactionEnvironment getTransactionEnvironment() {
        return this.factory.getTransactionEnvironment();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    protected void setClosed() {
        this.closed = true;
    }

    protected void errorIfClosed() {
        if (this.closed) {
            throw new SessionException("Session is closed!");
        }
    }

    @Override
    public Query getNamedQuery(String queryName) throws MappingException {
        AbstractQueryImpl query;
        this.errorIfClosed();
        NamedQueryDefinition nqd = this.factory.getNamedQuery(queryName);
        if (nqd != null) {
            String queryString = nqd.getQueryString();
            query = new QueryImpl(queryString, nqd.getFlushMode(), this, this.getHQLQueryPlan(queryString, false).getParameterMetadata());
            query.setComment("named HQL query " + queryName);
        } else {
            NamedSQLQueryDefinition nsqlqd = this.factory.getNamedSQLQuery(queryName);
            if (nsqlqd == null) {
                throw new MappingException("Named query not known: " + queryName);
            }
            query = new SQLQueryImpl(nsqlqd, (SessionImplementor)this, this.factory.getQueryPlanCache().getSQLParameterMetadata(nsqlqd.getQueryString()));
            query.setComment("named native SQL query " + queryName);
            nqd = nsqlqd;
        }
        this.initQuery(query, nqd);
        return query;
    }

    @Override
    public Query getNamedSQLQuery(String queryName) throws MappingException {
        this.errorIfClosed();
        NamedSQLQueryDefinition nsqlqd = this.factory.getNamedSQLQuery(queryName);
        if (nsqlqd == null) {
            throw new MappingException("Named SQL query not known: " + queryName);
        }
        SQLQueryImpl query = new SQLQueryImpl(nsqlqd, (SessionImplementor)this, this.factory.getQueryPlanCache().getSQLParameterMetadata(nsqlqd.getQueryString()));
        query.setComment("named native SQL query " + queryName);
        this.initQuery(query, nsqlqd);
        return query;
    }

    private void initQuery(Query query, NamedQueryDefinition nqd) {
        query.setCacheable(nqd.isCacheable());
        query.setCacheRegion(nqd.getCacheRegion());
        if (nqd.getTimeout() != null) {
            query.setTimeout(nqd.getTimeout());
        }
        if (nqd.getFetchSize() != null) {
            query.setFetchSize(nqd.getFetchSize());
        }
        if (nqd.getCacheMode() != null) {
            query.setCacheMode(nqd.getCacheMode());
        }
        query.setReadOnly(nqd.isReadOnly());
        if (nqd.getComment() != null) {
            query.setComment(nqd.getComment());
        }
    }

    public Query createQuery(String queryString) {
        this.errorIfClosed();
        QueryImpl query = new QueryImpl(queryString, this, this.getHQLQueryPlan(queryString, false).getParameterMetadata());
        query.setComment(queryString);
        return query;
    }

    public SQLQuery createSQLQuery(String sql) {
        this.errorIfClosed();
        SQLQueryImpl query = new SQLQueryImpl(sql, (SessionImplementor)this, this.factory.getQueryPlanCache().getSQLParameterMetadata(sql));
        query.setComment("dynamic native SQL query");
        return query;
    }

    protected HQLQueryPlan getHQLQueryPlan(String query, boolean shallow) throws HibernateException {
        return this.factory.getQueryPlanCache().getHQLQueryPlan(query, shallow, this.getEnabledFilters());
    }

    protected NativeSQLQueryPlan getNativeSQLQueryPlan(NativeSQLQuerySpecification spec) throws HibernateException {
        return this.factory.getQueryPlanCache().getNativeSQLQueryPlan(spec);
    }

    @Override
    public List list(NativeSQLQuerySpecification spec, QueryParameters queryParameters) throws HibernateException {
        return this.listCustomQuery(this.getNativeSQLQueryPlan(spec).getCustomQuery(), queryParameters);
    }

    @Override
    public ScrollableResults scroll(NativeSQLQuerySpecification spec, QueryParameters queryParameters) throws HibernateException {
        return this.scrollCustomQuery(this.getNativeSQLQueryPlan(spec).getCustomQuery(), queryParameters);
    }
}

